/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.custom;

import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerProcess;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration;
import com.intellij.clion.embedded.execution.custom.McuResetActionKt;
import com.intellij.clion.embedded.execution.custom.TargetResetType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbWithGdbServerProcess;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class CustomGdbServerLauncher
extends GdbServerLauncher {
    public static final String DOWNLOAD_CMD = "-target-download";

    public CustomGdbServerLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull CustomGdbServerRunConfiguration configuration, @NotNull CPPToolchains.Toolchain debuggerToolchain) {
        if (executionEnvironment == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(1);
        }
        if (debuggerToolchain == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(2);
        }
        super(executionEnvironment, (GdbServerRunConfiguration)configuration, debuggerToolchain);
    }

    @NotNull
    protected GdbWithGdbServerProcess createGdbServerProcess(@NotNull RunParameters runParameters, @NotNull CidrRemoteDebugParameters remoteParameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        if (runParameters == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(3);
        }
        if (remoteParameters == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(4);
        }
        if (session == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(5);
        }
        if (consoleBuilder == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(6);
        }
        return new CustomGdbServerProcess(runParameters, remoteParameters, session, consoleBuilder);
    }

    @NotNull
    protected List<String> getAdditionalCommands(@NotNull File symbolFile) {
        CustomGdbServerRunConfiguration configuration;
        if (symbolFile == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(7);
        }
        if (this.haveToBeDownloaded((configuration = (CustomGdbServerRunConfiguration)this.getConfiguration()).getDownloadType(), symbolFile)) {
            String resetCommand = configuration.getResetCommand();
            TargetResetType resetType = configuration.getResetType();
            if (StringUtil.isNotEmpty((String)resetCommand) && resetType != TargetResetType.NEVER) {
                ArrayList<String> additionalCommands = new ArrayList<String>();
                String gdbResetCommand = GDBDriver.createConsoleCommand((String)resetCommand);
                if (resetType == TargetResetType.BEFORE_DOWNLOAD || resetType == TargetResetType.BOTH_TIMES) {
                    additionalCommands.add(gdbResetCommand);
                }
                additionalCommands.add(DOWNLOAD_CMD);
                if (resetType == TargetResetType.AFTER_DOWNLOAD || resetType == TargetResetType.BOTH_TIMES) {
                    additionalCommands.add(gdbResetCommand);
                }
                ArrayList<String> arrayList = additionalCommands;
                if (arrayList == null) {
                    CustomGdbServerLauncher.$$$reportNull$$$0(8);
                }
                return arrayList;
            }
            List<String> list = Collections.singletonList(DOWNLOAD_CMD);
            if (list == null) {
                CustomGdbServerLauncher.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected BaseProcessHandler<?> createGdbServerProcess(@NotNull GeneralCommandLine gdbServerCommandLine) throws ExecutionException {
        if (gdbServerCommandLine == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(11);
        }
        EmbeddedUsagesCollector.triggerGdbServerRun(this.getProject(), gdbServerCommandLine.getExePath());
        return super.createGdbServerProcess(gdbServerCommandLine);
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<? super AnAction> actions) throws ExecutionException {
        if (state == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(12);
        }
        if (processHandler == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(13);
        }
        if (console == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(14);
        }
        if (actions == null) {
            CustomGdbServerLauncher.$$$reportNull$$$0(15);
        }
        super.collectAdditionalActions(state, processHandler, console, actions);
        AnAction resetAction = ActionManager.getInstance().getAction("intellij.clion.embedded.mcu.reset");
        if (resetAction != null) {
            String command = ((CustomGdbServerRunConfiguration)this.getConfiguration()).getResetCommand().trim();
            processHandler.putUserData(McuResetActionKt.RESET_COMMAND, (Object)command);
            actions.add((AnAction)resetAction);
        } else {
            Logger.getLogger(CustomGdbServerLauncher.class.getName()).severe("MCU Reset Action not found");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerToolchain";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerLauncher";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServerCommandLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerLauncher";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGdbServerProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalCommands";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

