/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface OCGotoTest {
    public CidrProjectFixture getProjectFixture();

    public void doTest(Pair<String, Integer> var1, Pair<String, Integer> ... var2) throws Exception;

    default public void doTest(String sourceFileName, int sourceOffset, String targetFileName, int targetOffset) throws Exception {
        this.doTest((Pair<String, Integer>)new Pair((Object)sourceFileName, (Object)sourceOffset), new Pair((Object)targetFileName, (Object)targetOffset));
    }

    default public void doTest(String sourceFileName, int sourceOffset, String targetFile1Name, int target1Offset, String targetFile2Name, int target2Offset) throws Exception {
        this.doTest((Pair<String, Integer>)new Pair((Object)sourceFileName, (Object)sourceOffset), new Pair((Object)targetFile1Name, (Object)target1Offset), new Pair((Object)targetFile2Name, (Object)target2Offset));
    }

    @NotNull
    default public PsiElement findElement(String fileName, int offset, Project project2) {
        VirtualFile file2 = this.getProjectFixture().findProjectSubFile(fileName);
        UsefulTestCase.assertNotNull((Object)file2);
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        UsefulTestCase.assertNotNull((Object)psiFile);
        PsiElement element = psiFile.findElementAt(offset);
        UsefulTestCase.assertNotNull((Object)element);
        PsiElement psiElement = element;
        if (psiElement == null) {
            OCGotoTest.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    default public void assertTargetSymbols(@NotNull Collection<? extends OCSymbol> targets, Pair<String, Integer> @NotNull [] expectedTargets) {
        if (targets == null) {
            OCGotoTest.$$$reportNull$$$0(1);
        }
        if (expectedTargets == null) {
            OCGotoTest.$$$reportNull$$$0(2);
        }
        Project project2 = this.getProjectFixture().getProject();
        this.assertTargets(ContainerUtil.map(targets, s -> s.locateDefinition(project2)), expectedTargets);
    }

    default public void assertTargets(@NotNull List<PsiElement> targets, Pair<String, Integer> @NotNull [] expectedTargets) {
        if (targets == null) {
            OCGotoTest.$$$reportNull$$$0(3);
        }
        if (expectedTargets == null) {
            OCGotoTest.$$$reportNull$$$0(4);
        }
        targets.sort(Comparator.comparingInt(PsiElement::getTextOffset));
        Project project2 = this.getProjectFixture().getProject();
        UsefulTestCase.assertEquals((int)expectedTargets.length, (int)targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            PsiElement expectedTarget = this.findElement((String)expectedTargets[i].first, (Integer)expectedTargets[i].second, project2);
            PsiElement target2 = targets.get(i);
            UsefulTestCase.assertEquals((String)"Target mismatch", (String)expectedTarget.getContainingFile().getName(), (String)target2.getContainingFile().getName());
            UsefulTestCase.assertEquals((String)"Target mismatch", (int)expectedTarget.getTextOffset(), (int)target2.getTextOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/navigation/OCGotoTest";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoTest";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertTargetSymbols";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

