/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMockWorkspace
extends CidrWorkspace {
    @NotNull
    private final OCWorkspaceImpl myDelegate;
    @NotNull
    private final String myClientKey;
    @NotNull
    private final Set<VirtualFile> myAdditionalSourceFiles;
    @NotNull
    private final Set<VirtualFile> myGeneratedSourceFiles;
    private boolean myContentRootAsSourceFolder;

    public OCMockWorkspace(@NotNull OCWorkspaceImpl delegate, @NotNull String clientKey, @Nullable VirtualFile contentRoot) {
        if (delegate == null) {
            OCMockWorkspace.$$$reportNull$$$0(0);
        }
        if (clientKey == null) {
            OCMockWorkspace.$$$reportNull$$$0(1);
        }
        super(delegate.getProject());
        this.myAdditionalSourceFiles = new HashSet<VirtualFile>();
        this.myGeneratedSourceFiles = new HashSet<VirtualFile>();
        this.myContentRootAsSourceFolder = true;
        this.myDelegate = delegate;
        this.myClientKey = clientKey;
        this.myContentRoot = contentRoot != null ? VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot) : null;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                OCMockWorkspace.this.updateRoots();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/fixtures/OCMockWorkspace$1", "workspaceChanged"));
            }
        });
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                if (!ApplicationManager.getApplication().isDisposed()) {
                    OCMockWorkspace.this.unload(true);
                }
            }
        });
    }

    void initialized() {
        super.initializeAndStart();
        CidrWorkspaceManager.getInstance((Project)this.myProject).markInitialized((CidrWorkspace)this);
        CidrWorkspaceManager.getInstance((Project)this.myProject).markLoaded((CidrWorkspace)this);
        this.myDelegate.setInitialized();
        this.updateRoots();
        this.myDelegate.fireWorkspaceInitializedEvent();
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        return contentRoot;
    }

    protected boolean shouldEnableRootConfiguration() {
        return false;
    }

    public void setContentRootAsSourceFolder(boolean value2) {
        this.myContentRootAsSourceFolder = value2;
        this.updateRoots();
    }

    @Nullable
    public OCLanguageKind addSourceFile(@NotNull VirtualFile file2, @Nullable OCLanguageKind forcedKind, OCResolveConfiguration.ModifiableModel ... addTo) {
        String fileName;
        if (file2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(2);
        }
        if (!OCFileTypeHelpers.isHeaderFile((String)(fileName = file2.getName()))) {
            OCLanguageKind kind;
            OCLanguageKind oCLanguageKind = kind = forcedKind != null ? forcedKind : OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)this.myProject, (String)fileName);
            if (kind == null) {
                CidrLog.LOG.warn("Unknown language kind for " + fileName);
            } else {
                for (OCResolveConfiguration.ModifiableModel eachConfig : addTo) {
                    eachConfig.addSource(file2, kind);
                }
                return kind;
            }
        }
        this.myAdditionalSourceFiles.add(file2);
        return null;
    }

    public void removeSourceFile(@NotNull VirtualFile file2, @NotNull OCWorkspace.ModifiableModel model2) {
        if (file2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(3);
        }
        if (model2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(4);
        }
        model2.getConfigurations().forEach(it -> it.removeSource(file2));
        this.myAdditionalSourceFiles.remove(file2);
    }

    public void addGeneratedSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(5);
        }
        this.myGeneratedSourceFiles.add(file2);
    }

    @NotNull
    public OCWorkspace getDelegate() {
        OCWorkspaceImpl oCWorkspaceImpl = this.myDelegate;
        if (oCWorkspaceImpl == null) {
            OCMockWorkspace.$$$reportNull$$$0(6);
        }
        return oCWorkspaceImpl;
    }

    @NotNull
    public String getClientKey() {
        String string = this.myClientKey;
        if (string == null) {
            OCMockWorkspace.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        ArrayList<File> additionalSourceFiles = new ArrayList<File>(VfsUtilCore.virtualToIoFiles(this.myAdditionalSourceFiles));
        if (this.myContentRootAsSourceFolder) {
            additionalSourceFiles.add(contentRoot);
        }
        OCRootsSynchronizer.RootsInfo info = CidrWorkspace.createRootsInfo((List)this.myDelegate.getConfigurations(this.myClientKey), (List)CollectionsKt.listOfNotNull((Object)contentRoot), additionalSourceFiles, (List)VfsUtilCore.virtualToIoFiles(this.myGeneratedSourceFiles));
        info.registerSystemHeaderRootUnderContentRootAsLibraries = true;
        OCRootsSynchronizer.RootsInfo rootsInfo = info;
        if (rootsInfo == null) {
            OCMockWorkspace.$$$reportNull$$$0(8);
        }
        return rootsInfo;
    }

    void updateRoots() {
        if (!this.isInitialized() || this.myContentRoot == null) {
            return;
        }
        try {
            ((AppUIExecutor)AppUIExecutor.onWriteThread().expireWith((Disposable)this.myProject)).submit(() -> WriteAction.run(() -> this.updateContentRoots())).get();
        }
        catch (Throwable e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public static void applyDefaultDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model2) {
        if (languageKind == null) {
            OCMockWorkspace.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(10);
        }
        OCMockWorkspace.applyDefinesAndFeatures(languageKind, model2, new CompilerSettingsData(null, null, null, null));
    }

    static void applyDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model2, @NotNull CompilerSettingsData data) {
        if (languageKind == null) {
            OCMockWorkspace.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            OCMockWorkspace.$$$reportNull$$$0(12);
        }
        if (data == null) {
            OCMockWorkspace.$$$reportNull$$$0(13);
        }
        HashMap<Object, Boolean> allFeatures = new HashMap<Object, Boolean>();
        ArrayList<Object> allDefines = new ArrayList<Object>();
        if (languageKind.isObjC()) {
            allDefines.add("#define __OBJC__");
            allDefines.add("#define __objc_no ((BOOL)0)");
            allDefines.add("#define __objc_yes ((BOOL)1)");
            for (OCCompilerFeatures.Feature each : OCCompilerFeatures.Feature.values()) {
                if (!StringUtil.startsWithIgnoreCase((String)each.name(), (String)"OBJC_")) continue;
                allFeatures.put(each, true);
            }
        }
        if (languageKind.isCpp()) {
            OCLanguageStandard std = OCLanguageStandard.latestCpp();
            String string = OCLanguageStandard.latestCppValue();
            allDefines.add("#define __cplusplus " + string);
            for (OCCompilerFeatures.Feature each : OCCompilerFeatures.Feature.values()) {
                if (!StringUtil.startsWithIgnoreCase((String)each.name(), (String)"CXX_")) continue;
                OCLanguageStandard featureStandard = each.getAvailableInStandard();
                allFeatures.put(each, featureStandard != null && std.supports(featureStandard));
            }
        }
        if (!languageKind.isCpp() && !languageKind.isCuda()) {
            allDefines.add("#define __STDC_VERSION__ " + OCLanguageStandard.latestCValue());
        }
        if (data.features != null) {
            allFeatures.putAll(data.features);
        }
        if (data.defines != null) {
            allDefines.addAll(data.defines);
        }
        allDefines.addAll(GCCCompiler.getClangTestMacros());
        allDefines.addAll(GCCCompiler.getGCCBuiltInFunctionMacros());
        for (Map.Entry entry : allFeatures.entrySet()) {
            String clangId;
            if (!(entry.getKey() instanceof OCCompilerFeatures.Feature) || (clangId = ClangFeatures.getClangIdForFeature((OCCompilerFeatures.Feature)((OCCompilerFeatures.Feature)entry.getKey()))) == null) continue;
            String featureMacro = GCCCompiler.clangFeatureMacro((String)clangId);
            String featureMacroValue = Boolean.TRUE.equals(entry.getValue()) ? "1" : "0";
            allDefines.add(String.format("#define %s %s", featureMacro, featureMacroValue));
        }
        model2.setPreprocessorDefines(allDefines);
        model2.setCompilerFeatures(allFeatures);
        model2.setCompilerSwitches(data.switches);
        model2.setImplicitIncludes(data.implicitIncludes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientKey";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCMockWorkspace";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCMockWorkspace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addGeneratedSourceFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyDefaultDefinesAndFeatures";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyDefinesAndFeatures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    static class CompilerSettingsData {
        @Nullable
        List<String> defines;
        @Nullable
        Map<OCCompilerFeatures.Type<?>, ?> features;
        @Nullable
        CidrCompilerSwitches switches;
        @Nullable
        List<VirtualFile> implicitIncludes;

        CompilerSettingsData(@Nullable List<String> defines, @Nullable Map<OCCompilerFeatures.Type<?>, ?> features, @Nullable CidrCompilerSwitches switches, @Nullable List<VirtualFile> implicitIncludes) {
            this.defines = defines;
            this.features = features;
            this.switches = switches;
            this.implicitIncludes = implicitIncludes;
        }
    }
}

