/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrDebuggingFixtureMarker;
import com.jetbrains.cidr.CidrProjectFixtureBase;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.TimeoutAssertionFailedError;
import com.jetbrains.cidr.execution.debugger.BasicDebuggerTest;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegistersValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrDebuggingFixture<EXECUTION_FIXTURE extends CidrExecutionFixture<?>>
extends Assert
implements CidrDebuggingFixtureMarker {
    public static final Key<ArrayDeque<DebuggerState>> DEBUG_STATE_LOGS_KEY = Key.create((String)"DEBUG_STATE_LOGS_KEY");
    @Language(value="RegExp")
    public static final String HEX_ADDRESS_PATTERN_STRING = "0x\\p{XDigit}+";
    public static final int TIMEOUT = 25000;
    public static final int EVAL_TIMEOUT = 50000;
    public static final int OUTPUT_TIMEOUT = 5000;
    public static final int CHECK_NO_EVENT_DELAY = 200;
    public static final float EPSF = 0.001f;
    public static final double EPSD = 1.0E-5;
    @NotNull
    protected final DebuggerDriverKind myDriverKind;
    protected EXECUTION_FIXTURE myExecutionFixture;
    protected boolean myDestroyPreviousProcessOnStart;
    protected XDebugSession mySession;
    protected CidrDebugProcess myDebugProcess;
    private final List<CidrDebugProcess> myAllProcesses;
    protected DebuggerDriver myDriver;
    protected DebuggerDriverConfiguration myDriverConfiguration;
    protected final EventDispatcher<DebuggerDriver.Handler> myDriverHandlerEventDispatcher;
    protected boolean isStarted;
    private final Disposable myDisposable;

    protected CidrDebuggingFixture(@NotNull DebuggerDriverKind driverKind, @NotNull EXECUTION_FIXTURE fixture) {
        if (driverKind == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(0);
        }
        if (fixture == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(1);
        }
        this.myDestroyPreviousProcessOnStart = true;
        this.myAllProcesses = new ArrayList<CidrDebugProcess>();
        this.myDriverHandlerEventDispatcher = EventDispatcher.create(DebuggerDriver.Handler.class);
        this.myDisposable = Disposer.newDisposable();
        this.myDriverKind = driverKind;
        this.myExecutionFixture = fixture;
    }

    public void setDestroyPreviousProcessOnStart(boolean destroyPreviousProcessOnStart) {
        this.myDestroyPreviousProcessOnStart = destroyPreviousProcessOnStart;
    }

    @NotNull
    public CidrToolEnvironment getEnvironment() {
        return new CidrToolEnvironment();
    }

    @NotNull
    public File getGdbserverExecutable() {
        throw new UnsupportedOperationException("Implement this method to enable remote debugging tests");
    }

    @NotNull
    protected String toAppEnvPath(@NotNull String path) {
        if (path == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(2);
        }
        String string = path;
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public abstract DebuggerDriverConfiguration createDriverConfiguration(@Nullable Function.Mono<GeneralCommandLine> var1);

    @NotNull
    protected abstract ArchitectureType getArchitectureType();

    public CidrDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public XDebugSession getSession() {
        return this.mySession;
    }

    public DebuggerDriver getDriver() {
        return this.myDriver;
    }

    public DebuggerDriverConfiguration getDriverConfiguration() {
        return this.myDriverConfiguration;
    }

    @Override
    public void setUp() {
    }

    public boolean isMSVCRuntime() {
        return SystemInfo.isWindows && this.myDriverKind == DebuggerDriverKind.LLDB;
    }

    public boolean isOCDebuggingSupported() {
        return true;
    }

    public boolean isExceptionCatchBreakpointsSupported() {
        return !this.isMSVCRuntime();
    }

    public boolean isTargetInputOutputSupported() {
        return true;
    }

    public boolean isTargetFinishNonZeroExitCodeSupported() {
        return true;
    }

    public boolean isRemoteDebugSupported() {
        if (SystemInfo.isMac) {
            return false;
        }
        if (this.getEnvironment().getHostMachine().isRemote()) {
            return false;
        }
        return this.myDriverKind == DebuggerDriverKind.GDB;
    }

    public boolean isDisasmSupported() {
        return true;
    }

    public static boolean shouldRunTest(DebuggerDriverKind driverKind, String testName, Class testClass) {
        String property = System.getProperty("cidr.test.disable" + driverKind.name());
        if ("true".equalsIgnoreCase(property)) {
            return false;
        }
        if ("nonBasic".equalsIgnoreCase(property)) {
            Method method = ReflectionUtil.getMethod((Class)testClass, (String)testName, (Class[])new Class[0]);
            return method != null && method.getAnnotation(BasicDebuggerTest.class) != null;
        }
        return true;
    }

    public BlockingQueue<DebuggerState> startDebugSession(XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(null, false, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(parameters, null, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(parameters, null, false, listeners);
    }

    protected BlockingQueue<DebuggerState> startDebugSession(@Nullable String parameters, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)config -> config.setProgramParameters(parameters)), outputListener, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable Consumer<CidrRunConfiguration> configurator, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(configurator, null, false, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSession(@Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        return this.startDebugSession(((CidrExecutionFixture)((Object)this.myExecutionFixture)).createRunConfiguration(((CidrExecutionFixture)((Object)this.myExecutionFixture)).getConfigurationType(), configurator), null, outputListener, muteBreakpoints, listeners);
    }

    public BlockingQueue<DebuggerState> startDebugSessionWithListener(@Nullable String parameters) throws Exception {
        return this.startDebugSession(parameters, false, new XDebugSessionListener[0]);
    }

    protected BlockingQueue<DebuggerState> startDebugSession(@NotNull RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget executionTarget, @Nullable Consumer<Pair<String, Key>> outputListener, boolean muteBreakpoints, XDebugSessionListener ... listeners) throws Exception {
        if (settings == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(4);
        }
        return this.doStartDebugSession(outputListener, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).startRunDebug((CidrRunProfile)((CidrRunConfiguration)settings.getConfiguration()), executionTarget, true, muteBreakpoints ? ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).DEBUG_STARTER_MUTED_BREAKS : ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).DEBUG_STARTER, (XDebugSessionListener[])ArrayUtil.append((Object[])listeners, (Object)listener))), true);
    }

    @NotNull
    private BlockingQueue<DebuggerState> doStartDebugSession(final @Nullable Consumer<Pair<String, Key>> outputListener, ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception> starter, boolean startNotify) throws Exception {
        ((CidrExecutionFixture)((Object)this.myExecutionFixture)).disposeSession();
        this.disposeSession(this.myDestroyPreviousProcessOnStart);
        ArrayDeque<DebuggerState> stateLog = new ArrayDeque<DebuggerState>();
        Pair<XDebugSessionListener, BlockingQueue<DebuggerState>> pair = this.createStateListener(stateLog);
        WriteAction.runAndWait(() -> this.configureDebugSessionSettings());
        this.mySession = (XDebugSession)starter.convert((Object)((XDebugSessionListener)pair.first));
        this.myDebugProcess = (CidrDebugProcess)this.mySession.getDebugProcess();
        this.myDebugProcess.putUserData(DEBUG_STATE_LOGS_KEY, stateLog);
        this.myDriver = this.myDebugProcess.getDriverInTests();
        ProcessHandler handler = this.myDebugProcess.getProcessHandler();
        if (outputListener != null) {
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    outputListener.consume((Object)Pair.create((Object)event.getText(), (Object)outputType));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (startNotify) {
            handler.startNotify();
        }
        this.myDriverKind.checkDriverClass(this.myDriver);
        BlockingQueue blockingQueue = (BlockingQueue)pair.second;
        if (blockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(5);
        }
        return blockingQueue;
    }

    protected void configureDebugSessionSettings() {
    }

    public void startRerunDebugSession() {
        this.doStartRerunDebugSession();
        this.myDriverKind.checkDriverClass(this.myDebugProcess.getDriverInTests());
    }

    protected void doStartRerunDebugSession() {
        throw new UnsupportedOperationException();
    }

    public BlockingQueue<DebuggerState> attachDebugSession(Project project2, @NotNull ProcessInfo processInfo) throws Exception {
        if (processInfo == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(6);
        }
        return this.doStartDebugSession(null, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> this.doAttachDebugSession(project2, processInfo, (XDebugSessionListener)listener)), false);
    }

    protected XDebugSession doAttachDebugSession(Project project2, ProcessInfo processInfo, XDebugSessionListener ... listeners) throws ExecutionException {
        AtomicReference<Object> result2 = new AtomicReference<Object>(null);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            CidrLocalAttachDebugger debugger = this.getLocalAttachDebugger(project2);
            try {
                result2.set(debugger.doAttachDebugSession(project2, processInfo, null, listeners));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return result2.get();
    }

    @NotNull
    protected CidrLocalAttachDebugger getLocalAttachDebugger(@NotNull Project project2) {
        if (project2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(7);
        }
        return new CidrLocalAttachDebugger(this.createDriverConfiguration((Function.Mono<GeneralCommandLine>)((Function.Mono)cl -> cl)));
    }

    public BlockingQueue<DebuggerState> createRemoteDebugSession(Project project2, @NotNull CidrRemoteDebugParameters params, XDebugSessionListener ... listeners) throws Exception {
        if (params == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(8);
        }
        return this.doStartDebugSession(null, (ThrowableConvertor<XDebugSessionListener, XDebugSession, Exception>)((ThrowableConvertor)listener -> this.doConnectRemoteDebugSession(project2, params, (XDebugSessionListener[])ArrayUtil.append((Object[])listeners, (Object)listener))), true);
    }

    @NotNull
    protected XDebugSession doConnectRemoteDebugSession(Project project2, CidrRemoteDebugParameters params, XDebugSessionListener ... listeners) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Pair<XDebugSessionListener, BlockingQueue<DebuggerState>> createStateListener(final ArrayDeque<DebuggerState> stateLog) {
        final LinkedBlockingQueue stateQueue = new LinkedBlockingQueue();
        XDebugSessionListener listener = new XDebugSessionListener(){

            public void sessionPaused() {
                this.postState(DebuggerState.PAUSED);
            }

            public void sessionResumed() {
                this.postState(DebuggerState.RESUMED);
            }

            public void sessionStopped() {
                this.postState(DebuggerState.STOPPED);
            }

            private void postState(@NotNull DebuggerState state) {
                if (state == null) {
                    2.$$$reportNull$$$0(0);
                }
                stateQueue.add(state);
                stateLog.add(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$2", "postState"));
            }
        };
        return Pair.create((Object)listener, stateQueue);
    }

    @NotNull
    public BlockingQueue<DebuggerState> spyOnSessionEvents() {
        Pair<XDebugSessionListener, BlockingQueue<DebuggerState>> listenerAndQueue = this.createStateListener(new ArrayDeque<DebuggerState>());
        this.mySession.addSessionListener((XDebugSessionListener)listenerAndQueue.first, this.myDisposable);
        BlockingQueue blockingQueue = (BlockingQueue)listenerAndQueue.second;
        if (blockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(9);
        }
        return blockingQueue;
    }

    @Override
    public void waitForDebuggerAndSwingEvents() {
        this.myDriver.waitHandlerProcessed();
        try {
            XDebuggerAssertions.waitForSwing();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkStoppedOnBreakpoint(BlockingQueue<DebuggerState> state, VirtualFile file2, int line) throws InterruptedException, IOException {
        this.checkStoppedOnBreakpoint(state, file2, line, 25000L, null);
    }

    public void checkStoppedOnBreakpoint(BlockingQueue<DebuggerState> state, VirtualFile file2, int line, @Nullable Long timeout, @Nullable Consumer<? super XDebugSession> additionalChecks) throws InterruptedException, IOException {
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.PAUSED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        XDebuggerAssertions.assertCurrentPosition(this.mySession, file2, line);
        if (additionalChecks != null) {
            additionalChecks.consume((Object)this.mySession);
        }
        this.mySession.resume();
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.RESUMED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        CidrDebuggingFixture.assertEquals((Object)DebuggerState.STOPPED, (Object)CidrDebuggingFixture.waitFor(state, timeout));
        CidrDebuggingFixture.assertEquals((long)0L, (long)state.size());
    }

    private static void destroyProcess(CidrDebugProcess process) {
        ProcessHandler h = process.getProcessHandler();
        h.destroyProcess();
        if (!CidrExecutionFixture.waitFor(h)) {
            new Throwable("Cannot stop debugger process").printStackTrace();
        }
        XDebuggerAssertions.disposeDebugSession(process.getSession());
        ArrayDeque log = (ArrayDeque)process.getUserData(DEBUG_STATE_LOGS_KEY);
        if (log != null) {
            DebuggerState s;
            DebuggerState debuggerState = s = log.size() > 0 ? (DebuggerState)log.poll() : null;
            while (s != null && s != DebuggerState.STOPPED) {
                s = log.size() > 0 ? (DebuggerState)log.poll() : null;
            }
            log.clear();
        }
    }

    public boolean waitForProcessHandler() {
        if (this.myDebugProcess != null) {
            return CidrExecutionFixture.waitFor(this.myDebugProcess.getProcessHandler());
        }
        return ((CidrExecutionFixture)((Object)this.myExecutionFixture)).waitForProcessHandler();
    }

    public void disposeSession(boolean destroyProcess) {
        if (this.myDebugProcess != null) {
            if (destroyProcess) {
                CidrDebuggingFixture.destroyProcess(this.myDebugProcess);
            } else {
                this.myAllProcesses.add(this.myDebugProcess);
            }
            this.myDebugProcess = null;
            if (this.myDriver != null) {
                this.myDriver.waitHandlerProcessed();
                this.myDriver = null;
            }
        }
    }

    @Override
    public void tearDown() {
        this.disposeSession(true);
        Disposer.dispose((Disposable)this.myDisposable);
        for (CidrDebugProcess each : this.myAllProcesses) {
            CidrDebuggingFixture.destroyProcess(each);
        }
        this.myAllProcesses.clear();
        this.clearBreakpoints();
    }

    protected void clearBreakpoints() {
        Object projectFixture2 = ((CidrExecutionFixture)((Object)this.myExecutionFixture)).getProjectFixture();
        if (((CidrProjectFixtureBase)projectFixture2).isProjectOpened()) {
            Project project2 = ((CidrProjectFixtureBase)projectFixture2).getProject();
            XDebuggerAssertions.removeAllBreakpoints(project2);
        }
    }

    @Contract(value="_, _, !null -> !null; _, _, null ->  null")
    protected <T> BlockingQueue<? extends T> startDriver(@Nullable DebuggerDriver.Handler handler, @Nullable Function.Mono<GeneralCommandLine> driverCommandLineConfigurator, @Nullable EventFilter<DriverEvent, T> eventFilter) throws ExecutionException {
        this.stopDebugDriver();
        if (handler != null) {
            this.addDriverHandler(handler);
        }
        this.myDriverConfiguration = this.createDriverConfiguration(driverCommandLineConfigurator);
        this.myDriver = this.createDriver(this.myDriverConfiguration);
        this.myDriver.setRedirectOutputToFiles(true);
        this.myDriver.getProcessHandler().startNotify();
        this.isStarted = true;
        return this.spyOnDriverEvents((event, mode) -> {
            Object result2 = eventFilter == null ? null : eventFilter.apply((DriverEvent)event, mode);
            CidrDebuggerLog.LOG.debug((result2 == null ? "\u25cb" : "\u25cf") + " " + event + (String)(result2 == null || result2 == event ? "" : " \u25b6\u25b6\u25b6 " + result2));
            return result2;
        }, eventFilter == null ? null : new LinkedBlockingQueue());
    }

    protected void stopDebugDriver() throws ExecutionException {
        if (this.myDriver != null && this.isStarted) {
            BaseProcessHandler processHandler = this.myDriver.getProcessHandler();
            processHandler.destroyProcess();
            if (!processHandler.waitFor(3000L)) {
                CidrDebuggerLog.LOG.warn("cannot destroy driver process, killing...");
                Process process = processHandler.getProcess();
                if (OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                    if (!processHandler.waitFor(1000L)) {
                        CidrDebuggerLog.LOG.warn("cannot kill driver process.");
                    }
                }
            }
            this.isStarted = false;
            this.myDriver.waitHandlerProcessed();
            this.myDriver.checkErrors();
        }
    }

    @NotNull
    protected DebuggerDriver createDriver(@NotNull DebuggerDriverConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(10);
        }
        DebuggerDriver debuggerDriver = configuration.createDriver((DebuggerDriver.Handler)this.myDriverHandlerEventDispatcher.getMulticaster(), this.getArchitectureType());
        if (debuggerDriver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(11);
        }
        return debuggerDriver;
    }

    protected void addDriverHandler(@NotNull DebuggerDriver.Handler handler) {
        if (handler == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(12);
        }
        this.myDriverHandlerEventDispatcher.addListener((EventListener)handler, this.myDisposable);
    }

    @NotNull
    protected <T> BlockingQueue<T> spyOnDriverEvents(@NotNull EventFilter<DriverEvent, T> eventFilter) {
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(13);
        }
        BlockingQueue<T> blockingQueue = this.spyOnDriverEvents(eventFilter, new LinkedBlockingQueue());
        if (blockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(14);
        }
        return blockingQueue;
    }

    @Contract(value="_, !null -> !null; _,  null ->  null")
    protected <T> BlockingQueue<T> spyOnDriverEvents(final @NotNull EventFilter<DriverEvent, T> eventFilter, final @Nullable BlockingQueue<T> stopPlaces) {
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(15);
        }
        this.addDriverHandler(new CidrDebuggerTestCase.NullHandler(){

            private void handleDriverEvent(@NotNull DriverEvent event) {
                Object result2;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((result2 = eventFilter.apply(event, EventFilter.Mode.PROBE)) != null && stopPlaces != null) {
                    stopPlaces.add(result2);
                }
            }

            public void handleRunning() {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.RUNNING));
            }

            public void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
                if (exitStatus == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.handleDriverEvent(new DriverFinishedEvent(DriverEvent.Kind.FINISHED, exitStatus));
            }

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.handleDriverEvent(new DriverCodepointEvent(DriverEvent.Kind.BREAKPOINT, stopPlace, breakpointNumber));
            }

            public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(3);
                }
                this.handleDriverEvent(new DriverCodepointEvent(DriverEvent.Kind.WATCHPOINT, stopPlace, watchpointNumber));
            }

            public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (signal == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (meaning == null) {
                    3.$$$reportNull$$$0(6);
                }
                this.handleDriverEvent(new DriverSuspendEvent(DriverEvent.Kind.SIGNAL, stopPlace, signal, meaning));
            }

            public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(7);
                }
                if (exceptionAddress == null) {
                    3.$$$reportNull$$$0(8);
                }
                if (description == null) {
                    3.$$$reportNull$$$0(9);
                }
                this.handleDriverEvent(new DriverExceptionEvent(DriverEvent.Kind.EXCEPTION, stopPlace, description, exceptionAddress, exceptionFile, exceptionHash, exceptionLine));
            }

            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                if (stopPlace == null) {
                    3.$$$reportNull$$$0(10);
                }
                this.handleDriverEvent(new DriverSuspendEvent(DriverEvent.Kind.INTERRUPTED, stopPlace));
            }

            public void handleExited(int code) {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.DEBUGGER_EXITED));
            }

            public void handleAttached(int pid) {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.DEBUGGER_ATTACHED));
            }

            public void handleConnected(@NotNull String connection) {
                if (connection == null) {
                    3.$$$reportNull$$$0(11);
                }
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.DEBUGGER_ATTACHED));
            }

            public void handleDetached() {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.DEBUGGER_DETACHED));
            }

            public void handleDisconnected() {
                this.handleDriverEvent(new DriverEvent(DriverEvent.Kind.DEBUGGER_DETACHED));
            }

            public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(12);
                }
                this.handleDriverEvent(new DriverBreakpointChangedEvent(DriverEvent.Kind.BREAKPOINT_UPDATED, breakpoint));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exitStatus";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stopPlace";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signal";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "meaning";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exceptionAddress";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "connection";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "breakpoint";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleDriverEvent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTargetTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleBreakpoint";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleWatchpoint";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleSignal";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleException";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInterrupted";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleConnected";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleBreakpointUpdated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return stopPlaces;
    }

    @NotNull
    protected BlockingQueue<String> spyOnOutputLines() {
        final LinkedBlockingQueue<String> linesQueue = new LinkedBlockingQueue<String>();
        final StringBuilder lineBuilder = new StringBuilder();
        this.addDriverHandler(new CidrDebuggerTestCase.NullHandler(){

            public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
                if (text == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    4.$$$reportNull$$$0(1);
                }
                String[] lines2 = text.split("(?<=\\n)", -1);
                assert (lines2.length > 0);
                if (lines2.length > 1) {
                    lines2[0] = lineBuilder.append(lines2[0]).toString();
                    lineBuilder.setLength(0);
                    linesQueue.addAll(Arrays.asList(lines2).subList(0, lines2.length - 1));
                }
                lineBuilder.append(lines2[lines2.length - 1]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$4";
                objectArray[2] = "handleDebuggerOutput";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedBlockingQueue<String> linkedBlockingQueue = linesQueue;
        if (linkedBlockingQueue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(16);
        }
        return linkedBlockingQueue;
    }

    public String getConsoleText(ConsoleView consoleView) {
        this.waitForDebuggerAndSwingEvents();
        if (consoleView instanceof TerminalExecutionConsole) {
            return ((TerminalExecutionConsole)consoleView).getTerminalWidget().getText();
        }
        return XDebuggerTestUtil.getConsoleText((ConsoleViewImpl)consoleView);
    }

    public String getConsoleText() {
        return this.getConsoleText(this.mySession.getConsoleView());
    }

    public void assertConsoleTextMatches(@RegExp String pattern) {
        this.assertConsoleTextMatches(pattern, 32);
    }

    public void assertConsoleTextMatches(@RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCase.assertMatches(this.getConsoleText(), pattern, flags);
    }

    public void assertConsoleTextEndsWith(String text) {
        String consoleText = this.getConsoleText();
        CidrDebuggingFixture.assertTrue((String)consoleText, (boolean)consoleText.endsWith(text));
    }

    public String getDebuggerConsoleText() {
        return this.getConsoleText((ConsoleView)this.myDebugProcess.getDebuggerConsole());
    }

    public void assertDebuggerConsoleTextMatches(@RegExp String pattern) {
        this.assertDebuggerConsoleTextMatches(pattern, 32);
    }

    public void assertDebuggerConsoleTextMatches(@RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCase.assertMatches(this.getDebuggerConsoleText(), pattern, flags);
    }

    public List<XStackFrame> collectFrames() {
        return XDebuggerTestUtil.collectFrames(this.getSession());
    }

    public List<XStackFrame> collectFrames(@Nullable XExecutionStack stack) {
        return XDebuggerTestUtil.collectFrames(stack, this.getSession());
    }

    protected XStackFrame getMainFunctionFrame(List<XStackFrame> frames) {
        return this.findMainFunctionFrame(frames, true);
    }

    @Contract(value="_, true -> !null")
    protected CidrStackFrame findMainFunctionFrame(List<XStackFrame> frames, boolean makeAssertion) {
        return this.findFrame(frames, "main", makeAssertion);
    }

    @NotNull
    public CidrStackFrame findFrame(List<XStackFrame> frames, String functionName) {
        CidrStackFrame cidrStackFrame = this.findFrame(frames, functionName, true);
        if (cidrStackFrame == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(17);
        }
        return cidrStackFrame;
    }

    @NotNull
    public CidrStackFrame findFrameMatching(List<XStackFrame> frames, @RegExp String functionName) {
        CidrStackFrame cidrStackFrame = this.findFrameMatching(frames, functionName, true);
        if (cidrStackFrame == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(18);
        }
        return cidrStackFrame;
    }

    @Contract(value="_, _, true -> !null")
    public CidrStackFrame findFrameMatching(List<XStackFrame> frames, @RegExp String functionName, boolean makeAssertion) {
        for (XStackFrame eachFrame : frames) {
            LLFrame frame = ((CidrStackFrame)eachFrame).getFrame();
            if (!frame.getFunction().matches(functionName)) continue;
            return (CidrStackFrame)eachFrame;
        }
        if (makeAssertion) {
            CidrDebuggingFixture.fail((String)("'" + functionName + "' frame not found among:\n" + StringUtil.join(frames, (String)"\n")));
        }
        return null;
    }

    @Contract(value="_, _, true -> !null")
    public CidrStackFrame findFrame(List<XStackFrame> frames, String functionName, boolean makeAssertion) {
        for (XStackFrame eachFrame : frames) {
            LLFrame frame = ((CidrStackFrame)eachFrame).getFrame();
            if (!functionName.equals(frame.getFunction())) continue;
            return (CidrStackFrame)eachFrame;
        }
        if (makeAssertion) {
            CidrDebuggingFixture.fail((String)("'" + functionName + "' frame not found among:\n" + StringUtil.join(frames, (String)"\n")));
        }
        return null;
    }

    public static void assertVarCollectingError(XStackFrame frame, String expectedError) {
        Pair<List<XValue>, String> result2 = XDebuggerAssertions.collectChildrenWithError((XValueContainer)frame);
        CidrDebuggingFixture.assertEquals((Object)expectedError, (Object)result2.second);
        List frameVars = ContainerUtil.filter((Collection)((Collection)result2.first), it -> !(it instanceof CidrRegistersValue));
        UsefulTestCase.assertEmpty(frameVars);
    }

    public static void assertFramePresentationMatches(XStackFrame stackFrame, @Nullable @RegExp String expected) {
        CidrTestCase.assertMatches(CidrDebuggingFixture.computeFramePresentation(stackFrame), expected);
    }

    @NotNull
    public static String computeFramePresentation(XStackFrame stackFrame) {
        String string = XDebuggerAssertions.getFramePresentation(stackFrame);
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static void assertBreakpoint(LLBreakpoint b, int id, String file2, int line) {
        CidrDebuggingFixture.assertBreakpoint(b, id, file2, line, null);
    }

    protected static void assertBreakpoint(LLBreakpoint b, int id, String file2, int line, @Nullable String condition) {
        CidrDebuggingFixture.assertEquals((Object)new LLBreakpoint(id, file2, line, condition), (Object)b);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull Address address) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(20);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(21);
        }
        if (address == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(22);
        }
        CidrDebuggingFixture.assertEquals((Object)location.getId(), (Object)id);
        CidrDebuggingFixture.assertEquals((Object)location.getAddress(), (Object)address);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull FileLocation fileLocation) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(23);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(24);
        }
        if (fileLocation == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(25);
        }
        CidrDebuggingFixture.assertEquals((Object)location.getId(), (Object)id);
        CidrDebuggingFixture.assertEquals((Object)location.getFileLocation(), (Object)fileLocation);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull FileLocation fileLocation) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(26);
        }
        if (fileLocation == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(27);
        }
        CidrDebuggingFixture.assertEquals((Object)location.getFileLocation(), (Object)fileLocation);
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String id, @NotNull String file2, int line) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(28);
        }
        if (id == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(30);
        }
        CidrDebuggingFixture.assertBreakpointLocation(location, id, new FileLocation(file2, line));
    }

    protected static void assertBreakpointLocation(@NotNull LLBreakpointLocation location, @NotNull String file2, int line) {
        if (location == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(32);
        }
        CidrDebuggingFixture.assertBreakpointLocation(location, new FileLocation(file2, line));
    }

    public static void assertResultList(DebuggerDriver.ResultList<?> result2, int expectedSize, boolean hasMore) {
        UsefulTestCase.assertSize(expectedSize, result2.list);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)result2.hasMore);
    }

    public static void assertResultList(DebuggerDriver.ResultList<?> result2, int expectedSizeMin, int expectedSizeMax, boolean hasMore) {
        int size = result2.list.size();
        TestCase.assertTrue((String)("Size : " + size), (size >= expectedSizeMin && size <= expectedSizeMax ? 1 : 0) != 0);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)result2.hasMore);
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean mayHaveChildren, @Nullable Ref<Integer> childrenCount, @Nullable Boolean isStruct, @Nullable Boolean isValid) throws DebuggerCommandException, ExecutionException {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(33);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(34);
        }
        LLValueData data = driver.getData(val);
        String message = val + " = " + data;
        if (name != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)name, (Object)val.getName());
        }
        if (type != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)type, (Object)val.getType());
        }
        if (mayHaveChildren != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)mayHaveChildren, (Object)data.mayHaveChildren());
        }
        if (childrenCount != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)childrenCount.get(), (Object)driver.getChildrenCount(val));
        }
        if (isStruct != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)isStruct, (Object)(val.getTypeClass() == LLValue.TypeClass.CLASS_STRUCT ? 1 : 0));
        }
        if (isValid != null) {
            CidrDebuggingFixture.assertEquals((String)message, (Object)isValid, (Object)val.isValid());
        }
        if (value2 != null) {
            if ("float".equals(type)) {
                CidrDebuggingFixture.assertEquals((String)message, (float)Float.parseFloat(value2), (float)Float.parseFloat(data.getValue()), (float)0.001f);
            } else if ("double".equals(type)) {
                CidrDebuggingFixture.assertEquals((String)message, (double)Double.parseDouble(value2), (double)Double.parseDouble(data.getValue()), (double)1.0E-5);
            } else {
                CidrDebuggingFixture.assertEquals((String)message, (Object)value2, (Object)data.getValue());
            }
        }
    }

    public static void assertLLValuePresentableValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @NotNull String expected) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(35);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(36);
        }
        if (expected == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(37);
        }
        LLValueData data = driver.getData(val);
        String message = val + " = " + data;
        CidrDebuggingFixture.assertEquals((String)message, (Object)expected, (Object)data.getPresentableValue());
    }

    public static void assertLLValuePresentableValueMatches(@NotNull DebuggerDriver driver, @NotNull LLValue val, @NotNull @RegExp String expectedPattern) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(38);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(39);
        }
        if (expectedPattern == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(40);
        }
        LLValueData data = driver.getData(val);
        String message = val + " = " + data;
        CidrDebuggingFixture.assertTrue((String)("Expected pattern: " + expectedPattern + " Actual value: " + message), (boolean)data.getPresentableValue().matches(expectedPattern));
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean mayHaveChildren, int childrenCount) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(41);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(42);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value2, mayHaveChildren, (Ref<Integer>)Ref.create((Object)childrenCount));
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean mayHaveChildren, @Nullable Ref<Integer> childrenCount) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(43);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(44);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value2, mayHaveChildren, childrenCount, null, true);
    }

    public static void assertLLValue(@NotNull DebuggerDriver driver, @NotNull LLValue val, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean mayHaveChildren, int childrenCount, boolean isStruct) throws Exception {
        if (driver == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(45);
        }
        if (val == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(46);
        }
        CidrDebuggingFixture.assertLLValue(driver, val, name, type, value2, mayHaveChildren, (Ref<Integer>)Ref.create((Object)childrenCount), isStruct, true);
    }

    public static void assertLLValues(DebuggerDriver.ResultList<LLValue> childrenResult, boolean hasMore, String ... expectedNames) {
        UsefulTestCase.assertOrderedEquals(ContainerUtil.map((Collection)childrenResult.list, value2 -> value2.getName()), expectedNames);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)childrenResult.hasMore);
    }

    public static void assertUnorderedLLValues(DebuggerDriver.ResultList<LLValue> childrenResult, boolean hasMore, String ... expectedNames) {
        CidrDebuggingFixture.assertUnorderedLLValues(childrenResult.list, expectedNames);
        CidrDebuggingFixture.assertEquals((Object)hasMore, (Object)childrenResult.hasMore);
    }

    public static void assertUnorderedLLValues(List<LLValue> list, String ... expectedNames) {
        UsefulTestCase.assertSameElements(ContainerUtil.map(list, value2 -> value2.getName()), expectedNames);
    }

    public Pair<XValue, String> evaluate(String expression) {
        return XDebuggerTestUtil.evaluate(this.getSession(), expression, 50000L);
    }

    @NotNull
    public static XValue findVar(Collection<XValue> vars, String name) {
        XValue xValue = XDebuggerTestUtil.findVar(vars, name);
        if (xValue == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(47);
        }
        return xValue;
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        String message = frame.toString();
        if (frameNum != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid frame number for " + message), (long)frameNum.intValue(), (long)frame.getIndex());
        }
        if (fileName != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid file name for " + message), (Object)fileName, (Object)frame.getFile());
        }
        if (lineNum != null) {
            CidrDebuggingFixture.assertEquals((String)("Invalid line for " + message), (long)lineNum.intValue(), (long)frame.getLine());
        }
        this.assertFunctionName("Invalid frame func name  for " + message, frame.getFunction(), funcPattern);
        if (hasProgramCounter) {
            CidrDebuggingFixture.assertFalse((String)("Missing program counter for " + message), (boolean)frame.getProgramCounter().isNull());
        } else {
            CidrDebuggingFixture.assertTrue((String)("Program counter should not be specified for " + message), (boolean)frame.getProgramCounter().isNull());
        }
    }

    public void assertFunctionName(@NotNull String message, @Nullable String funcName, @RegExp @Nullable String funcPattern) {
        if (message == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(48);
        }
        if (funcPattern != null) {
            CidrDebuggingFixture.assertTrue((String)(message + "\nExpected: " + funcPattern + "\nActual: " + funcName + "\n"), (boolean)funcName.matches(funcPattern));
        }
    }

    public List<XExecutionStack> collectThreads() {
        return XDebuggerTestUtil.collectThreads(this.getSession());
    }

    @NotNull
    protected XExecutionStack getMainThread(List<XExecutionStack> threads) {
        if (SystemInfo.isMac) {
            for (XExecutionStack each : threads) {
                if (this.findMainFunctionFrame(this.collectFrames(each), false) == null) continue;
                XExecutionStack xExecutionStack = each;
                if (xExecutionStack == null) {
                    CidrDebuggingFixture.$$$reportNull$$$0(49);
                }
                return xExecutionStack;
            }
        }
        for (XExecutionStack each : threads) {
            if (!each.getDisplayName().contains("com.apple.main-thread")) continue;
            XExecutionStack xExecutionStack = each;
            if (xExecutionStack == null) {
                CidrDebuggingFixture.$$$reportNull$$$0(50);
            }
            return xExecutionStack;
        }
        CidrDebuggingFixture.fail((String)("Main thread not found in " + threads));
        throw new RuntimeException();
    }

    public static LLValue findVariable(String name, Collection<LLValue> vars) {
        for (LLValue each : vars) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    public static <T> T waitFor(BlockingQueue<T> q) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, 25000L);
    }

    public static <T> T waitFor(BlockingQueue<T> q, Long timeout) throws InterruptedException {
        return timeout == null ? CidrExecutionFixture.waitFor(q, 25000L) : CidrExecutionFixture.waitFor(q, (long)timeout);
    }

    public static <T> T waitFor(BlockingQueue<T> q, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, timeout);
    }

    public static <T> T waitFor(FutureResult<T> f) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, 25000L);
    }

    public static boolean waitFor(Semaphore s) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, 25000L);
    }

    public static boolean waitFor(Semaphore s, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, timeout);
    }

    public static <T> T waitFor(FutureResult<T> f, long timeout) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, timeout);
    }

    public static boolean waitFor(ProcessHandler p) {
        return CidrExecutionFixture.waitFor(p, 25000L);
    }

    public static boolean waitFor(ProcessHandler p, long timeout) {
        return CidrExecutionFixture.waitFor(p, timeout);
    }

    @NotNull
    public static String waitOrDrainUntilLine(@NotNull BlockingQueue<String> lines2, @NotNull Pattern pattern) throws InterruptedException {
        if (lines2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(51);
        }
        if (pattern == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(52);
        }
        return CidrDebuggingFixture.waitOrDrainUntilLine(lines2, pattern, 25000);
    }

    @NotNull
    public static String waitOrDrainUntilLine(@NotNull BlockingQueue<String> lines2, @NotNull Pattern pattern, int timeout) throws InterruptedException {
        String line;
        if (lines2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(53);
        }
        if (pattern == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(54);
        }
        do {
            if ((line = CidrDebuggingFixture.waitFor(lines2, (long)timeout)) != null) continue;
            throw new TimeoutAssertionFailedError("Timeout (" + timeout + " ms) while waiting for line matching: " + pattern);
        } while (!pattern.matcher(line).matches());
        String string = line;
        if (string == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static <T, R> R waitForEvent(@NotNull BlockingQueue<? extends T> events, @NotNull EventFilter<T, R> eventFilter) throws InterruptedException {
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(56);
        }
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(57);
        }
        return CidrDebuggingFixture.waitForEvent(events, eventFilter, 25000L);
    }

    @NotNull
    protected static <T, R> R waitForEvent(@NotNull BlockingQueue<? extends T> events, @NotNull EventFilter<T, R> eventFilter, long timeout) throws InterruptedException {
        T event;
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(58);
        }
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(59);
        }
        if ((event = CidrExecutionFixture.waitFor(events, timeout)) == null) {
            throw new TimeoutAssertionFailedError("Timeout (" + timeout + " ms) while waiting for event: " + eventFilter);
        }
        return CidrDebuggingFixture.assertEvent(event, eventFilter);
    }

    @NotNull
    public static <T, R> R assertEvent(@NotNull T event, @NotNull EventFilter<T, R> eventFilter) {
        R result2;
        if (event == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(60);
        }
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(61);
        }
        if ((result2 = eventFilter.apply(event, EventFilter.Mode.ASSERT)) == null) {
            TestCase.fail((String)("Expected " + eventFilter + ": got " + event));
        }
        R r = result2;
        if (r == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(62);
        }
        return r;
    }

    public static <T> void assertNoMoreEvents(@NotNull BlockingQueue<T> events) throws InterruptedException {
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(63);
        }
        CidrDebuggingFixture.assertNoMoreEvents(events, 200L);
    }

    public static <T> void assertNoMoreEvents(@NotNull BlockingQueue<T> events, long delay2) throws InterruptedException {
        T event;
        if (events == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(64);
        }
        String classStr = (event = CidrExecutionFixture.waitFor(events, delay2)) instanceof String ? "lines" : (event instanceof DriverEvent ? "driver events" : (event instanceof DebuggerState ? "session events" : "events"));
        TestCase.assertNull((String)("No more " + classStr + " expected"), event);
    }

    public static <T> boolean isEvent(@NotNull T event, @NotNull EventFilter<T, ?> eventFilter) {
        if (event == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(65);
        }
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(66);
        }
        return eventFilter.apply(event, EventFilter.Mode.PROBE) != null;
    }

    public static <T, R> boolean probeEvent(@NotNull T event, @NotNull EventFilter<T, R> eventFilter, @NotNull Predicate<R> predicate) {
        R result2;
        if (event == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(67);
        }
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(68);
        }
        if (predicate == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(69);
        }
        return (result2 = eventFilter.apply(event, EventFilter.Mode.PROBE)) != null && predicate.test(result2);
    }

    @NotNull
    public EventFilter<DebuggerState, DebuggerState> fixupDebuggerStateFilter(@NotNull DebuggerState debuggerState) {
        if (debuggerState == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(70);
        }
        DebuggerState debuggerState2 = debuggerState;
        if (debuggerState2 == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(71);
        }
        return debuggerState2;
    }

    @NotNull
    public <T extends DriverEvent> EventFilter<DriverEvent, T> fixupDriverEventFilter(@NotNull DriverEvent.Kind<T> eventKind) {
        if (eventKind == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(72);
        }
        DriverEvent.Kind<T> kind = eventKind;
        if (kind == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(73);
        }
        return kind;
    }

    @NotNull
    public EventFilter<DriverEvent, DriverEvent> targetExecutionCheckpointEvents() {
        EventFilter<DriverEvent, DriverEvent> eventFilter = EventFilter.anyOf(DriverEvent.Kind.FINISHED, DriverEvent.Kind.BREAKPOINT, DriverEvent.Kind.WATCHPOINT, DriverEvent.Kind.SIGNAL, DriverEvent.Kind.EXCEPTION, DriverEvent.Kind.INTERRUPTED);
        if (eventFilter == null) {
            CidrDebuggingFixture.$$$reportNull$$$0(74);
        }
        return eventFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 11, 14, 16, 17, 18, 19, 47, 49, 50, 55, 62, 71, 73, 74 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 62: 
            case 71: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: 
            case 15: 
            case 57: 
            case 59: 
            case 61: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventFilter";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLocation";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedPattern";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 56: 
            case 58: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 60: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toAppEnvPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartDebugSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnSessionEvents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnDriverEvents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnOutputLines";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findFrame";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findFrameMatching";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFramePresentation";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "findVar";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainThread";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "waitOrDrainUntilLine";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "assertEvent";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "fixupDebuggerStateFilter";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "fixupDriverEventFilter";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "targetExecutionCheckpointEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toAppEnvPath";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 62: 
            case 71: 
            case 73: 
            case 74: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startDebugSession";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachDebugSession";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAttachDebugger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteDebugSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDriverHandler";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "spyOnDriverEvents";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "assertBreakpointLocation";
                break;
            }
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertLLValue";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "assertLLValuePresentableValue";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "assertLLValuePresentableValueMatches";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "assertFunctionName";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "waitOrDrainUntilLine";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "waitForEvent";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "assertEvent";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertNoMoreEvents";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isEvent";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "probeEvent";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fixupDebuggerStateFilter";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "fixupDriverEventFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 11, 14, 16, 17, 18, 19, 47, 49, 50, 55, 62, 71, 73, 74 -> new IllegalStateException(string);
        };
    }

    public static enum DebuggerState implements EventFilter<DebuggerState, DebuggerState>
    {
        PAUSED,
        RESUMED,
        STOPPED;


        @Override
        @Nullable
        public DebuggerState apply(@NotNull DebuggerState state, @NotNull EventFilter.Mode mode) {
            if (state == null) {
                DebuggerState.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                DebuggerState.$$$reportNull$$$0(1);
            }
            return state == this ? state : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mode";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DebuggerState";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface EventFilter<T, R> {
        @Nullable
        public R apply(@NotNull T var1, @NotNull Mode var2);

        @NotNull
        default public EventFilter<T, R> derive(final @NotNull EventFilter<T, R> delegate) {
            if (delegate == null) {
                EventFilter.$$$reportNull$$$0(0);
            }
            return new EventFilter<T, R>(){

                @Override
                @Nullable
                public R apply(@NotNull T event, @NotNull Mode mode) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (mode == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return delegate.apply(event, mode);
                }

                public String toString() {
                    return this + "***";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "mode";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$EventFilter$1";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @NotNull
        default public EventFilter<T, R> withPreAssert(@Nullable java.util.function.Consumer<T> preAssert) {
            if (preAssert != null) {
                EventFilter<Object, Object> eventFilter = this.derive((event, mode) -> {
                    if (mode == Mode.ASSERT) {
                        preAssert.accept(event);
                    }
                    return this.apply(event, mode);
                });
                if (eventFilter == null) {
                    EventFilter.$$$reportNull$$$0(1);
                }
                return eventFilter;
            }
            EventFilter eventFilter = this;
            if (eventFilter == null) {
                EventFilter.$$$reportNull$$$0(2);
            }
            return eventFilter;
        }

        @SafeVarargs
        @NotNull
        public static <T, R> EventFilter<T, R> anyOf(EventFilter<? super T, ? extends R> ... filters) {
            if (filters == null) {
                EventFilter.$$$reportNull$$$0(3);
            }
            return new AnyOf<R, T>(filters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$EventFilter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$EventFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPreAssert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "derive";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "anyOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        public static class AnyOf<R, T>
        implements EventFilter<T, R> {
            @NotNull
            private final @NotNull EventFilter<? super T, ? extends R> @NotNull [] myFilters;

            public AnyOf(EventFilter<? super T, ? extends R> ... filters) {
                if (filters == null) {
                    AnyOf.$$$reportNull$$$0(0);
                }
                this.myFilters = filters;
            }

            @Override
            @Nullable
            public R apply(@NotNull T event, @NotNull Mode mode) {
                if (event == null) {
                    AnyOf.$$$reportNull$$$0(1);
                }
                if (mode == null) {
                    AnyOf.$$$reportNull$$$0(2);
                }
                for (EventFilter<T, R> eventFilter : this.myFilters) {
                    R result2 = eventFilter.apply(event, mode);
                    if (result2 == null) continue;
                    return result2;
                }
                return null;
            }

            public String toString() {
                return Arrays.toString(this.myFilters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$EventFilter$AnyOf";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static enum Mode {
            PROBE,
            ASSERT;

        }
    }

    public static class DriverEvent {
        @NotNull
        private final Kind<?> myKind;
        @NotNull
        public final String name;
        @Nullable
        public final String description;

        public DriverEvent(@NotNull Kind<?> kind) {
            if (kind == null) {
                DriverEvent.$$$reportNull$$$0(0);
            }
            this(kind, null, null);
        }

        public DriverEvent(@NotNull Kind<?> kind, @Nullable String name, @Nullable String description) {
            if (kind == null) {
                DriverEvent.$$$reportNull$$$0(1);
            }
            this.myKind = kind;
            this.name = (String)ObjectUtils.notNull((Object)name, (Object)kind.name);
            this.description = description;
        }

        public String toString() {
            String info = StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{this.name.equals(this.myKind.name) ? null : this.name, this.description == null ? null : " @" + this.description}), (String)": ");
            return this.myKind + (String)(info.isEmpty() ? "" : " (" + info + ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverEvent", "<init>"));
        }

        public static class Kind<T extends DriverEvent>
        implements EventFilter<DriverEvent, T> {
            public static final Kind<DriverEvent> RUNNING = new Kind("RUNNING");
            public static final Kind<DriverFinishedEvent> FINISHED = new Kind("FINISHED");
            public static final Kind<DriverCodepointEvent> BREAKPOINT = new Kind("BREAKPOINT");
            public static final Kind<DriverCodepointEvent> WATCHPOINT = new Kind("WATCHPOINT");
            public static final Kind<DriverSuspendEvent> SIGNAL = new Kind("SIGNAL");
            public static final Kind<DriverExceptionEvent> EXCEPTION = new Kind("EXCEPTION");
            public static final Kind<DriverSuspendEvent> INTERRUPTED = new Kind("INTERRUPTED");
            public static final Kind<DriverEvent> DEBUGGER_ATTACHED = new Kind("DEBUGGER_ATTACHED");
            public static final Kind<DriverEvent> DEBUGGER_DETACHED = new Kind("DEBUGGER_DETACHED");
            public static final Kind<DriverEvent> DEBUGGER_EXITED = new Kind("DEBUGGER_EXITED");
            public static final Kind<DriverBreakpointChangedEvent> BREAKPOINT_UPDATED = new Kind("BREAKPOINT_UPDATED");
            @NotNull
            private final String name;

            public Kind(@NotNull String name) {
                if (name == null) {
                    Kind.$$$reportNull$$$0(0);
                }
                this.name = name;
            }

            @Override
            @Nullable
            public T apply(@NotNull DriverEvent event, @NotNull EventFilter.Mode mode) {
                if (event == null) {
                    Kind.$$$reportNull$$$0(1);
                }
                if (mode == null) {
                    Kind.$$$reportNull$$$0(2);
                }
                return (T)(event.myKind == this ? event : null);
            }

            public String toString() {
                return this.name;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverEvent$Kind";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class DriverFinishedEvent
    extends DriverEvent {
        @NotNull
        public final DebuggerDriver.ExitStatus exitStatus;

        public DriverFinishedEvent(@NotNull DriverEvent.Kind<?> kind, @NotNull DebuggerDriver.ExitStatus exitStatus) {
            if (kind == null) {
                DriverFinishedEvent.$$$reportNull$$$0(0);
            }
            if (exitStatus == null) {
                DriverFinishedEvent.$$$reportNull$$$0(1);
            }
            super(kind, null, exitStatus.description);
            this.exitStatus = exitStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exitStatus";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverFinishedEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverBreakpointChangedEvent
    extends DriverEvent {
        @NotNull
        public final LLBreakpoint breakpoint;

        public DriverBreakpointChangedEvent(@NotNull DriverEvent.Kind<? extends DriverBreakpointChangedEvent> kind, @NotNull LLBreakpoint breakpoint) {
            if (kind == null) {
                DriverBreakpointChangedEvent.$$$reportNull$$$0(0);
            }
            if (breakpoint == null) {
                DriverBreakpointChangedEvent.$$$reportNull$$$0(1);
            }
            super(kind);
            this.breakpoint = breakpoint;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.breakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "breakpoint";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverBreakpointChangedEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverCodepointEvent
    extends DriverSuspendEvent {
        public final int number;

        public DriverCodepointEvent(@NotNull DriverEvent.Kind<? extends DriverCodepointEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, int number) {
            if (kind == null) {
                DriverCodepointEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverCodepointEvent.$$$reportNull$$$0(1);
            }
            super(kind, stopPlace);
            this.number = number;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverCodepointEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverExceptionEvent
    extends DriverSuspendEvent {
        @Nullable
        public final Address exceptionAddress;
        @Nullable
        public final String exceptionFile;
        @Nullable
        public final DebuggerSourceFileHash exceptionHash;
        public final int exceptionLine;

        public DriverExceptionEvent(@NotNull DriverEvent.Kind<? extends DriverExceptionEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable String description, @Nullable Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine) {
            if (kind == null) {
                DriverExceptionEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverExceptionEvent.$$$reportNull$$$0(1);
            }
            super(kind, stopPlace, null, description);
            this.exceptionAddress = exceptionAddress;
            this.exceptionFile = exceptionFile;
            this.exceptionHash = exceptionHash;
            this.exceptionLine = exceptionLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverExceptionEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DriverSuspendEvent
    extends DriverEvent {
        @NotNull
        public final DebuggerDriver.StopPlace stopPlace;

        public DriverSuspendEvent(@NotNull DriverEvent.Kind<? extends DriverSuspendEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace) {
            if (kind == null) {
                DriverSuspendEvent.$$$reportNull$$$0(0);
            }
            if (stopPlace == null) {
                DriverSuspendEvent.$$$reportNull$$$0(1);
            }
            this(kind, stopPlace, null, null);
        }

        public DriverSuspendEvent(@NotNull DriverEvent.Kind<? extends DriverSuspendEvent> kind, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable String name, @Nullable String description) {
            if (kind == null) {
                DriverSuspendEvent.$$$reportNull$$$0(2);
            }
            if (stopPlace == null) {
                DriverSuspendEvent.$$$reportNull$$$0(3);
            }
            super(kind, name, description);
            this.stopPlace = stopPlace;
        }

        @Override
        public String toString() {
            return super.toString() + "@" + this.stopPlace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopPlace";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggingFixture$DriverSuspendEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

