/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPTestDataFixture;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectFixture;
import com.jetbrains.cidr.cpp.execution.CMakeExecutionFixture;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArch;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CPPTestCase
extends CidrTestCase<CMakeProjectFixture, CMakeExecutionFixture, CidrDebuggingFixture<CMakeExecutionFixture>, CidrCodeInsightFixture> {
    @Nullable
    private static ArchitectureType ourMinGWArchitectureType;
    private static final Set<String> MSVC_ARCH_VALUE_X64;
    private static final Set<String> MSVC_ARCH_VALUES_X86;
    private static volatile String ourCurrentCMakeVersion;

    @Override
    protected void initApplication() {
        CPPTestCase.getTestCPPEnvironment();
        super.initApplication();
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CPPTestDataFixture();
    }

    @Override
    @NotNull
    protected CMakeProjectFixture createProjectFixture() {
        return new CMakeProjectFixture(this.myTestDataFixture);
    }

    @NotNull
    public static CPPEnvironment getTestCPPEnvironment() {
        return new CPPEnvironment(CPPTestCase.getTestToolchain());
    }

    public static boolean isUnixLikeEnvironment() {
        return CPPTestCase.getTestToolSet().getKind() == CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET || CPPTestCase.getTestToolSet().getKind() == CPPToolSet.Kind.SSH || CPPTestCase.getTestToolSet().getKind() == CPPToolSet.Kind.DOCKER || CPPTestCase.getTestCygwin() != null || CPPTestCase.getTestMinGW() != null || CPPTestCase.getTestWSL() != null;
    }

    @NotNull
    public static CPPToolSet getTestToolSet() {
        CPPToolSet cPPToolSet = CPPTestCase.getTestToolchain().getToolSet();
        if (cPPToolSet == null) {
            CPPTestCase.$$$reportNull$$$0(0);
        }
        return cPPToolSet;
    }

    @NotNull
    public static CPPToolchains.Toolchain getTestToolchain() {
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        if (toolchain == null) {
            CPPTestCase.$$$reportNull$$$0(1);
        }
        return toolchain;
    }

    public static void changeTestToolchain(@NotNull Consumer<CPPToolchains.Toolchain> changeFunction) {
        if (changeFunction == null) {
            CPPTestCase.$$$reportNull$$$0(2);
        }
        CPPTestCase.changeToolchains(CPPToolchains.getInstance(), (Consumer<CPPToolchains>)((Consumer)cppToolchains -> changeFunction.consume((Object)cppToolchains.getDefaultToolchain())));
    }

    public static void changeToolchains(@NotNull Consumer<CPPToolchains> changeFunction) {
        if (changeFunction == null) {
            CPPTestCase.$$$reportNull$$$0(3);
        }
        CPPTestCase.changeToolchains(CPPToolchains.getInstance(), changeFunction);
    }

    public static void changeToolchains(@NotNull CPPToolchains toolchains, @NotNull Consumer<CPPToolchains> changeFunction) {
        if (toolchains == null) {
            CPPTestCase.$$$reportNull$$$0(4);
        }
        if (changeFunction == null) {
            CPPTestCase.$$$reportNull$$$0(5);
        }
        WriteAction.runAndWait(() -> {
            toolchains.beginUpdate();
            try {
                changeFunction.consume((Object)toolchains);
            }
            finally {
                toolchains.endUpdate();
            }
        });
    }

    @Nullable
    public static MSVC getTestMSVC() {
        return CPPTestCase.getTestToolchain().getMSVC();
    }

    @Nullable
    public static String getTestMSVCArchString() {
        if (CPPTestCase.getTestMSVC() == null) {
            return null;
        }
        List options2 = CPPTestCase.getTestToolchain().getToolSetOptions();
        Triple versionTriple = MSVC.getOptions((List)options2);
        MSVC.Arch arch = (MSVC.Arch)versionTriple.component1();
        if (arch == null) {
            return null;
        }
        return arch.getValue();
    }

    @NotNull
    public static ArchitectureType getTestMSVCTargetArch() {
        String archValue = CPPTestCase.getTestMSVCArchString();
        if (archValue == null) {
            ArchitectureType architectureType = ArchitectureType.UNKNOWN;
            if (architectureType == null) {
                CPPTestCase.$$$reportNull$$$0(6);
            }
            return architectureType;
        }
        if (MSVC_ARCH_VALUE_X64.contains(archValue)) {
            ArchitectureType architectureType = ArchitectureType.X86_64;
            if (architectureType == null) {
                CPPTestCase.$$$reportNull$$$0(7);
            }
            return architectureType;
        }
        if (MSVC_ARCH_VALUES_X86.contains(archValue)) {
            ArchitectureType architectureType = ArchitectureType.I386;
            if (architectureType == null) {
                CPPTestCase.$$$reportNull$$$0(8);
            }
            return architectureType;
        }
        ArchitectureType architectureType = ArchitectureType.UNKNOWN;
        if (architectureType == null) {
            CPPTestCase.$$$reportNull$$$0(9);
        }
        return architectureType;
    }

    @Nullable
    public static MinGW getTestMinGW() {
        return CPPTestCase.getTestToolchain().getMinGW();
    }

    @Nullable
    public static ArchitectureType getTestMinGWArchitecture() {
        MinGW minGW = CPPTestCase.getTestMinGW();
        if (minGW == null) {
            return null;
        }
        if (ourMinGWArchitectureType != null) {
            return ourMinGWArchitectureType;
        }
        if (!minGW.isMinGW64()) {
            ourMinGWArchitectureType = ArchitectureType.I386;
        } else {
            Function parseTarget = s -> {
                if ("x86_64-w64-mingw32".equals(s)) {
                    return ArchitectureType.X86_64;
                }
                if ("i686-w64-mingw32".equals(s)) {
                    return ArchitectureType.I386;
                }
                return ArchitectureType.UNKNOWN;
            };
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{minGW.getSubFilePath("bin\\gcc.exe")});
            commandLine.addParameter("-v");
            minGW.prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.BUILD, Collections.emptyList());
            try {
                try (Scanner scanner = new Scanner(commandLine.createProcess().getErrorStream());){
                    while (scanner.hasNext()) {
                        if (scanner.findInLine("Target:") != null) {
                            ourMinGWArchitectureType = (ArchitectureType)parseTarget.fun((Object)scanner.next());
                            break;
                        }
                        scanner.nextLine();
                    }
                }
                if (ourMinGWArchitectureType == null) {
                    ourMinGWArchitectureType = ArchitectureType.UNKNOWN;
                }
            }
            catch (NoSuchElementException e) {
                CPPLog.LOG.error("Cannot parse gcc -v output");
                ourMinGWArchitectureType = ArchitectureType.UNKNOWN;
            }
            catch (ExecutionException e) {
                CPPLog.LOG.error(e.getMessage());
                ourMinGWArchitectureType = ArchitectureType.UNKNOWN;
            }
        }
        return ourMinGWArchitectureType;
    }

    @Nullable
    public static Cygwin getTestCygwin() {
        return CPPTestCase.getTestToolchain().getCygwin();
    }

    @Nullable
    public static WSL getTestWSL() {
        return CPPTestCase.getTestToolchain().getWSL();
    }

    @NotNull
    public static String getTestCMakeVersion() {
        if (ourCurrentCMakeVersion == null) {
            try {
                ourCurrentCMakeVersion = CPPTestCase.getTestCPPEnvironment().getCMake().readVersion();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot read current cmake version", e);
            }
        }
        String string = ourCurrentCMakeVersion;
        if (string == null) {
            CPPTestCase.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static Version getTestCMakeParsedVersion() {
        Version parsedVersion = Version.parseVersion((String)CPPTestCase.getTestCMakeVersion());
        CPPTestCase.assertNotNull((Object)parsedVersion);
        Version version = parsedVersion;
        if (version == null) {
            CPPTestCase.$$$reportNull$$$0(11);
        }
        return version;
    }

    @NotNull
    public static ToolVersion getTestCMakeParsedToolVersion() {
        Version parsedVersion = Version.parseVersion((String)CPPTestCase.getTestCMakeVersion());
        CPPTestCase.assertNotNull((Object)parsedVersion);
        return new ToolVersion(parsedVersion);
    }

    @Nullable
    private static File getCustomCompiler(@NotNull String compiler) {
        String key;
        String path;
        if (compiler == null) {
            CPPTestCase.$$$reportNull$$$0(12);
        }
        if ((path = System.getProperty(key = String.format("oc.test.compiler.path.%s", compiler))) != null) {
            HostMachine hostMachine = CPPTestCase.getTestCPPEnvironment().getHostMachine();
            File res = new File(path);
            if (!hostMachine.isRemote() && !res.exists()) {
                CPPTestCase.fail((String)String.format("%s=%s doesn't exist", key, path));
            }
            return res;
        }
        return null;
    }

    @Nullable
    private static File getGCC(@NotNull GCCVersion version) {
        File file2;
        if (version == null) {
            CPPTestCase.$$$reportNull$$$0(13);
        }
        String gccVersion = version.fileSuffix();
        if (SystemInfo.isWindows) {
            Cygwin env = CPPTestCase.getTestCygwin();
            if (env == null) {
                env = CPPTestCase.getTestMinGW();
            }
            if (env == null) {
                return null;
            }
            file2 = env.getSubFile("bin/gcc.exe");
        } else if (SystemInfo.isMac) {
            file2 = new File("/opt/local/bin/gcc-mp" + gccVersion);
            if (!file2.exists()) {
                file2 = new File("/usr/local/bin/gcc" + gccVersion);
            }
        } else {
            file2 = new File("/usr/bin/gcc" + gccVersion);
        }
        return file2;
    }

    private static void reportNoGCC(@Nullable File file2, @NotNull GCCVersion version) {
        if (version == null) {
            CPPTestCase.$$$reportNull$$$0(14);
        }
        LOG.warn("GCC executable could be specified with -Doc.test.compiler.path.gcc");
        CPPTestCase.fail((String)("GCC not found: " + file2));
    }

    @Nullable
    public static File getTestGCC() {
        File file2 = CPPTestCase.getCustomCompiler("gcc");
        if (file2 != null) {
            return file2;
        }
        GCCVersion testVersion = GCCVersion.SIX;
        file2 = CPPTestCase.getGCC(testVersion);
        if (file2 != null && !file2.exists()) {
            CPPTestCase.reportNoGCC(file2, testVersion);
        }
        return file2;
    }

    @Nullable
    private static File getClang(@NotNull ClangVersion version) {
        File file2;
        if (version == null) {
            CPPTestCase.$$$reportNull$$$0(15);
        }
        String clangVersion = version.fileSuffix;
        if (SystemInfo.isWindows) {
            if (CPPTestCase.getTestWSL() != null) {
                return new File("/usr/bin/clang");
            }
            return null;
        }
        if (SystemInfo.isMac) {
            file2 = new File("/opt/local/bin/clang-mp" + clangVersion);
            if (!file2.exists()) {
                file2 = new File("/usr/local/bin/clang" + clangVersion);
            }
            if (!file2.exists()) {
                file2 = new File(String.format("/usr/local/opt/llvm%s/bin/clang%s", version.brewSuffix, clangVersion));
            }
        } else {
            file2 = new File("/usr/bin/clang" + clangVersion);
        }
        return file2;
    }

    private static void reportNoClang(@Nullable File file2, @NotNull ClangVersion version) {
        if (version == null) {
            CPPTestCase.$$$reportNull$$$0(16);
        }
        LOG.warn("Clang executable could be specified with -Doc.test.compiler.path.clang");
        CPPTestCase.fail((String)("Clang not found: " + file2));
    }

    @Nullable
    public static File getTestClang() {
        File file2 = CPPTestCase.getCustomCompiler("clang");
        if (file2 != null) {
            return file2;
        }
        ClangVersion testVersion = ClangVersion.FIVE;
        file2 = CPPTestCase.getClang(testVersion);
        if (file2 != null && !file2.exists() && !SystemInfo.isWindows) {
            CPPTestCase.reportNoClang(file2, testVersion);
        }
        return file2;
    }

    @Nullable
    public static File getTestClangCl() {
        if (!SystemInfo.isWindows) {
            return null;
        }
        File customClangCl = CPPTestCase.getCustomCompiler("clang-cl");
        if (customClangCl != null) {
            return customClangCl;
        }
        File msvcCompiler = CPPTestCase.getTestMSVCCompiler();
        if (msvcCompiler == null) {
            return null;
        }
        File file2 = CPPToolchains.clangClDirFromRegistry();
        if (file2 != null) {
            return file2;
        }
        CPPToolSet toolset = CPPTestCase.getTestToolSet();
        String toolsetPath = null;
        if (toolset.isMSVC()) {
            MSVC msvcToolset = (MSVC)toolset;
            toolsetPath = msvcToolset.getHomePath();
        }
        file2 = CPPToolchains.clangClDirFromMSVC(toolsetPath);
        return file2;
    }

    @Nullable
    public static File getTestNVCC() {
        return CPPTestCase.getCustomCompiler("nvcc");
    }

    @Nullable
    public static File getTestMSVCCompiler() {
        File result2 = CPPTestCase.getCustomCompiler("msvc");
        if (result2 != null) {
            return result2;
        }
        CPPToolSet toolset = CPPTestCase.getTestToolSet();
        if (!toolset.isMSVC()) {
            return null;
        }
        MSVC msvcToolset = (MSVC)toolset;
        result2 = new File(msvcToolset.getHomePath(), "VC\\bin\\cl.exe");
        if (result2.exists()) {
            return result2;
        }
        File msvc = new File(msvcToolset.getHomePath(), "VC\\Tools\\MSVC");
        File[] versions = msvc.listFiles(file2 -> file2.isDirectory());
        if (versions != null) {
            Arrays.sort(versions, Comparator.reverseOrder());
            String archString = System.getProperty("cpp.test.msvc.arch");
            MSVCArch arch = archString == null ? MSVC.Arch.getDefault().getArch() : MSVCArch.fromString((String)archString);
            result2 = new File(versions[0], "bin\\Host" + MSVCArch.toMSVCString((CpuArch)arch.getSource(), (boolean)true) + "\\" + MSVCArch.toMSVCString((CpuArch)arch.getTarget(), (boolean)true) + "\\cl.exe");
            if (result2.exists()) {
                return result2;
            }
        }
        throw new RuntimeException("Compiler executable not found for " + toolset);
    }

    @NotNull
    public static List<Pair<OCCompilerKind, File>> getAvailableCompilers() {
        ArrayList<Pair<OCCompilerKind, File>> result2 = new ArrayList<Pair<OCCompilerKind, File>>();
        File path = CPPTestCase.getTestGCC();
        if (path != null) {
            result2.add(Pair.create((Object)GCCCompilerKind.INSTANCE, (Object)path));
        }
        if ((path = CPPTestCase.getTestClang()) != null) {
            result2.add(Pair.create((Object)ClangCompilerKind.INSTANCE, (Object)path));
        }
        if ((path = CPPTestCase.getTestMSVCCompiler()) != null) {
            result2.add(Pair.create((Object)MSVCCompilerKind.INSTANCE, (Object)path));
        }
        if ((path = CPPTestCase.getTestClangCl()) != null) {
            result2.add((Pair<OCCompilerKind, File>)Pair.create((Object)ClangClCompilerKind.INSTANCE, (Object)path));
        }
        ArrayList<Pair<OCCompilerKind, File>> arrayList = result2;
        if (arrayList == null) {
            CPPTestCase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    static {
        MSVC_ARCH_VALUE_X64 = Set.of("x64", "amd64", "x86_amd64");
        MSVC_ARCH_VALUES_X86 = Set.of("x86", "amd64_x86");
        ourCurrentCMakeVersion = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/CPPTestCase";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchains";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestToolSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestToolchain";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/CPPTestCase";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMSVCTargetArch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCMakeVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCMakeParsedVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableCompilers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changeTestToolchain";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeToolchains";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCustomCompiler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGCC";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportNoGCC";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getClang";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportNoClang";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private static enum GCCVersion {
        DEFAULT(""),
        SIX("6"),
        FIVE("5"),
        SEVEN("7"),
        EIGHT("8");

        @NotNull
        final String suffix;

        private GCCVersion(String suffix) {
            if (suffix == null) {
                GCCVersion.$$$reportNull$$$0(0);
            }
            this.suffix = suffix;
        }

        @NotNull
        String fileSuffix() {
            Object object = this == DEFAULT ? this.suffix : "-" + this.suffix;
            if (object == null) {
                GCCVersion.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/CPPTestCase$GCCVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/CPPTestCase$GCCVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileSuffix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static enum ClangVersion {
        DEFAULT("", ""),
        FIVE("-5.0", "@5"),
        SIX("-6.0", "@6"),
        SEVEN("-7.0", "@7");

        @NotNull
        final String fileSuffix;
        @NotNull
        final String brewSuffix;

        private ClangVersion(String fileSuffix, String brewSuffix) {
            if (fileSuffix == null) {
                ClangVersion.$$$reportNull$$$0(0);
            }
            if (brewSuffix == null) {
                ClangVersion.$$$reportNull$$$0(1);
            }
            this.fileSuffix = fileSuffix;
            this.brewSuffix = brewSuffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileSuffix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "brewSuffix";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/CPPTestCase$ClangVersion";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

