/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class CidrProjectViewFixture
implements CidrProjectDependentFixture {
    private final CidrProjectFixture myProjectFixture;

    public CidrProjectViewFixture(@NotNull CidrProjectFixture projectFixture2) {
        if (projectFixture2 == null) {
            CidrProjectViewFixture.$$$reportNull$$$0(0);
        }
        this.myProjectFixture = projectFixture2;
    }

    public void setUp() throws Exception {
        this.myProjectFixture.addProjectDependentFixture(this);
    }

    public void tearDown() throws Exception {
        this.myProjectFixture.removeProjectDependentFixture(this);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        if (symbolsKind == null) {
            CidrProjectViewFixture.$$$reportNull$$$0(1);
        }
        return symbolsKind;
    }

    protected abstract AbstractProjectViewPane createPane();

    public void assertNodes(String expectedNodes) {
        Assert.assertEquals((Object)expectedNodes, (Object)this.buildAndPrintTree(false));
    }

    public void assertNodesContain(String expectedNodes) {
        this.assertNodesContain(false, expectedNodes);
    }

    public void assertNodesContain(boolean printIcons, String expectedNodes) {
        String text = this.buildAndPrintTree(printIcons);
        List<String> textLines = List.of(text.split("\n"));
        UsefulTestCase.assertContainsOrdered(textLines, List.of(expectedNodes.split("\n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String buildAndPrintTree(boolean printIcons) {
        HashSet sourceNodes = new HashSet();
        AbstractProjectViewPane pane = this.createPane();
        pane.createComponent();
        JTree tree = pane.getTree();
        PlatformTestUtil.expandAll(tree);
        StringBuilder builder = new StringBuilder();
        this.printTree((ProjectViewTree)tree, tree.getModel().getRoot(), builder, "", sourceNodes, printIcons);
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            CidrProjectViewFixture.$$$reportNull$$$0(2);
        }
        return string2;
        finally {
            Disposer.dispose((Disposable)pane);
        }
    }

    private void printTree(ProjectViewTree tree, Object root2, StringBuilder builder, String indent, Set<AbstractTreeNode<?>> sourceNodes, boolean printIcons) {
        AbstractTreeNode node2 = TreeUtil.getAbstractTreeNode((Object)root2);
        if (node2 != null) {
            if ("External Libraries".equals(node2.getName())) {
                return;
            }
            builder.append(indent).append(node2.getName());
            if (node2.getPresentation().getLocationString() != null) {
                builder.append("@").append(node2.getPresentation().getLocationString());
            }
            if (printIcons) {
                builder.append(" ").append(CidrCodeInsightFixture.printIcon(node2.getIcon()));
            } else {
                FileColorManager colorManager = FileColorManager.getInstance((Project)this.myProjectFixture.getProject());
                Color color = tree.getFileColorFor((Object)node2);
                if (Objects.equals(color, colorManager.getScopeColor("Non-Project Files"))) {
                    builder.append(" [non-project]");
                } else {
                    builder.append(" [project]");
                }
                Icon icon = node2.getIcon();
                if (icon instanceof DeferredIcon) {
                    icon = ((DeferredIcon)icon).evaluate();
                }
                if (icon instanceof RowIcon) {
                    icon = (Icon)ContainerUtil.getFirstItem((List)((RowIcon)icon).getAllIcons());
                }
                if (icon == AllIcons.Modules.SourceRoot && !PlatformUtils.isAppCode()) {
                    builder.append(" [source root]");
                }
                if (icon == AllIcons.Modules.ExcludeRoot) {
                    builder.append(" [excluded root]");
                }
            }
        } else {
            builder.append("unknown node");
        }
        for (int i = 0; i < tree.getModel().getChildCount(root2); ++i) {
            builder.append("\n");
            this.printTree(tree, tree.getModel().getChild(root2, i), builder, indent + "  ", sourceNodes, printIcons);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrProjectViewFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrProjectViewFixture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAndPrintTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

