/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrRefactoringFixture;
import com.jetbrains.cidr.CidrTestUtils;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class CidrFormattingFixture {
    CidrCodeInsightFixture myCodeInsightFixture;
    private boolean smartIndentOnEnter;
    private int reformatOnPaste;

    public CidrFormattingFixture(@NotNull CidrCodeInsightFixture codeInsightFixture) {
        if (codeInsightFixture == null) {
            CidrFormattingFixture.$$$reportNull$$$0(0);
        }
        this.myCodeInsightFixture = codeInsightFixture;
    }

    public static void clearFields(@NotNull Class c, Object o) throws IllegalAccessException {
        if (c == null) {
            CidrFormattingFixture.$$$reportNull$$$0(1);
        }
        for (Field each : c.getFields()) {
            each.setAccessible(true);
            Class<?> type = each.getType();
            if ((each.getModifiers() & 0x18) != 0) continue;
            if (type == Integer.TYPE) {
                String name = each.getName();
                each.setInt(o, name.endsWith("BRACE_STYLE") || name.endsWith("BRACE_PLACEMENT") ? 1 : 0);
            }
            if (type != Boolean.TYPE) continue;
            each.setBoolean(o, false);
        }
    }

    public void setUp() throws Exception {
        this.initOCFormatterSettings();
        this.smartIndentOnEnter = CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER;
        CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER = true;
        this.reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE;
        CodeInsightSettings.getInstance().REFORMAT_ON_PASTE = 3;
    }

    public void tearDown() {
        this.myCodeInsightFixture.getCodeStyleSettings().clearCodeStyleSettings();
        CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER = this.smartIndentOnEnter;
        CodeInsightSettings.getInstance().REFORMAT_ON_PASTE = this.reformatOnPaste;
    }

    public void initOCFormatterSettings() throws Exception {
        CidrFormattingFixture.initOCFormatterSettings(this.myCodeInsightFixture);
    }

    public static void initOCFormatterSettings(CidrCodeInsightFixture insightFixture) throws Exception {
        CodeStyleSettings rs = insightFixture.getCodeStyleSettings();
        CommonCodeStyleSettings cs = insightFixture.getOCCommonSettings();
        OCCodeStyleSettings ocs = insightFixture.getOCSettings();
        CommonCodeStyleSettings.IndentOptions indentOptions = insightFixture.getOCCommonSettings().getIndentOptions();
        assert (indentOptions != null);
        CidrFormattingFixture.clearFields(CodeStyleSettings.class, rs);
        CidrFormattingFixture.clearFields(CommonCodeStyleSettings.class, cs);
        CidrFormattingFixture.clearFields(OCCodeStyleSettings.class, ocs);
        CidrFormattingFixture.clearFields(CommonCodeStyleSettings.IndentOptions.class, indentOptions);
        rs.setDefaultRightMargin(200);
        cs.RIGHT_MARGIN = -1;
        ocs.INDENT_CLASS_MEMBERS = 4;
        ocs.INDENT_C_STRUCT_MEMBERS = 4;
        ocs.INDENT_INSIDE_CODE_BLOCK = 4;
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 8;
        indentOptions.TAB_SIZE = 4;
    }

    public void keepAllStatementsInline() {
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_CLASSES_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCSettings().KEEP_NESTED_NAMESPACES_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCSettings().KEEP_STRUCTURES_IN_ONE_LINE = true;
    }

    public void wrapBodyIntoBraces() {
        this.myCodeInsightFixture.getOCCommonSettings().FOR_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().WHILE_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().DOWHILE_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().IF_BRACE_FORCE = 3;
    }

    public void assertFormatAfterRenameOC(String before2, String newName, String after2) {
        this.myCodeInsightFixture.configureByTextOC(CidrTestUtils.trimMargin(before2));
        CidrRefactoringFixture.performRename(this.myCodeInsightFixture.getEditor(), newName);
        this.myCodeInsightFixture.checkResult(CidrTestUtils.trimMargin(after2));
    }

    public void assertFormatAfterIntroduceVarOC(String before2, String after2) {
        this.assertFormattingAfterIntroduceVar(before2, after2, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertFormatAfterIntroduceVarCpp(String before2, String after2) {
        this.assertFormattingAfterIntroduceVar(before2, after2, (OCLanguageKind)CLanguageKind.CPP);
    }

    private void assertFormattingAfterIntroduceVar(String before2, String after2, OCLanguageKind language) {
        this.myCodeInsightFixture.configureByText(CidrTestUtils.trimMargin(before2), language);
        this.invoke(CidrRefactoringFixture.getActionFromRefactoringActionHandler(CidrRefactoringFixture.ourVariableIntroducer));
        this.myCodeInsightFixture.checkResult(CidrTestUtils.trimMargin(after2));
    }

    private void invoke(LanguageCodeInsightActionHandler handler) {
        handler.invoke(this.myCodeInsightFixture.getProject(), this.myCodeInsightFixture.getEditor(), this.myCodeInsightFixture.getFile());
    }

    public void assertFormatAfterIntroduceParamOC(String before2, String after2) {
        this.myCodeInsightFixture.configureByTextOC(CidrTestUtils.trimMargin(before2));
        this.invoke(CidrRefactoringFixture.getActionFromRefactoringActionHandler(CidrRefactoringFixture.ourParamIntroducer));
        this.myCodeInsightFixture.checkResult(CidrTestUtils.trimMargin(after2));
    }

    public void assertFormatAfterCompletionOC(String before2, String after2) {
        this.myCodeInsightFixture.configureByTextOC(CidrTestUtils.trimMargin(before2));
        this.myCodeInsightFixture.complete(CompletionType.SMART, 1);
        this.myCodeInsightFixture.checkResult(CidrTestUtils.trimMargin(after2));
    }

    public void assertFormatAfterExtractMethodOC(String before2, String after2) {
        this.assertFormatAfterExtractMethod(before2, after2, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertFormatAfterExtractMethodCpp(String before2, String after2) {
        this.assertFormatAfterExtractMethod(before2, after2, (OCLanguageKind)CLanguageKind.CPP);
    }

    public void assertFormatAfterExtractMethod(String before2, String after2, OCLanguageKind languageKind) {
        this.myCodeInsightFixture.configureByText(CidrTestUtils.trimMargin(before2), languageKind);
        CidrRefactoringFixture.ourExtractMethodHandler.invoke(this.myCodeInsightFixture.getProject(), this.myCodeInsightFixture.getEditor(), (PsiFile)this.myCodeInsightFixture.getOCFile(), ((EditorEx)this.myCodeInsightFixture.getEditor()).getDataContext());
        this.myCodeInsightFixture.checkResult(CidrTestUtils.trimMargin(after2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/CidrFormattingFixture";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "clearFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

