/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageWordCompletion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionPolicy {
    public String getPossibleSelectionCharacters() {
        return "\n\t\r .(";
    }

    @Nullable
    protected String getExpectedVariant(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement leaf, @Nullable PsiReference ref) {
        String leafText;
        if (editor == null) {
            CompletionPolicy.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CompletionPolicy.$$$reportNull$$$0(1);
        }
        if (leaf == null) {
            CompletionPolicy.$$$reportNull$$$0(2);
        }
        if (this.isAfterError(file2, leaf)) {
            return null;
        }
        String string = leafText = ref != null ? ref.getRangeInElement().substring(ref.getElement().getText()) : leaf.getText();
        if (leafText.isEmpty() || !Character.isLetter(leafText.charAt(0)) || leaf instanceof PsiWhiteSpace || PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])new Class[]{PsiComment.class}) != null) {
            return null;
        }
        IElementType leafType = PsiUtilCore.getElementType((PsiElement)leaf);
        if ("org.intellij.lang.regexp.RegExpElementType".equals(leafType.getClass().getName())) {
            if (leafText.length() == 1) {
                return null;
            }
            if ("NAME".equals(leafType.toString())) {
                return null;
            }
        }
        if (CompletionPolicy.isDeclarationName(editor, file2, leaf, ref)) {
            return null;
        }
        if (ref != null) {
            PsiElement target2 = CompletionPolicy.getValidResolveResult(ref);
            if (target2 == null || !this.shouldSuggestReferenceText(ref, target2)) {
                return null;
            }
            if (ref instanceof PsiMultiReference) {
                for (PsiReference ref1 : ((PsiMultiReference)ref).getReferences()) {
                    if (!target2.getClass().isInstance(ref1.resolve()) || this.shouldSuggestReferenceText(ref1, target2)) continue;
                    return null;
                }
            }
        } else {
            if (!SyntaxTraverser.psiTraverser((PsiElement)file2).filter(PsiErrorElement.class).isEmpty()) {
                return null;
            }
            if (LanguageWordCompletion.INSTANCE.isEnabledIn(leafType)) {
                return null;
            }
            if (!this.shouldSuggestNonReferenceLeafText(leaf)) {
                return null;
            }
        }
        return leafText;
    }

    protected boolean isAfterError(@NotNull PsiFile file2, @NotNull PsiElement leaf) {
        if (file2 == null) {
            CompletionPolicy.$$$reportNull$$$0(3);
        }
        if (leaf == null) {
            CompletionPolicy.$$$reportNull$$$0(4);
        }
        return MadTestingUtil.isAfterError(file2, leaf.getTextRange().getStartOffset());
    }

    public boolean shouldCheckDuplicates(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement leaf) {
        if (editor == null) {
            CompletionPolicy.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            CompletionPolicy.$$$reportNull$$$0(6);
        }
        return leaf != null && !this.isAfterError(file2, leaf);
    }

    public boolean areDuplicatesOk(@NotNull LookupElement item1, @NotNull LookupElement item2) {
        if (item1 == null) {
            CompletionPolicy.$$$reportNull$$$0(7);
        }
        if (item2 == null) {
            CompletionPolicy.$$$reportNull$$$0(8);
        }
        return false;
    }

    private static PsiElement getValidResolveResult(@NotNull PsiReference ref) {
        if (ref == null) {
            CompletionPolicy.$$$reportNull$$$0(9);
        }
        if (ref instanceof PsiPolyVariantReference) {
            for (ResolveResult result2 : ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (result2.isValidResult()) continue;
                return null;
            }
        }
        return ref.resolve();
    }

    private static boolean isDeclarationName(Editor editor, PsiFile file2, PsiElement leaf, @Nullable PsiReference ref) {
        PsiElement nameIdentifier;
        PsiFile targetFile;
        PsiElement target2 = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        if (target2 != null) {
            target2 = target2.getNavigationElement();
        }
        PsiFile psiFile = targetFile = target2 != null ? target2.getContainingFile() : null;
        if (targetFile == null || targetFile.getViewProvider() != file2.getViewProvider()) {
            return false;
        }
        if (target2.getTextOffset() == leaf.getTextRange().getStartOffset() || ref != null && target2.getTextOffset() == ref.getElement().getTextRange().getStartOffset() + ref.getRangeInElement().getStartOffset()) {
            return true;
        }
        return target2 instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)target2).getNameIdentifier()) != null && PsiTreeUtil.isAncestor((PsiElement)nameIdentifier, (PsiElement)leaf, (boolean)false);
    }

    protected boolean shouldSuggestNonReferenceLeafText(@NotNull PsiElement leaf) {
        if (leaf == null) {
            CompletionPolicy.$$$reportNull$$$0(10);
        }
        return true;
    }

    protected boolean shouldSuggestReferenceText(@NotNull PsiReference ref, @NotNull PsiElement target2) {
        if (ref == null) {
            CompletionPolicy.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            CompletionPolicy.$$$reportNull$$$0(12);
        }
        return !(ref instanceof WebReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item2";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/propertyBased/CompletionPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedVariant";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterError";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCheckDuplicates";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "areDuplicatesOk";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidResolveResult";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSuggestNonReferenceLeafText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSuggestReferenceText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

