/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.impl;

import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.AssertionsKt;
import org.opentest4j.MultipleFailuresError;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/testFramework/junit5/impl/TestUncaughtExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "()V", "uncaughtExceptions", "Lcom/intellij/util/containers/ConcurrentList;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "assertAllExceptionAreCaught", "", "uncaughtException", "t", "Ljava/lang/Thread;", "e", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class TestUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    private final ConcurrentList<Throwable> uncaughtExceptions;

    public TestUncaughtExceptionHandler() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.uncaughtExceptions = concurrentList;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.uncaughtExceptions.add((Object)e);
    }

    public final void assertAllExceptionAreCaught() {
        Throwable throwable;
        switch (this.uncaughtExceptions.size()) {
            case 0: {
                return;
            }
            case 1: {
                throwable = (Throwable)this.uncaughtExceptions.get(0);
                break;
            }
            default: {
                throwable = new MultipleFailuresError(null, (List)this.uncaughtExceptions);
            }
        }
        Throwable e = throwable;
        AssertionsKt.fail((String)"Uncaught exceptions", (Throwable)e);
        throw new KotlinNothingValueException();
    }
}

