/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

public final class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    public static void compareWithExpected(Element expectedDoc, Element doc, boolean checkRange) throws Exception {
        ArrayList expectedProblems = new ArrayList(expectedDoc.getChildren("problem"));
        ArrayList reportedProblems = new ArrayList(doc.getChildren("problem"));
        for (Element problem1 : reportedProblems) {
            for (Element problem2 : reportedProblems) {
                if (problem1 == problem2 || !InspectionTestUtil.compareProblemWithExpected(problem1, problem2, checkRange)) continue;
                Assert.fail((String)("Duplicated problems reported: " + JDOMUtil.writeDocument((Document)new Document(problem1))));
            }
        }
        Element[] expectedArray = expectedProblems.toArray(new Element[0]);
        ArrayList<CallSite> problems = new ArrayList<CallSite>();
        block2: for (Element expectedProblem : expectedArray) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[0])) {
                if (!InspectionTestUtil.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block2;
            }
            Document missing = new Document(expectedProblem.clone());
            problems.add((CallSite)((Object)("The following haven't been reported as expected: " + JDOMUtil.writeDocument((Document)missing))));
        }
        for (Element reportedProblem : reportedProblems) {
            Document extra = new Document(reportedProblem.clone());
            problems.add((CallSite)((Object)("The following has been unexpectedly reported: " + JDOMUtil.writeDocument((Document)extra))));
        }
        if (!problems.isEmpty()) {
            Assert.fail((String)(String.join((CharSequence)"\n", problems) + "\n where all reported are: " + JDOMUtil.writeElement((Element)doc) + "\n all expected are: " + JDOMUtil.writeElement((Element)expectedDoc)));
        }
    }

    private static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestUtil.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestUtil.compareTextRange(reportedProblem, expectedProblem);
    }

    private static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Objects.equals(reportedTextRange.getAttributeValue("TYPE"), expectedTextRange.getAttributeValue("TYPE")) && Objects.equals(reportedTextRange.getAttributeValue("FQNAME"), expectedTextRange.getAttributeValue("FQNAME"));
    }

    private static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(47);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf(word, idx);
            if (idx == -1) {
                return false;
            }
            idx += word.length();
        }
        return true;
    }

    private static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Objects.equals(reportedProblem.getChildText("line"), expectedProblem.getChildText("line"));
    }

    private static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        if (reportedFileName == null) {
            return true;
        }
        File reportedFile = new File(reportedFileName);
        return Objects.equals(reportedFile.getName(), expectedProblem.getChildText("file"));
    }

    public static void compareToolResults(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, boolean checkRange, @NotNull String testDir) {
        if (context2 == null) {
            InspectionTestUtil.$$$reportNull$$$0(0);
        }
        if (toolWrapper == null) {
            InspectionTestUtil.$$$reportNull$$$0(1);
        }
        if (testDir == null) {
            InspectionTestUtil.$$$reportNull$$$0(2);
        }
        InspectionTestUtil.compareToolResults(context2, checkRange, testDir, Collections.singletonList(toolWrapper));
    }

    static void compareToolResults(@NotNull GlobalInspectionContextImpl context2, boolean checkRange, @NotNull String testDir, @NotNull Collection<? extends InspectionToolWrapper<?, ?>> toolWrappers) {
        if (context2 == null) {
            InspectionTestUtil.$$$reportNull$$$0(3);
        }
        if (testDir == null) {
            InspectionTestUtil.$$$reportNull$$$0(4);
        }
        if (toolWrappers == null) {
            InspectionTestUtil.$$$reportNull$$$0(5);
        }
        Element root2 = new Element("problems");
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            InspectionToolPresentation presentation = context2.getPresentation(toolWrapper);
            presentation.updateContent();
            presentation.exportResults(p -> root2.addContent(p), x -> false, x -> false);
        }
        try {
            File file2 = new File(testDir + "/expected.xml");
            InspectionTestUtil.compareWithExpected(JDOMUtil.load((File)file2), root2, checkRange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @TestOnly
    public static void runTool(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull AnalysisScope scope, @NotNull GlobalInspectionContextForTests globalContext) {
        if (toolWrapper == null) {
            InspectionTestUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            InspectionTestUtil.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            InspectionTestUtil.$$$reportNull$$$0(8);
        }
        IndexingTestUtil.waitUntilIndexesAreReady(scope.getProject());
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            HighlightDisplayKey.register((String)shortName, (String)toolWrapper.getDisplayName(), (String)toolWrapper.getID());
        }
        globalContext.doInspections(scope);
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (!globalContext.isFinished());
    }

    @NotNull
    public static <T extends InspectionProfileEntry> List<InspectionProfileEntry> instantiateTools(@NotNull Collection<Class<? extends T>> inspections) {
        if (inspections == null) {
            InspectionTestUtil.$$$reportNull$$$0(9);
        }
        Set classNames = JBIterable.from(inspections).transform(Class::getName).toSet();
        return InspectionTestUtil.instantiateTools(classNames);
    }

    public static <T extends InspectionProfileEntry> T instantiateTool(Class<? extends T> inspection) {
        return (T)InspectionTestUtil.instantiateTools(Collections.singleton(inspection)).get(0);
    }

    @NotNull
    public static List<InspectionProfileEntry> instantiateTools(Set<String> classNames) {
        List tools = JBIterable.of((Object[])new ExtensionPointName[]{LocalInspectionEP.LOCAL_INSPECTION, InspectionEP.GLOBAL_INSPECTION}).flatten(o -> o.getExtensionList()).filter(o -> classNames.contains(o.implementationClass)).transform(InspectionEP::instantiateTool).toList();
        if (tools.size() != classNames.size()) {
            TreeSet<String> missing = new TreeSet<String>(classNames);
            missing.removeAll(JBIterable.from((Iterable)tools).transform(o -> o.getClass().getName()).toSet());
            throw new RuntimeException("Unregistered inspections requested: " + missing);
        }
        List list = tools;
        if (list == null) {
            InspectionTestUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareToolResults";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTools";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

