/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorSplitterState;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.FileEditorManagerTestCase;
import com.intellij.testFramework.FileEditorManagerTestCaseKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0014R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/testFramework/FileEditorManagerTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "manager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "createTempFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "content", "", "getFile", "getProjectDescriptor", "Lcom/intellij/testFramework/LightProjectDescriptor;", "openFiles", "", "femSerialisedText", "setUp", "tearDown", "intellij.platform.testFramework"})
public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    @JvmField
    @Nullable
    protected FileEditorManagerImpl manager;

    @Override
    public void setUp() {
        super.setUp();
        Project project2 = this.getProject();
        project2.putUserData(FileEditorManagerImpl.ALLOW_IN_LIGHT_PROJECT, (Object)true);
        Intrinsics.checkNotNull((Object)project2);
        this.manager = new FileEditorManagerImpl(project2, CoroutineScopeKt.childScope$default((CoroutineScope)((ComponentManagerEx)project2).getCoroutineScope(), null, (boolean)false, (int)3, null));
        ComponentManager componentManager = (ComponentManager)project2;
        FileEditorManagerImpl fileEditorManagerImpl = this.manager;
        Intrinsics.checkNotNull((Object)fileEditorManagerImpl);
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        ServiceContainerUtil.replaceService(componentManager, FileEditorManager.class, fileEditorManagerImpl, disposable);
        FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)fileEditorProviderManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl");
        ((FileEditorProviderManagerImpl)fileEditorProviderManager).clearSelectedProviders();
        if (!(DockManager.getInstance((Project)project2).getContainers().size() == 1)) {
            boolean bl = false;
            String string = "The previous test didn't clear the state";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return FileEditorManagerTestCaseKt.access$getCUSTOM_PROJECT_DESCRIPTOR$p();
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        Function0[] function0Array = new Function0[]{new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                    if (fileEditorManagerImpl == null) break block0;
                    fileEditorManagerImpl.closeAllFiles();
                }
            }
        }, new Function0<Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                if (this.$project != null) {
                    Project project2 = this.$project;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"$project");
                    EditorHistoryManager.Companion.getInstance(project2).removeAllFiles();
                }
            }
        }, tearDown.3.INSTANCE, new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    FileEditorManagerImpl fileEditorManagerImpl = this.this$0.manager;
                    if (fileEditorManagerImpl == null) break block0;
                    FileEditorManagerImpl it = fileEditorManagerImpl;
                    boolean bl = false;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
            }
        }, new Function0<Unit>(this, project2){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.this$0.manager = null;
                if (this.$project != null) {
                    Project project2 = this.$project;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"$project");
                    ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
                    boolean $i$f$serviceIfCreated = false;
                    DockManager dockManager = (DockManager)$this$serviceIfCreated$iv.getServiceIfCreated(DockManager.class);
                    Set<E> set = dockManager != null ? dockManager.getContainers() : null;
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                    BasePlatformTestCase.assertSize(1, (Collection)set);
                }
            }
        }, new Function0<Unit>(this){
            final /* synthetic */ FileEditorManagerTestCase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileEditorManagerTestCase.access$tearDown$s497353094(this.this$0);
            }
        }};
        RunAllKt.runAll(function0Array);
    }

    @NotNull
    protected final VirtualFile getFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file2);
        VirtualFile virtualFile = file2;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @NotNull
    protected final VirtualFile createTempFile(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String[] stringArray = new String[]{path};
        Path io = Path.of(FileUtil.getTempDirectory(), stringArray);
        Intrinsics.checkNotNull((Object)io);
        PathKt.write((Path)io, (byte[])content);
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(io);
        BasePlatformTestCase.assertNotNull((String)("Can't find " + io), (Object)file2);
        VirtualFile virtualFile = file2;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    protected final void openFiles(@NotNull String femSerialisedText) {
        Intrinsics.checkNotNullParameter((Object)femSerialisedText, (String)"femSerialisedText");
        Element element = JDOMUtil.load((CharSequence)femSerialisedText);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element rootElement = element;
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        TasksKt.runWithModalProgressBlocking((Project)project2, (String)"", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rootElement, null){
            Object L$0;
            int label;
            final /* synthetic */ FileEditorManagerTestCase this$0;
            final /* synthetic */ Element $rootElement;
            {
                this.this$0 = $receiver;
                this.$rootElement = $rootElement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.this$0.manager;
                        Intrinsics.checkNotNull((Object)v0);
                        this.label = 1;
                        v1 = EditorsSplitters.restoreEditors$default((EditorsSplitters)v0.getMainSplitters(), (EditorSplitterState)new EditorSplitterState(this.$rootElement), (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        v2 = this.this$0.manager;
                        Intrinsics.checkNotNull((Object)v2);
                        $this$forEach$iv = SequencesKt.flatMap((Sequence)v2.getMainSplitters().windows(), (Function1)openFiles.1.INSTANCE);
                        $i$f$forEach = false;
                        var4_5 = $this$forEach$iv.iterator();
lbl20:
                        // 3 sources

                        while (var4_5.hasNext()) {
                            element$iv = var4_5.next();
                            it = (EditorComposite)element$iv;
                            $i$a$-forEach-FileEditorManagerTestCase$openFiles$1$2 = false;
                            this.L$0 = var4_5;
                            this.label = 2;
                            v3 = it.waitForAvailable((Continuation)this);
                            if (v3 != var8_2) continue;
                            return var8_2;
                        }
                        break;
                    }
                    case 2: {
                        $i$f$forEach = false;
                        $i$a$-forEach-FileEditorManagerTestCase$openFiles$1$2 = false;
                        var4_5 = (Iterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl20
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ void access$tearDown$s497353094(FileEditorManagerTestCase $this) {
        super.tearDown();
    }
}

