/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.terminal;

import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.process.SshShellProcess;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ProcessTtyConnector;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/terminal/JschProcessTtyConnector;", "Lcom/jediterm/terminal/ProcessTtyConnector;", "process", "Lcom/intellij/ssh/process/SshShellProcess;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/ssh/process/SshShellProcess;Ljava/nio/charset/Charset;)V", "myChannel", "Lcom/intellij/ssh/channels/ShellChannel;", "myHost", "", "close", "", "getName", "isConnected", "", "resize", "termSize", "Lcom/jediterm/core/util/TermSize;", "intellij.gateway.terminal"})
public final class JschProcessTtyConnector
extends ProcessTtyConnector {
    @NotNull
    private final ShellChannel myChannel;
    @NotNull
    private final String myHost;

    public JschProcessTtyConnector(@NotNull SshShellProcess process, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super((Process)process, charset);
        SshChannel sshChannel = process.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)sshChannel, (String)"getChannel(...)");
        this.myChannel = (ShellChannel)sshChannel;
        this.myHost = process.getSession().getHost();
    }

    public void close() {
        this.myChannel.close();
    }

    public void resize(@NotNull TermSize termSize) {
        Intrinsics.checkNotNullParameter((Object)termSize, (String)"termSize");
        this.myChannel.setPtySize(termSize.getColumns(), termSize.getRows(), 0, 0);
    }

    public boolean isConnected() {
        return this.myChannel.isConnected();
    }

    @NotNull
    public String getName() {
        return this.myHost;
    }
}

