/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrWSLDistribution {
    public static final Logger LOG = Logger.getInstance(CidrWSLDistribution.class);
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;
    private final String myWslDistributionName;
    private final NullableLazyValue<@Nullable WSLDistribution> myWslDistribution;
    private static final int RESOLVE_SYMLINK_TIMEOUT = 5000;

    public CidrWSLDistribution(@NotNull String name) {
        if (name == null) {
            CidrWSLDistribution.$$$reportNull$$$0(0);
        }
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.myWslDistributionName = name;
        this.myWslDistribution = NullableLazyValue.atomicLazyNullable(() -> CidrWSLDistribution.getDistribution(name));
    }

    @NotNull
    public String getWslDistributionName() {
        String string = this.myWslDistributionName;
        if (string == null) {
            CidrWSLDistribution.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return (WSLDistribution)this.myWslDistribution.getValue();
    }

    @Nullable
    public WSLDistribution getWslDistributionFast() {
        if (!this.myWslDistribution.isComputed()) {
            return null;
        }
        return (WSLDistribution)this.myWslDistribution.getValue();
    }

    public static List<String> getDistributions() {
        return ContainerUtil.map(WSLCidrUtil.getAvailableDistributions(), dist -> dist.getMsId());
    }

    private static boolean isUnixAbsolutePath(String path) {
        return OSAgnosticPathUtil.isAbsolute((String)path) && !OSAgnosticPathUtil.isAbsoluteDosPath((String)path) && !OSAgnosticPathUtil.isUncPath((String)path);
    }

    @Contract(value="_,null -> null; _,!null -> !null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        Object localPath = absoluteOrRelativeEnvPath;
        if (!CidrWSLDistribution.isUnixAbsolutePath(absoluteOrRelativeEnvPath) && localBaseDir != null) {
            localPath = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)localPath);
        WSLDistribution distribution = this.getWslDistributionFast();
        if (CidrWSLDistribution.isUnixAbsolutePath(canonicalPath)) {
            if (distribution != null) {
                return distribution.getWindowsPath(canonicalPath);
            }
            if (!this.myWslDistributionName.contains("/")) {
                distribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.myWslDistributionName);
                return distribution.getWindowsPath(canonicalPath, () -> "/mnt/");
            }
        }
        return FileUtil.toSystemDependentName((String)canonicalPath);
    }

    @Contract(value="null -> null; !null -> !null")
    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        WSLDistribution distribution = this.getWslDistribution();
        String path = distribution != null ? distribution.getWslPath(localPath) : null;
        return FileUtil.toSystemIndependentName((String)(path != null ? path : localPath));
    }

    @NotNull
    public String resolveSymlink(@NotNull String path) {
        WSLDistribution distribution;
        if (path == null) {
            CidrWSLDistribution.$$$reportNull$$$0(2);
        }
        if ((distribution = this.getWslDistribution()) == null) {
            String string = path;
            if (string == null) {
                CidrWSLDistribution.$$$reportNull$$$0(3);
            }
            return string;
        }
        return CidrWSLDistribution.resolveSymlink(path, distribution, this.mySymlinkCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String resolveSymlink(@NotNull String path, @NotNull WSLDistribution distribution, @NotNull @NotNull SLRUMap<@NotNull String, @NotNull String> cache) {
        if (path == null) {
            CidrWSLDistribution.$$$reportNull$$$0(4);
        }
        if (distribution == null) {
            CidrWSLDistribution.$$$reportNull$$$0(5);
        }
        if (cache == null) {
            CidrWSLDistribution.$$$reportNull$$$0(6);
        }
        SLRUMap<String, String> sLRUMap = cache;
        synchronized (sLRUMap) {
            String result2 = (String)cache.get((Object)path);
            if (result2 != null) {
                String string = result2;
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                if (string == null) {
                    CidrWSLDistribution.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String result3 = distribution.resolveSymlink(path, 5000);
        SLRUMap<String, String> sLRUMap2 = cache;
        synchronized (sLRUMap2) {
            cache.put((Object)path, (Object)result3);
        }
        String string = result3;
        if (string == null) {
            CidrWSLDistribution.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAbsolutePath(@NotNull String wslOrWindowsPath) {
        if (wslOrWindowsPath == null) {
            CidrWSLDistribution.$$$reportNull$$$0(9);
        }
        return OSAgnosticPathUtil.isAbsolute((String)wslOrWindowsPath);
    }

    @Nullable
    private static WSLDistribution getDistribution(@NotNull String name) {
        WSLDistribution distribution;
        if (name == null) {
            CidrWSLDistribution.$$$reportNull$$$0(10);
        }
        if ((distribution = WSLCidrUtil.getDistributionByMsId(name)) == null) {
            distribution = WSLCidrUtil.getDistributionByExecutionPath(name);
        }
        return distribution;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLDistribution";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslOrWindowsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLDistribution";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionName";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDistribution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

