/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUnixPipe
implements NamedPipe {
    private static final Logger LOG = Logger.getInstance(RemoteUnixPipe.class);
    @NotNull
    final HostMachine myHost;
    @NotNull
    final String myName;
    @Nullable
    Process myInputProcess;
    @Nullable
    Process myOutputProcess;

    public RemoteUnixPipe(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteUnixPipe.$$$reportNull$$$0(0);
        }
        this(host, CidrToolsUtil.generateTempFileName(host));
    }

    public RemoteUnixPipe(@NotNull HostMachine host, @NotNull String name) throws ExecutionException {
        if (host == null) {
            RemoteUnixPipe.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RemoteUnixPipe.$$$reportNull$$$0(2);
        }
        CidrToolsUtil.assertUnixOnly(host.getOSType());
        this.myHost = host;
        this.myName = name;
        RemoteUnixPipe.createNamedPipe(host, name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RemoteUnixPipe.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() throws IOException {
        this.myInputProcess = this.runProcess(new GeneralCommandLine(new String[]{"tee", this.myName}));
        return new BufferedOutputStream(this.myInputProcess.getOutputStream()){

            @Override
            public void close() throws IOException {
                try {
                    RemoteUnixPipe.this.close();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        this.myOutputProcess = this.runProcess(new GeneralCommandLine(new String[]{"cat", this.myName}));
        return new BufferedInputStream(this.myOutputProcess.getInputStream()){

            @Override
            public void close() throws IOException {
                try {
                    RemoteUnixPipe.this.close();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void close() {
        if (this.myInputProcess != null) {
            this.myInputProcess.destroy();
        }
        if (this.myOutputProcess != null) {
            this.myOutputProcess.destroy();
        }
        RemoteUnixPipe.rmSilently(this.myHost, this.myName);
    }

    private Process runProcess(@NotNull GeneralCommandLine cmd) throws IOException {
        if (cmd == null) {
            RemoteUnixPipe.$$$reportNull$$$0(4);
        }
        try {
            BaseProcessHandler<?> handler = this.myHost.createProcessBuilder().withCapturedOutput(false).build(cmd);
            handler.startNotify();
            return handler.getProcess();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static void rmSilently(@NotNull HostMachine host, @NotNull String path) {
        if (host == null) {
            RemoteUnixPipe.$$$reportNull$$$0(5);
        }
        if (path == null) {
            RemoteUnixPipe.$$$reportNull$$$0(6);
        }
        try {
            Path nioPath = host.getPath(path, new String[0]);
            if (host instanceof CidrWSLHost) {
                if (!WSLCidrUtil.delete(nioPath)) {
                    LOG.warn("cannot remove file: " + path);
                }
            } else {
                Files.delete(nioPath);
            }
        }
        catch (IOException e) {
            LOG.warn("cannot remove file: " + path, (Throwable)e);
        }
    }

    private static void createNamedPipe(@NotNull HostMachine host, @NotNull String name) throws ExecutionException {
        if (host == null) {
            RemoteUnixPipe.$$$reportNull$$$0(7);
        }
        if (name == null) {
            RemoteUnixPipe.$$$reportNull$$$0(8);
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"mkfifo", name});
        ProcessOutput output = host.runProcess(cmd, null, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        if (LOG.isDebugEnabled()) {
            LOG.debug(CidrToolsUtil.logInfo(cmd, output));
        }
        CidrToolsUtil.checkSuccess(cmd, output, LOG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteUnixPipe";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteUnixPipe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rmSilently";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNamedPipe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

