/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003JO\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/ByteCoordinates;", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "byteInRegion", "", "lineInRegion", "byteInLine", "byteInWord", "hexRange", "Lcom/intellij/openapi/util/TextRange;", "asciiRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;IIIILcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getAsciiRange", "()Lcom/intellij/openapi/util/TextRange;", "getByteInLine", "()I", "getByteInRegion", "getByteInWord", "getHexRange", "getLineInRegion", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.debugger"})
public final class ByteCoordinates {
    @NotNull
    private final Address address;
    private final int byteInRegion;
    private final int lineInRegion;
    private final int byteInLine;
    private final int byteInWord;
    @NotNull
    private final TextRange hexRange;
    @NotNull
    private final TextRange asciiRange;

    public ByteCoordinates(@NotNull Address address2, int byteInRegion, int lineInRegion, int byteInLine, int byteInWord, @NotNull TextRange hexRange, @NotNull TextRange asciiRange) {
        Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
        Intrinsics.checkNotNullParameter((Object)hexRange, (String)"hexRange");
        Intrinsics.checkNotNullParameter((Object)asciiRange, (String)"asciiRange");
        this.address = address2;
        this.byteInRegion = byteInRegion;
        this.lineInRegion = lineInRegion;
        this.byteInLine = byteInLine;
        this.byteInWord = byteInWord;
        this.hexRange = hexRange;
        this.asciiRange = asciiRange;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    public final int getByteInRegion() {
        return this.byteInRegion;
    }

    public final int getLineInRegion() {
        return this.lineInRegion;
    }

    public final int getByteInLine() {
        return this.byteInLine;
    }

    public final int getByteInWord() {
        return this.byteInWord;
    }

    @NotNull
    public final TextRange getHexRange() {
        return this.hexRange;
    }

    @NotNull
    public final TextRange getAsciiRange() {
        return this.asciiRange;
    }

    @NotNull
    public final Address component1() {
        return this.address;
    }

    public final int component2() {
        return this.byteInRegion;
    }

    public final int component3() {
        return this.lineInRegion;
    }

    public final int component4() {
        return this.byteInLine;
    }

    public final int component5() {
        return this.byteInWord;
    }

    @NotNull
    public final TextRange component6() {
        return this.hexRange;
    }

    @NotNull
    public final TextRange component7() {
        return this.asciiRange;
    }

    @NotNull
    public final ByteCoordinates copy(@NotNull Address address2, int byteInRegion, int lineInRegion, int byteInLine, int byteInWord, @NotNull TextRange hexRange, @NotNull TextRange asciiRange) {
        Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
        Intrinsics.checkNotNullParameter((Object)hexRange, (String)"hexRange");
        Intrinsics.checkNotNullParameter((Object)asciiRange, (String)"asciiRange");
        return new ByteCoordinates(address2, byteInRegion, lineInRegion, byteInLine, byteInWord, hexRange, asciiRange);
    }

    public static /* synthetic */ ByteCoordinates copy$default(ByteCoordinates byteCoordinates, Address address2, int n, int n2, int n3, int n4, TextRange textRange2, TextRange textRange3, int n5, Object object) {
        if ((n5 & 1) != 0) {
            address2 = byteCoordinates.address;
        }
        if ((n5 & 2) != 0) {
            n = byteCoordinates.byteInRegion;
        }
        if ((n5 & 4) != 0) {
            n2 = byteCoordinates.lineInRegion;
        }
        if ((n5 & 8) != 0) {
            n3 = byteCoordinates.byteInLine;
        }
        if ((n5 & 0x10) != 0) {
            n4 = byteCoordinates.byteInWord;
        }
        if ((n5 & 0x20) != 0) {
            textRange2 = byteCoordinates.hexRange;
        }
        if ((n5 & 0x40) != 0) {
            textRange3 = byteCoordinates.asciiRange;
        }
        return byteCoordinates.copy(address2, n, n2, n3, n4, textRange2, textRange3);
    }

    @NotNull
    public String toString() {
        return "ByteCoordinates(address=" + this.address + ", byteInRegion=" + this.byteInRegion + ", lineInRegion=" + this.lineInRegion + ", byteInLine=" + this.byteInLine + ", byteInWord=" + this.byteInWord + ", hexRange=" + this.hexRange + ", asciiRange=" + this.asciiRange + ")";
    }

    public int hashCode() {
        int result2 = this.address.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.byteInRegion);
        result2 = result2 * 31 + Integer.hashCode(this.lineInRegion);
        result2 = result2 * 31 + Integer.hashCode(this.byteInLine);
        result2 = result2 * 31 + Integer.hashCode(this.byteInWord);
        result2 = result2 * 31 + this.hexRange.hashCode();
        result2 = result2 * 31 + this.asciiRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ByteCoordinates)) {
            return false;
        }
        ByteCoordinates byteCoordinates = (ByteCoordinates)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)byteCoordinates.address)) {
            return false;
        }
        if (this.byteInRegion != byteCoordinates.byteInRegion) {
            return false;
        }
        if (this.lineInRegion != byteCoordinates.lineInRegion) {
            return false;
        }
        if (this.byteInLine != byteCoordinates.byteInLine) {
            return false;
        }
        if (this.byteInWord != byteCoordinates.byteInWord) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hexRange, (Object)byteCoordinates.hexRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.asciiRange, (Object)byteCoordinates.asciiRange);
    }
}

