/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "", "()V", "blockSize", "", "getBlockSize", "()I", "createDataPlaceholder", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "holeRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "fromMemoryHunkList", "", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteData;", "memoryHunks", "Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "readOnlyReason", "", "ByteData", "ByteDataPlaceholder", "SingleByteDataEntry", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nAbstractHexdumpDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractHexdumpDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1549#2:57\n1620#2,3:58\n*S KotlinDebug\n*F\n+ 1 AbstractHexdumpDataProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider\n*L\n47#1:57\n47#1:58,3\n*E\n"})
public abstract class AbstractHexdumpDataProvider
implements CidrMemoryData.DataProvider<Byte> {
    @Override
    @NotNull
    public CidrMemoryData.DataPlaceholder<Byte> createDataPlaceholder(@NotNull Address address2, @NotNull AddressRange holeRange) {
        Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
        Intrinsics.checkNotNullParameter((Object)holeRange, (String)"holeRange");
        AddressRange blockRange = AddressUtil.toAlignedBlockRange(address2, this.getBlockSize()).intersectWith(holeRange);
        return new ByteDataPlaceholder(address2, blockRange, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ByteData> fromMemoryHunkList(@NotNull List<LLMemoryHunk> memoryHunks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(memoryHunks, (String)"memoryHunks");
        Iterable $this$map$iv = memoryHunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LLMemoryHunk lLMemoryHunk = (LLMemoryHunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ByteData((LLMemoryHunk)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String readOnlyReason() {
        Object[] objectArray = new Object[]{"memory"};
        return CidrDebuggerBundle.message("debug.memory.view.modify.not.supported", objectArray);
    }

    public abstract int getBlockSize();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nB#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteData;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "", "memoryHunk", "Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;)V", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "bytes", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;)V", "offset", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;I)V", "getBytes", "()Ljava/util/List;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/lang/Iterable;", "getOffset", "()I", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "subRangeImpl", "subRange", "intellij.cidr.debugger"})
    public static final class ByteData
    implements CidrMemoryData.DataBlock<Byte> {
        @NotNull
        private final AddressRange range;
        @NotNull
        private final List<Byte> bytes;
        private final int offset;
        @NotNull
        private final Iterable<CidrMemoryData.DataEntry<Byte>> entries;

        public ByteData(@NotNull AddressRange range, @NotNull List<Byte> bytes, int offset) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
            this.range = range;
            this.bytes = bytes;
            this.offset = offset;
            if (!((int)this.getRange().getSize() <= this.bytes.size() - this.offset)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.entries = SequencesKt.asIterable((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)this.getRange()), (Function2)((Function2)new Function2<Integer, Address, SingleByteDataEntry<Byte>>(this){
                final /* synthetic */ ByteData this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final SingleByteDataEntry<Byte> invoke(int i, @NotNull Address address2) {
                    Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
                    return new SingleByteDataEntry<Byte>(address2, this.this$0.getBytes().get(this.this$0.getOffset() + i));
                }
            })));
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @NotNull
        public final List<Byte> getBytes() {
            return this.bytes;
        }

        public final int getOffset() {
            return this.offset;
        }

        public ByteData(@NotNull LLMemoryHunk memoryHunk) {
            Intrinsics.checkNotNullParameter((Object)memoryHunk, (String)"memoryHunk");
            this(memoryHunk.getRange(), memoryHunk.getBytes());
        }

        public ByteData(@NotNull AddressRange range, @NotNull List<Byte> bytes) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
            this(range, bytes, 0);
        }

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<Byte>> getEntries() {
            return this.entries;
        }

        @Override
        @NotNull
        public CidrMemoryData.DataBlock<Byte> subRangeImpl(@NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            return new ByteData(subRange, this.bytes, this.offset + (int)subRange.getStart().minus(this.getRange().getStart()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteDataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "requestRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRequestRange", "subRangeImpl", "subRange", "intellij.cidr.debugger"})
    private static final class ByteDataPlaceholder
    implements CidrMemoryData.DataPlaceholder<Byte> {
        @NotNull
        private final Address address;
        @NotNull
        private final AddressRange range;
        @NotNull
        private final AddressRange requestRange;

        public ByteDataPlaceholder(@NotNull Address address2, @NotNull AddressRange range, @NotNull AddressRange requestRange) {
            Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)requestRange, (String)"requestRange");
            this.address = address2;
            this.range = range;
            this.requestRange = requestRange;
        }

        public /* synthetic */ ByteDataPlaceholder(Address address2, AddressRange addressRange, AddressRange addressRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                addressRange2 = addressRange;
            }
            this(address2, addressRange, addressRange2);
        }

        @Override
        @NotNull
        public Address getAddress() {
            return this.address;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @Override
        @NotNull
        public AddressRange getRequestRange() {
            return this.requestRange;
        }

        @Override
        @NotNull
        public ByteDataPlaceholder subRangeImpl(@NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            return new ByteDataPlaceholder(this.getAddress(), subRange, this.getRequestRange());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$SingleByteDataEntry;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "value", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Object;)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "intellij.cidr.debugger"})
    private static class SingleByteDataEntry<T>
    implements CidrMemoryData.DataEntry<T> {
        @NotNull
        private final Address address;
        private final T value;

        public SingleByteDataEntry(@NotNull Address address2, T value) {
            Intrinsics.checkNotNullParameter((Object)address2, (String)"address");
            this.address = address2;
            this.value = value;
        }

        @Override
        @NotNull
        public Address getAddress() {
            return this.address;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return AddressUtil.addressToRange(this.getAddress(), 1L);
        }
    }
}

