/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocGutterActionGroupKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/ShowAddressesToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "Companion", "intellij.cidr.debugger"})
public final class ShowAddressesToggleAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SHOW_ADDRESSES_KEY_NAME = "cidr.debugger.show.addresses.key";

    public ShowAddressesToggleAction() {
        super(CidrDebuggerBundle.message("action.show.addresses.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        CidrMemoryDoc memoryDoc = CidrMemoryDocGutterActionGroupKt.access$getMemoryDoc(e);
        e.getPresentation().setEnabledAndVisible(memoryDoc != null);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = CidrMemoryDocGutterActionGroupKt.access$getEditor(e);
        return editor != null && (editor = editor.getSettings()) != null ? editor.isLineNumbersShown() : true;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = CidrMemoryDocGutterActionGroupKt.access$getEditor(e);
        if (editor != null && (editor = editor.getSettings()) != null) {
            editor.setLineNumbersShown(state);
        }
        ShowAddressesToggleAction.Companion.storeShowAddresses(state);
    }

    @JvmStatic
    public static final void configureAddresses(@NotNull Editor editor) {
        Companion.configureAddresses(editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/ShowAddressesToggleAction$Companion;", "", "()V", "SHOW_ADDRESSES_KEY_NAME", "", "configureAddresses", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "storeShowAddresses", "doShow", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void configureAddresses(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            boolean showAddresses = PropertiesComponent.getInstance().getBoolean(ShowAddressesToggleAction.SHOW_ADDRESSES_KEY_NAME, true);
            editor.getSettings().setLineNumbersShown(showAddresses);
        }

        private final void storeShowAddresses(boolean doShow) {
            PropertiesComponent.getInstance().setValue(ShowAddressesToggleAction.SHOW_ADDRESSES_KEY_NAME, doShow, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

