/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "Lcom/intellij/openapi/vfs/NonPhysicalFileSystem;", "()V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "files", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFile;", "createMemoryViewFile", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "name", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "deleteFile", "", "requestor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileByPath", "path", "getProtocol", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "intellij.cidr.debugger"})
public final class MemoryViewVirtualFileSystem
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, MemoryViewFile> files;
    @NotNull
    private final AtomicInteger counter;
    @NotNull
    private static final String PROTOCOL = "cidr-memory-view";

    public MemoryViewVirtualFileSystem() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        busConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file instanceof MemoryViewFile) {
                    UIUtil.invokeLaterIfNeeded(() -> 1.fileOpened$lambda$0(source, file));
                }
            }

            private static final void fileOpened$lambda$0(FileEditorManager $source, VirtualFile $file) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
                    Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                    FileEditor fileEditor = $source.getSelectedEditor($file);
                    TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                    if (textEditor == null) {
                        return;
                    }
                    TextEditor editor = textEditor;
                    GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)editor.getUserData(GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY));
                    if (gotoAddressPanel == null) {
                        return;
                    }
                    GotoAddressPanel panel2 = gotoAddressPanel;
                    $source.addTopComponent((FileEditor)editor, (JComponent)((Object)panel2));
                    EditorGutter editorGutter = editor.getEditor().getGutter();
                    EditorGutterComponentEx editorGutterComponentEx = editorGutter instanceof EditorGutterComponentEx ? (EditorGutterComponentEx)editorGutter : null;
                    if (editorGutterComponentEx == null) break block2;
                    editorGutterComponentEx.revalidate();
                }
            }
        });
        this.files = new ConcurrentHashMap();
        this.counter = new AtomicInteger(0);
    }

    @NotNull
    public final MemoryViewFile createMemoryViewFile(@NotNull CidrMemoryDoc<?> memoryDoc, @NotNull String name, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        int id = this.counter.getAndIncrement();
        MemoryViewFile file = new MemoryViewFile(memoryDoc, name, fileType, id);
        ((Map)this.files).put(file.getPath(), file);
        return file;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)this.files.get(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    protected void deleteFile(@Nullable Object requestor, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.files.remove(file.getPath());
    }

    @JvmStatic
    @NotNull
    public static final MemoryViewVirtualFileSystem getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem$Companion;", "", "()V", "PROTOCOL", "", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem;", "intellij.cidr.debugger"})
    @SourceDebugExtension(value={"SMAP\nMemoryViewVirtualFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryViewVirtualFileSystem.kt\ncom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n40#2,3:64\n*S KotlinDebug\n*F\n+ 1 MemoryViewVirtualFileSystem.kt\ncom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem$Companion\n*L\n25#1:64,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MemoryViewVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<VirtualFileManager> serviceClass$iv = VirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)object).getFileSystem(MemoryViewVirtualFileSystem.PROTOCOL);
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.memory.MemoryViewVirtualFileSystem");
            return (MemoryViewVirtualFileSystem)virtualFileSystem;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

