/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocOptions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpOptions;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDocOptions;", "()V", "blockSize", "", "getBlockSize", "()I", "configure", "", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "getOptionActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "initColumns", "document", "Lcom/intellij/openapi/editor/Document;", "CidrHexdumpColumnsCountAction", "Companion", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrHexdumpOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrHexdumpOptions.kt\ncom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class CidrHexdumpOptions
implements CidrMemoryDocOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int blockSize;
    @NotNull
    private static final String COLUMNS_KEY_NAME = "cidr.debugger.hexdump.columns.count.key";
    @NotNull
    private static final Key<Integer> COLUMNS_KEY = new Key("cidr.debugger.hexdump.columns.count.key");
    private static final int defaultColumnsCount = 16;

    /*
     * WARNING - void declaration
     */
    public CidrHexdumpOptions() {
        void it;
        Integer n = Registry.intValue((String)"cidr.debugger.memory.hex.blockSize");
        int n2 = ((Number)n).intValue();
        CidrHexdumpOptions cidrHexdumpOptions = this;
        boolean bl = false;
        boolean bl2 = it > 0 && (it & it - true) == 0;
        Integer n3 = bl2 ? n : null;
        cidrHexdumpOptions.blockSize = n3 != null ? n3 : 4096;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void configure(@NotNull CidrMemoryDoc<?> memoryDoc) {
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        memoryDoc.getDocAccess().edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<? extends Object>, Unit>(this){
            final /* synthetic */ CidrHexdumpOptions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$edit) {
                Intrinsics.checkNotNullParameter($this$edit, (String)"$this$edit");
                CidrHexdumpOptions.access$initColumns(this.this$0, (Document)$this$edit.getDocument());
            }
        });
    }

    private final void initColumns(Document document2) {
        Integer n = CidrHexdumpOptions.Companion.getLastUsedColumns();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it <= this.blockSize ? n : null;
        int columnsCount = n2 != null ? n2 : this.blockSize;
        CidrHexdumpOptions.Companion.setColumnsCount(document2, columnsCount);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnAction> getOptionActions(@NotNull CidrMemoryDoc<?> memoryDoc) {
        void $this$getOptionActions_u24lambda_u242;
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        ArrayList<CidrHexdumpColumnsCountAction> actions = new ArrayList<CidrHexdumpColumnsCountAction>();
        Object[] objectArray = new Integer[]{1, 2, 4, 8, 16, 32, 64};
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            int columnsCount = objectArray2[i];
            if (columnsCount > this.blockSize) continue;
            actions.add(new CidrHexdumpColumnsCountAction(memoryDoc, columnsCount));
        }
        objectArray2 = new DefaultActionGroup[1];
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup(CidrDebuggerBundle.message("debug.hexdump.columns.option.name", new Object[0]), (List)actions);
        int n2 = 0;
        Object[] objectArray3 = objectArray2;
        boolean bl = false;
        $this$getOptionActions_u24lambda_u242.setPopup(true);
        Unit unit = Unit.INSTANCE;
        objectArray3[n2] = defaultActionGroup;
        return CollectionsKt.arrayListOf((Object[])objectArray2);
    }

    public static final /* synthetic */ void access$initColumns(CidrHexdumpOptions $this, Document document2) {
        $this.initColumns(document2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpOptions$CidrHexdumpColumnsCountAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "columnsCount", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;I)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.cidr.debugger"})
    public static final class CidrHexdumpColumnsCountAction
    extends DumbAwareToggleAction {
        @NotNull
        private final CidrMemoryDoc<?> memoryDoc;
        private final int columnsCount;

        public CidrHexdumpColumnsCountAction(@NotNull CidrMemoryDoc<?> memoryDoc, int columnsCount) {
            Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
            super(String.valueOf(columnsCount));
            this.memoryDoc = memoryDoc;
            this.columnsCount = columnsCount;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int docColumnCount2 = ((Number)this.memoryDoc.getDocAccess().read(isSelected.docColumnCount.1.INSTANCE)).intValue();
            return docColumnCount2 == this.columnsCount;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (state) {
                CidrDebuggerUsagesCollector.INSTANCE.logHexdumpColumnsChanged(e.getProject(), this.columnsCount);
                this.memoryDoc.getDocAccess().edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<? extends Object>, Unit>(this){
                    final /* synthetic */ CidrHexdumpColumnsCountAction this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$edit) {
                        Intrinsics.checkNotNullParameter($this$edit, (String)"$this$edit");
                        com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions$Companion.access$setColumnsCount(CidrHexdumpOptions.Companion, (Document)$this$edit.getDocument(), CidrHexdumpColumnsCountAction.access$getColumnsCount$p(this.this$0));
                        com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions$Companion.access$saveLastUsedColumns(CidrHexdumpOptions.Companion, CidrHexdumpColumnsCountAction.access$getColumnsCount$p(this.this$0));
                    }
                });
                CidrMemoryDoc.refresh$default(this.memoryDoc, null, 1, null);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public static final /* synthetic */ int access$getColumnsCount$p(CidrHexdumpColumnsCountAction $this) {
            return $this.columnsCount;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpOptions$Companion;", "", "()V", "COLUMNS_KEY", "Lcom/intellij/openapi/util/Key;", "", "COLUMNS_KEY_NAME", "", "defaultColumnsCount", "getColumnsCount", "document", "Lcom/intellij/openapi/editor/Document;", "getLastUsedColumns", "saveLastUsedColumns", "", "columnsCount", "setColumnsCount", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public final int getColumnsCount(@NotNull Document document2) {
            Integer documentColumns;
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Integer n = documentColumns = (Integer)document2.getUserData(COLUMNS_KEY);
            return n != null ? n.intValue() : this.getLastUsedColumns();
        }

        private final void setColumnsCount(Document document2, int columnsCount) {
            document2.putUserData(COLUMNS_KEY, (Object)columnsCount);
        }

        private final int getLastUsedColumns() {
            return PropertiesComponent.getInstance().getInt(CidrHexdumpOptions.COLUMNS_KEY_NAME, 16);
        }

        private final void saveLastUsedColumns(int columnsCount) {
            PropertiesComponent.getInstance().setValue(CidrHexdumpOptions.COLUMNS_KEY_NAME, columnsCount, 16);
        }

        public static final /* synthetic */ void access$saveLastUsedColumns(Companion $this, int columnsCount) {
            $this.saveLastUsedColumns(columnsCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

