/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueRendererFactory {
    public static final ExtensionPointName<ValueRendererFactory> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.valueRendererFactory");

    @Nullable
    public ValueRenderer createRenderer(@NotNull FactoryContext var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public static ValueRenderer createRenderer(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue physicalValue) throws ExecutionException, DebuggerCommandException {
        ValueRendererFactory[] extensions;
        LLValue value;
        if (evaluationContext == null) {
            ValueRendererFactory.$$$reportNull$$$0(0);
        }
        if (physicalValue == null) {
            ValueRendererFactory.$$$reportNull$$$0(1);
        }
        if (!(value = physicalValue.getVar()).isValid()) {
            return new ValueRenderer(physicalValue);
        }
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        if (settings.isRenderersEnabled() && (extensions = (ValueRendererFactory[])EP_NAME.getExtensions()).length > 0) {
            LLValueData valueData = physicalValue.getVarData(evaluationContext);
            FactoryContext factoryContext = new FactoryContext(settings, evaluationContext, physicalValue, value, valueData);
            for (ValueRendererFactory factory : extensions) {
                ValueRenderer result2 = factory.createRenderer(factoryContext);
                if (result2 == null) continue;
                ValueRenderer valueRenderer = result2;
                if (valueRenderer == null) {
                    ValueRendererFactory.$$$reportNull$$$0(2);
                }
                return valueRenderer;
            }
        }
        return new ValueRenderer(physicalValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class FactoryContext {
        @NotNull
        private final CidrDebuggerSettings mySettings;
        @NotNull
        private final EvaluationContext myEvaluationContext;
        @NotNull
        private final CidrPhysicalValue myPhysicalValue;
        @NotNull
        private final LLValue myLLValue;
        @NotNull
        private final LLValueData myLLValueData;

        public FactoryContext(@NotNull CidrDebuggerSettings settings, @NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue physicalValue, @NotNull LLValue LLValue2, @NotNull LLValueData LLValueData2) {
            if (settings == null) {
                FactoryContext.$$$reportNull$$$0(0);
            }
            if (evaluationContext == null) {
                FactoryContext.$$$reportNull$$$0(1);
            }
            if (physicalValue == null) {
                FactoryContext.$$$reportNull$$$0(2);
            }
            if (LLValue2 == null) {
                FactoryContext.$$$reportNull$$$0(3);
            }
            if (LLValueData2 == null) {
                FactoryContext.$$$reportNull$$$0(4);
            }
            this.mySettings = settings;
            this.myEvaluationContext = evaluationContext;
            this.myPhysicalValue = physicalValue;
            this.myLLValue = LLValue2;
            this.myLLValueData = LLValueData2;
        }

        @NotNull
        public CidrDebuggerSettings getSettings() {
            CidrDebuggerSettings cidrDebuggerSettings = this.mySettings;
            if (cidrDebuggerSettings == null) {
                FactoryContext.$$$reportNull$$$0(5);
            }
            return cidrDebuggerSettings;
        }

        @NotNull
        public EvaluationContext getEvaluationContext() {
            EvaluationContext evaluationContext = this.myEvaluationContext;
            if (evaluationContext == null) {
                FactoryContext.$$$reportNull$$$0(6);
            }
            return evaluationContext;
        }

        @NotNull
        public CidrPhysicalValue getPhysicalValue() {
            CidrPhysicalValue cidrPhysicalValue = this.myPhysicalValue;
            if (cidrPhysicalValue == null) {
                FactoryContext.$$$reportNull$$$0(7);
            }
            return cidrPhysicalValue;
        }

        @NotNull
        public LLValue getLLValue() {
            LLValue lLValue = this.myLLValue;
            if (lLValue == null) {
                FactoryContext.$$$reportNull$$$0(8);
            }
            return lLValue;
        }

        @NotNull
        public LLValueData getLLValueData() {
            LLValueData lLValueData = this.myLLValueData;
            if (lLValueData == null) {
                FactoryContext.$$$reportNull$$$0(9);
            }
            return lLValueData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "physicalValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "LLValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "LLValueData";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory$FactoryContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory$FactoryContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationContext";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhysicalValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLLValue";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLLValueData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

