/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.actions.CidrDebuggerRegisterSetsGroupKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLRegisterSet;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrInfoMessageValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegisterValue;
import icons.CidrDebuggerIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrRegistersValue
extends XNamedValue {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final CidrStackFrame myFrame;

    public CidrRegistersValue(@NotNull CidrDebugProcess process, @NotNull CidrStackFrame frame) {
        if (process == null) {
            CidrRegistersValue.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            CidrRegistersValue.$$$reportNull$$$0(1);
        }
        super(CidrDebuggerBundle.message("debug.registers.value", new Object[0]));
        this.myProcess = process;
        this.myFrame = frame;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            CidrRegistersValue.$$$reportNull$$$0(2);
        }
        if (place == null) {
            CidrRegistersValue.$$$reportNull$$$0(3);
        }
        node.setPresentation(CidrDebuggerIcons.Registers, new XValuePresentation(){

            @NotNull
            public String getSeparator() {
                return "";
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$1", "renderValue"));
            }
        }, true);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrRegistersValue.$$$reportNull$$$0(4);
        }
        this.myProcess.postCommand(driver -> {
            Pair<Boolean, LinkedHashSet<String>> registers = this.getRegistersToShow(driver);
            boolean allDisabled = (Boolean)registers.first;
            XValueChildrenList list = new XValueChildrenList();
            if (allDisabled) {
                list.add((XNamedValue)new CidrInfoMessageValue(CidrDebuggerBundle.message("debug.no.register.set.enabled", new Object[0])));
            } else {
                try {
                    LinkedHashSet registerNames = (LinkedHashSet)registers.second;
                    List<LLValue> registerValues = driver.getRegisters(this.myFrame.getThread(), this.myFrame.getFrame(), registerNames);
                    HashMap<String, LLValue> regValueByName = new HashMap<String, LLValue>();
                    for (LLValue register : registerValues) {
                        regValueByName.put(register.getName(), register);
                    }
                    for (String registerName : registerNames) {
                        LLValue regValue = (LLValue)((Object)((Object)regValueByName.get(registerName)));
                        if (regValue == null) continue;
                        list.add((XNamedValue)new CidrRegisterValue(this.myProcess, this.myFrame, regValue));
                    }
                }
                catch (DebuggerCommandException e) {
                    list.add((XNamedValue)new CidrErrorValue(e.getMessage()));
                }
            }
            node.addChildren(list, true);
        });
    }

    @NotNull
    private Pair<Boolean, LinkedHashSet<String>> getRegistersToShow(@NotNull DebuggerDriver driver) {
        List<LLRegisterSet> registerSets;
        String arch;
        if (driver == null) {
            CidrRegistersValue.$$$reportNull$$$0(5);
        }
        try {
            arch = driver.getArchitecture();
            registerSets = driver.getRegisterSets();
        }
        catch (ExecutionException | DebuggerCommandException e) {
            arch = null;
            registerSets = Collections.emptyList();
        }
        if (arch == null || registerSets.isEmpty()) {
            Pair pair = Pair.create((Object)false, new LinkedHashSet());
            if (pair == null) {
                CidrRegistersValue.$$$reportNull$$$0(6);
            }
            return pair;
        }
        String driverName = this.myProcess.getDriverName();
        List<LLRegisterSet> enabledRegSets = CidrDebuggerRegisterSetsGroupKt.getEnabledRegisterSets(registerSets, arch, driverName);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (LLRegisterSet regSet : enabledRegSets) {
            result2.addAll(regSet.getRegisters());
        }
        Pair pair = Pair.create((Object)enabledRegSets.isEmpty(), result2);
        if (pair == null) {
            CidrRegistersValue.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistersToShow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRegistersToShow";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

