/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "()V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "createBreakpointProperties", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getShortText", "", "Companion", "intellij.cidr.debugger"})
public final class CidrAddressBreakpointType
extends XLineBreakpointType<XBreakpointProperties<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CidrAddressBreakpointType() {
        super("com.jetbrains.cidr.execution.debugger.AddressBreakpointType", CidrDebuggerBundle.message("debug.address.breakpoints", new Object[0]));
    }

    @NotNull
    public String getShortText(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Address address2 = Companion.breakpointToAddress(breakpoint);
        if (address2 == null) {
            String string = CidrDebuggerBundle.message("debug.address.breakpoint.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Address address3 = address2;
        Object[] objectArray = new Object[]{address3};
        String string = CidrDebuggerBundle.message("debug.address.breakpoint", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession currentDebugSession = xDebugSession;
        XDebugProcess xDebugProcess = currentDebugSession.getDebugProcess();
        CidrDebugProcess cidrDebugProcess = xDebugProcess instanceof CidrDebugProcess ? (CidrDebugProcess)xDebugProcess : null;
        if (cidrDebugProcess == null) {
            return false;
        }
        CidrDebugProcess debugProcess = cidrDebugProcess;
        return file.getFileType() == DisasmFileType.INSTANCE && debugProcess.fileToMemoryDoc(file) != null;
    }

    @Nullable
    public XBreakpointProperties<?> createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CidrDebuggerLanguageSupportManager.Companion.getInstance().createEditor((XBreakpoint)breakpoint);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointType$Companion;", "", "()V", "breakpointToAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Address breakpointToAddress(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(breakpoint.getFileUrl());
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            Object object = file instanceof MemoryViewFile ? (MemoryViewFile)file : null;
            if (object == null || (object = object.getMemoryDoc()) == null) {
                return null;
            }
            MemoryViewFile memoryDoc = object;
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.create((VirtualFile)file, (int)breakpoint.getLine());
            Intrinsics.checkNotNullExpressionValue((Object)xSourcePositionImpl, (String)"create(...)");
            return ((CidrMemoryDoc)((Object)memoryDoc)).getAddress((XSourcePosition)xSourcePositionImpl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

