/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.cuda;

import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003JY\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u00020\u0006H\u0016J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\b\u0010&\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/cuda/CudaLLThread;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "kernel", "", "grid", "blockIdx", "", "threadIdx", "device", "sm", "warp", "lane", "(IILjava/lang/String;Ljava/lang/String;IIII)V", "getBlockIdx", "()Ljava/lang/String;", "getDevice", "()I", "getGrid", "getKernel", "getLane", "getSm", "getThreadIdx", "getWarp", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "getDisplayName", "hashCode", "toString", "intellij.cidr.debugger.backend"})
public final class CudaLLThread
extends LLThread {
    private final int kernel;
    private final int grid;
    @NotNull
    private final String blockIdx;
    @NotNull
    private final String threadIdx;
    private final int device;
    private final int sm;
    private final int warp;
    private final int lane;

    public CudaLLThread(int kernel, int grid, @NotNull String blockIdx, @NotNull String threadIdx, int device, int sm, int warp, int lane) {
        Intrinsics.checkNotNullParameter((Object)blockIdx, (String)"blockIdx");
        Intrinsics.checkNotNullParameter((Object)threadIdx, (String)"threadIdx");
        super(-1L, "Stopped", null, null, null);
        this.kernel = kernel;
        this.grid = grid;
        this.blockIdx = blockIdx;
        this.threadIdx = threadIdx;
        this.device = device;
        this.sm = sm;
        this.warp = warp;
        this.lane = lane;
    }

    public final int getKernel() {
        return this.kernel;
    }

    public final int getGrid() {
        return this.grid;
    }

    @NotNull
    public final String getBlockIdx() {
        return this.blockIdx;
    }

    @NotNull
    public final String getThreadIdx() {
        return this.threadIdx;
    }

    public final int getDevice() {
        return this.device;
    }

    public final int getSm() {
        return this.sm;
    }

    public final int getWarp() {
        return this.warp;
    }

    public final int getLane() {
        return this.lane;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "CUDA Thread " + this.threadIdx + " Block " + this.blockIdx;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDisplayName();
    }

    public final int component1() {
        return this.kernel;
    }

    public final int component2() {
        return this.grid;
    }

    @NotNull
    public final String component3() {
        return this.blockIdx;
    }

    @NotNull
    public final String component4() {
        return this.threadIdx;
    }

    public final int component5() {
        return this.device;
    }

    public final int component6() {
        return this.sm;
    }

    public final int component7() {
        return this.warp;
    }

    public final int component8() {
        return this.lane;
    }

    @NotNull
    public final CudaLLThread copy(int kernel, int grid, @NotNull String blockIdx, @NotNull String threadIdx, int device, int sm, int warp, int lane) {
        Intrinsics.checkNotNullParameter((Object)blockIdx, (String)"blockIdx");
        Intrinsics.checkNotNullParameter((Object)threadIdx, (String)"threadIdx");
        return new CudaLLThread(kernel, grid, blockIdx, threadIdx, device, sm, warp, lane);
    }

    public static /* synthetic */ CudaLLThread copy$default(CudaLLThread cudaLLThread, int n, int n2, String string, String string2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = cudaLLThread.kernel;
        }
        if ((n7 & 2) != 0) {
            n2 = cudaLLThread.grid;
        }
        if ((n7 & 4) != 0) {
            string = cudaLLThread.blockIdx;
        }
        if ((n7 & 8) != 0) {
            string2 = cudaLLThread.threadIdx;
        }
        if ((n7 & 0x10) != 0) {
            n3 = cudaLLThread.device;
        }
        if ((n7 & 0x20) != 0) {
            n4 = cudaLLThread.sm;
        }
        if ((n7 & 0x40) != 0) {
            n5 = cudaLLThread.warp;
        }
        if ((n7 & 0x80) != 0) {
            n6 = cudaLLThread.lane;
        }
        return cudaLLThread.copy(n, n2, string, string2, n3, n4, n5, n6);
    }

    @Override
    public int hashCode() {
        int result2 = Integer.hashCode(this.kernel);
        result2 = result2 * 31 + Integer.hashCode(this.grid);
        result2 = result2 * 31 + this.blockIdx.hashCode();
        result2 = result2 * 31 + this.threadIdx.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.device);
        result2 = result2 * 31 + Integer.hashCode(this.sm);
        result2 = result2 * 31 + Integer.hashCode(this.warp);
        result2 = result2 * 31 + Integer.hashCode(this.lane);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CudaLLThread)) {
            return false;
        }
        CudaLLThread cudaLLThread = (CudaLLThread)other;
        if (this.kernel != cudaLLThread.kernel) {
            return false;
        }
        if (this.grid != cudaLLThread.grid) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.blockIdx, (Object)cudaLLThread.blockIdx)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.threadIdx, (Object)cudaLLThread.threadIdx)) {
            return false;
        }
        if (this.device != cudaLLThread.device) {
            return false;
        }
        if (this.sm != cudaLLThread.sm) {
            return false;
        }
        if (this.warp != cudaLLThread.warp) {
            return false;
        }
        return this.lane == cudaLLThread.lane;
    }
}

