/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class LLThread {
    private final long myId;
    @Nullable
    private final String myState;
    @Nullable
    private final String myWorkQueue;
    @Nullable
    private final String myName;
    @Nullable
    private final String myTid;
    @Nullable
    private final String myInferiorId;
    private final boolean myFrozen;

    public LLThread(long id, @Nullable String state, @Nullable String workQueue, @Nullable String name, @Nullable String tid) {
        this(id, state, workQueue, name, tid, null, false);
    }

    public LLThread(long id, @Nullable String state, @Nullable String workQueue, @Nullable String name, @Nullable String tid, @Nullable String inferiorId, boolean frozen) {
        this.myId = id;
        this.myState = StringUtil.nullize((String)state);
        this.myWorkQueue = StringUtil.nullize((String)workQueue);
        this.myName = StringUtil.nullize((String)name);
        this.myTid = StringUtil.nullize((String)tid);
        this.myInferiorId = StringUtil.nullize((String)inferiorId);
        this.myFrozen = frozen;
    }

    public long getId() {
        return this.myId;
    }

    @Nullable
    public String getState() {
        return this.myState;
    }

    @Nullable
    public String getWorkQueue() {
        return this.myWorkQueue;
    }

    @Nullable
    public String getTid() {
        return this.myTid;
    }

    public boolean isFrozen() {
        return this.myFrozen;
    }

    @NlsSafe
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        builder.append("Thread-");
        if (this.myInferiorId != null) {
            builder.append(this.myInferiorId).append(".");
        }
        builder.append(this.myId);
        if (this.myWorkQueue != null) {
            builder.append("-<").append(this.myWorkQueue).append(">");
        }
        if (this.myName != null) {
            builder.append("-[").append(this.myName).append("]");
        }
        if (this.myTid != null) {
            builder.append(" (").append(this.myTid).append(")");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLThread thread = (LLThread)o;
        if (this.myId != thread.myId) {
            return false;
        }
        if (!Objects.equals(this.myState, thread.myState)) {
            return false;
        }
        if (!Objects.equals(this.myWorkQueue, thread.myWorkQueue)) {
            return false;
        }
        if (!Objects.equals(this.myTid, thread.myTid)) {
            return false;
        }
        return this.myFrozen == thread.myFrozen;
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.myId);
        result2 = 31 * result2 + (this.myState != null ? this.myState.hashCode() : 0);
        result2 = 31 * result2 + (this.myWorkQueue != null ? this.myWorkQueue.hashCode() : 0);
        result2 = 31 * result2 + (this.myTid != null ? this.myTid.hashCode() : 0);
        result2 = 31 * result2 + (this.myFrozen ? 1 : 0);
        return result2;
    }
}

