/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.GdbMiVariablesView;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/GdbMiVariablesView;", "Lcom/intellij/xdebugger/impl/frame/XVariablesView;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/xdebugger/impl/XDebugSessionImpl;)V", "getProcess", "()Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "getSession", "()Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "doCreateNewRootNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "intellij.cidr.debugger"})
public final class GdbMiVariablesView
extends XVariablesView {
    @NotNull
    private final CidrDebugProcess process;
    @NotNull
    private final XDebugSessionImpl session;

    public GdbMiVariablesView(@NotNull CidrDebugProcess process, @NotNull XDebugSessionImpl session) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
        this.process = process;
        this.session = session;
        Disposer.register((Disposable)this.process.getUiDisposable(), (Disposable)((Disposable)this));
    }

    @NotNull
    public final CidrDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final XDebugSessionImpl getSession() {
        return this.session;
    }

    @NotNull
    protected XValueContainerNode<?> doCreateNewRootNode(@Nullable XStackFrame frame) {
        if (!(frame instanceof CidrStackFrame)) {
            XValueContainerNode xValueContainerNode = super.doCreateNewRootNode(frame);
            Intrinsics.checkNotNullExpressionValue((Object)xValueContainerNode, (String)"doCreateNewRootNode(...)");
            return xValueContainerNode;
        }
        XValueContainer valueContainer2 = new XValueContainer(this, frame){
            final /* synthetic */ GdbMiVariablesView this$0;
            final /* synthetic */ XStackFrame $frame;
            {
                this.this$0 = $receiver;
                this.$frame = $frame;
            }

            public void computeChildren(@NotNull XCompositeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.this$0.getProcess().postCommand(arg_0 -> doCreateNewRootNode.valueContainer.1.computeChildren$lambda$1(this.$frame, this.this$0, node, arg_0));
            }

            private static final void computeChildren$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }

            private static final void computeChildren$lambda$1(XStackFrame $frame, GdbMiVariablesView this$0, XCompositeNode $node, DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                DebuggerDriver.FrameVariables frameVariables = ((GDBDriver)driver).doGetFrameVariablesGdbMi(((CidrStackFrame)$frame).getThreadId(), ((CidrStackFrame)$frame).getFrameIndex());
                Intrinsics.checkNotNullExpressionValue((Object)frameVariables, (String)"doGetFrameVariablesGdbMi(...)");
                DebuggerDriver.FrameVariables gdbMiFrameVars = frameVariables;
                if (gdbMiFrameVars.isFiltered()) {
                    CidrValue.addLocalValues((Collection<LLValue>)gdbMiFrameVars.getVariables(), this$0.getProcess(), null, (CidrStackFrame)$frame, $node, true);
                } else {
                    this$0.getProcess().getTypesHelper((CidrStackFrame)$frame).filterLocalVariables(((CidrStackFrame)$frame).getSourcePosition(), gdbMiFrameVars.getVariables(), () -> ((XCompositeNode)$node).isObsolete()).whenComplete((arg_0, arg_1) -> doCreateNewRootNode.valueContainer.1.computeChildren$lambda$1$lambda$0((Function2)new Function2<List<LLValue>, Throwable, Unit>(this$0, $frame, $node){
                        final /* synthetic */ GdbMiVariablesView this$0;
                        final /* synthetic */ XStackFrame $frame;
                        final /* synthetic */ XCompositeNode $node;
                        {
                            this.this$0 = $receiver;
                            this.$frame = $frame;
                            this.$node = $node;
                            super(2);
                        }

                        public final void invoke(List<LLValue> filteredVars, Throwable throwable) {
                            CidrValue.addLocalValues((Collection<LLValue>)filteredVars, this.this$0.getProcess(), null, (CidrStackFrame)this.$frame, this.$node, true);
                        }
                    }, arg_0, arg_1));
                }
            }
        };
        XDebuggerTree xDebuggerTree = this.getTree();
        return (XValueContainerNode)new XValueContainerNode<XValueContainer>(valueContainer2, xDebuggerTree){};
    }
}

