/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemoryKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerDisasmDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrDisasmOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegionFactory;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpFileType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\bH\u0086\u0002R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModuleMemory;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/openapi/Disposable;)V", "disasmDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "getDisasmDoc", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "disasmDoc$delegate", "Lkotlin/Lazy;", "hexdumpDoc", "", "getHexdumpDoc", "hexdumpDoc$delegate", "contains", "", "memoryDoc", "Companion", "intellij.cidr.debugger"})
public final class CidrDebuggerModuleMemory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy disasmDoc$delegate;
    @NotNull
    private final Lazy hexdumpDoc$delegate;
    @JvmField
    @NotNull
    public static final Key<String> DISASM_ARCH;
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> MEMORY_DOCS_ENABLED;

    public CidrDebuggerModuleMemory(@NotNull CidrDebugProcess process, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.disasmDoc$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CidrMemoryDoc<LLInstruction>>(process, parentDisposable){
            final /* synthetic */ CidrDebugProcess $process;
            final /* synthetic */ Disposable $parentDisposable;
            {
                this.$process = $process;
                this.$parentDisposable = $parentDisposable;
                super(0);
            }

            @NotNull
            public final CidrMemoryDoc<LLInstruction> invoke() {
                Project project = this.$process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                XDebugSession session = this.$process.getSession();
                CidrMemoryData.DataProvider dataProvider = new CidrDebuggerDisasmDataProvider(this.$process);
                CidrMemoryDoc.DocRegionFactory docRegionFactory = CidrDisasmRegion.Companion;
                DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)disasmFileType), (String)"INSTANCE");
                FileType fileType = (FileType)disasmFileType;
                String string = session.getSessionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
                String string2 = CidrDebuggerBundle.message("debug.disasm.editorTabDescription", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                Intrinsics.checkNotNull((Object)session);
                CidrMemoryDoc<LLInstruction> cidrMemoryDoc = new CidrMemoryDoc<LLInstruction>(project2, this.$parentDisposable, dataProvider, docRegionFactory, fileType, string, string2, new CidrDisasmOptions(session));
                CidrDebugProcess cidrDebugProcess = this.$process;
                Disposable disposable = this.$parentDisposable;
                CidrMemoryDoc<LLInstruction> memoryDoc = cidrMemoryDoc;
                boolean bl = false;
                memoryDoc.getVirtualFile().putUserData(CidrDebugProcess.DEBUG_PROCESS_KEY, cidrDebugProcess);
                if (!CidrDebuggerModuleMemoryKt.skipMemoryDocsSubscription(session)) {
                    session.addSessionListener(new XDebugSessionListener(memoryDoc, project2, cidrDebugProcess){
                        final /* synthetic */ CidrMemoryDoc<LLInstruction> $memoryDoc;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ CidrDebugProcess $process;
                        {
                            this.$memoryDoc = $memoryDoc;
                            this.$project = $project;
                            this.$process = $process;
                        }

                        public void sessionResumed() {
                            CidrMemoryDoc.cleanupErrors$default(this.$memoryDoc, null, 1, null);
                            this.update();
                        }

                        public void sessionStopped() {
                            if (!this.$project.isDisposed()) {
                                FileEditorManager.getInstance((Project)this.$project).updateFilePresentation((VirtualFile)this.$memoryDoc.getVirtualFile());
                                this.update();
                            }
                        }

                        public void sessionPaused() {
                            this.initDisasmArch();
                            this.update();
                        }

                        private final void initDisasmArch() {
                            String arch = (String)CidrDebuggerModuleMemory.DISASM_ARCH.get((UserDataHolder)this.$memoryDoc.getVirtualFile());
                            if (arch == null) {
                                this.$process.postCommand(arg_0 -> disasmDoc.1.1.initDisasmArch$lambda$0(this.$memoryDoc, arg_0));
                            }
                        }

                        public void stackFrameChanged() {
                            this.update();
                        }

                        public void settingsChanged() {
                            this.update();
                        }

                        private final void update() {
                            EditorNotifications.getInstance((Project)this.$project).updateNotifications((VirtualFile)this.$memoryDoc.getVirtualFile());
                        }

                        private static final Unit initDisasmArch$lambda$0(CidrMemoryDoc $memoryDoc, DebuggerDriver driver) {
                            String string;
                            Intrinsics.checkNotNullParameter((Object)$memoryDoc, (String)"$memoryDoc");
                            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                            try {
                                string = driver.getArchitecture();
                            }
                            catch (DebuggerCommandException e) {
                                CidrDebuggerLog.LOG.warn("Failed to initialize architecture for disasm", (Throwable)e);
                                string = null;
                            }
                            String processArch = string;
                            UserDataHolder userDataHolder = (UserDataHolder)$memoryDoc.getVirtualFile();
                            String string2 = processArch;
                            if (string2 == null) {
                                string2 = "";
                            }
                            CidrDebuggerModuleMemory.DISASM_ARCH.set(userDataHolder, (Object)string2);
                            CidrDebuggerUsagesCollector.INSTANCE.logProcessArchitecture(processArch);
                            return Unit.INSTANCE;
                        }
                    }, disposable);
                    if (cidrDebugProcess.supportsRegisters()) {
                        MessageBusConnection messageBusConnection = session.getProject().getMessageBus().connect(disposable);
                        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
                        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
                        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(memoryDoc, session){
                            final /* synthetic */ CidrMemoryDoc<LLInstruction> $memoryDoc;
                            final /* synthetic */ XDebugSession $session;
                            {
                                this.$memoryDoc = $memoryDoc;
                                this.$session = $session;
                            }

                            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                if (Intrinsics.areEqual((Object)file, (Object)((Object)this.$memoryDoc.getVirtualFile()))) {
                                    XStackFrame xStackFrame = this.$session.getCurrentStackFrame();
                                    CidrStackFrame cidrStackFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
                                    if (cidrStackFrame == null) {
                                        return;
                                    }
                                    CidrStackFrame frame = cidrStackFrame;
                                    frame.setShowsRegisters(false);
                                }
                            }

                            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                if (!Intrinsics.areEqual((Object)event.getNewFile(), (Object)((Object)this.$memoryDoc.getVirtualFile()))) {
                                    return;
                                }
                                if (!this.$session.isSuspended()) {
                                    return;
                                }
                                XStackFrame xStackFrame = this.$session.getCurrentStackFrame();
                                CidrStackFrame cidrStackFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
                                if (cidrStackFrame == null) {
                                    return;
                                }
                                CidrStackFrame frame = cidrStackFrame;
                                if (!frame.isShowsRegisters() || Registry.is((String)"cidr.debugger.showInlineRegistersInDisasm")) {
                                    this.$session.rebuildViews();
                                }
                            }
                        });
                    }
                }
                return cidrMemoryDoc;
            }
        }));
        this.hexdumpDoc$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CidrMemoryDoc<Byte>>(process, parentDisposable){
            final /* synthetic */ CidrDebugProcess $process;
            final /* synthetic */ Disposable $parentDisposable;
            {
                this.$process = $process;
                this.$parentDisposable = $parentDisposable;
                super(0);
            }

            @NotNull
            public final CidrMemoryDoc<Byte> invoke() {
                CidrHexdumpRegionFactory hexdumpRegionFactory = new CidrHexdumpRegionFactory();
                Project project = this.$process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                CidrMemoryData.DataProvider dataProvider = new CidrDebuggerHexdumpDataProvider(this.$process);
                CidrMemoryDoc.DocRegionFactory docRegionFactory = hexdumpRegionFactory;
                HexdumpFileType hexdumpFileType = HexdumpFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)hexdumpFileType), (String)"INSTANCE");
                FileType fileType = (FileType)hexdumpFileType;
                String string = this.$process.getSession().getSessionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
                String string2 = CidrDebuggerBundle.message("debug.hexdump.editorTabDescription", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                CidrMemoryDoc<Byte> cidrMemoryDoc = new CidrMemoryDoc<Byte>(project, this.$parentDisposable, dataProvider, docRegionFactory, fileType, string, string2, new CidrHexdumpOptions());
                CidrDebugProcess cidrDebugProcess = this.$process;
                Disposable disposable = this.$parentDisposable;
                CidrMemoryDoc<Byte> memoryDoc = cidrMemoryDoc;
                boolean bl = false;
                memoryDoc.getVirtualFile().putUserData(CidrDebugProcess.DEBUG_PROCESS_KEY, cidrDebugProcess);
                XDebugSession xDebugSession = cidrDebugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                if (!CidrDebuggerModuleMemoryKt.skipMemoryDocsSubscription(xDebugSession)) {
                    cidrDebugProcess.getSession().addSessionListener(new XDebugSessionListener(disposable, memoryDoc, hexdumpRegionFactory, cidrDebugProcess){
                        private final int MARK_OUTDATED_DELAY_MS;
                        @NotNull
                        private final Alarm alarm;
                        final /* synthetic */ CidrMemoryDoc<Byte> $memoryDoc;
                        final /* synthetic */ CidrHexdumpRegionFactory $hexdumpRegionFactory;
                        final /* synthetic */ CidrDebugProcess $process;
                        {
                            this.$memoryDoc = $memoryDoc;
                            this.$hexdumpRegionFactory = $hexdumpRegionFactory;
                            this.$process = $process;
                            this.MARK_OUTDATED_DELAY_MS = 300;
                            this.alarm = new Alarm($parentDisposable);
                        }

                        public final int getMARK_OUTDATED_DELAY_MS() {
                            return this.MARK_OUTDATED_DELAY_MS;
                        }

                        @NotNull
                        public final Alarm getAlarm() {
                            return this.alarm;
                        }

                        public void sessionResumed() {
                            CidrMemoryDoc.cleanupErrors$default(this.$memoryDoc, null, 1, null);
                            this.alarm.addRequest(() -> hexdumpDoc.1.1.sessionResumed$lambda$0(this.$memoryDoc), this.MARK_OUTDATED_DELAY_MS);
                        }

                        public void sessionPaused() {
                            this.$hexdumpRegionFactory.startHighlightingSession();
                            this.alarm.cancelAllRequests();
                        }

                        public void sessionStopped() {
                            if (!this.$process.getProject().isDisposed()) {
                                FileEditorManager.getInstance((Project)this.$process.getProject()).updateFilePresentation((VirtualFile)this.$memoryDoc.getVirtualFile());
                            }
                        }

                        private static final void sessionResumed$lambda$0(CidrMemoryDoc $memoryDoc) {
                            Intrinsics.checkNotNullParameter((Object)$memoryDoc, (String)"$memoryDoc");
                            CidrMemoryDoc.markOutdated$default($memoryDoc, null, 1, null);
                        }
                    });
                }
                return cidrMemoryDoc;
            }
        }));
    }

    @NotNull
    public final CidrMemoryDoc<LLInstruction> getDisasmDoc() {
        Lazy lazy = this.disasmDoc$delegate;
        return (CidrMemoryDoc)lazy.getValue();
    }

    @NotNull
    public final CidrMemoryDoc<Byte> getHexdumpDoc() {
        Lazy lazy = this.hexdumpDoc$delegate;
        return (CidrMemoryDoc)lazy.getValue();
    }

    public final boolean contains(@NotNull CidrMemoryDoc<?> memoryDoc) {
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        return memoryDoc == this.getDisasmDoc() || memoryDoc == this.getHexdumpDoc();
    }

    static {
        Key key = Key.create((String)"cidr.debugger.disasm.arch");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DISASM_ARCH = key;
        Key key2 = Key.create((String)"Disasm functionality switcher");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        MEMORY_DOCS_ENABLED = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModuleMemory$Companion;", "", "()V", "DISASM_ARCH", "Lcom/intellij/openapi/util/Key;", "", "MEMORY_DOCS_ENABLED", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

