/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrAggregatedFrameStatistics;", "", "()V", "myMaxChildrenLoadingDurationMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "myMaxValuePresentationDurationMillis", "addChildrenLoadingTime", "", "durationMillis", "", "addValuePresentationTime", "report", "driverName", "", "Companion", "intellij.cidr.debugger"})
@ApiStatus.Internal
public final class CidrAggregatedFrameStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicLong myMaxValuePresentationDurationMillis = new AtomicLong(-1L);
    @NotNull
    private final AtomicLong myMaxChildrenLoadingDurationMillis = new AtomicLong(-1L);
    private static final long NONE = -1L;

    public final void report(@NotNull String driverName) {
        long maxChildrenLoadingTime;
        Intrinsics.checkNotNullParameter((Object)driverName, (String)"driverName");
        long maxValuePresentationTime = this.myMaxValuePresentationDurationMillis.get();
        if (maxValuePresentationTime != -1L) {
            CidrDebuggerUsagesCollector.logSlowestValuePresentationComputed(driverName, maxValuePresentationTime);
        }
        if ((maxChildrenLoadingTime = this.myMaxChildrenLoadingDurationMillis.get()) != -1L) {
            CidrDebuggerUsagesCollector.logSlowestChildrenLoaded(driverName, maxChildrenLoadingTime);
        }
    }

    public final void addValuePresentationTime(long durationMillis) {
        this.myMaxValuePresentationDurationMillis.accumulateAndGet(durationMillis, CidrAggregatedFrameStatistics::addValuePresentationTime$max__proxy);
    }

    public final void addChildrenLoadingTime(long durationMillis) {
        this.myMaxChildrenLoadingDurationMillis.accumulateAndGet(durationMillis, CidrAggregatedFrameStatistics::addChildrenLoadingTime$max__proxy$0);
    }

    private static final long addValuePresentationTime$max__proxy(long p0$a, long p1$b) {
        return Math.max(p0$a, p1$b);
    }

    private static final long addChildrenLoadingTime$max__proxy$0(long p0$a, long p1$b) {
        return Math.max(p0$a, p1$b);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrAggregatedFrameStatistics$Companion;", "", "()V", "NONE", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

