/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.TraceableExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildCoroutineHelperKt;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildId;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrBuild {
    private static final NotificationGroup LOG_NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Build Log");
    public static final Logger LOG = Logger.getInstance(CidrBuild.class);

    public static ExecutionResult<CidrBuildResult> execute(@NotNull Project project, @NotNull BuildContext context, @NotNull HostMachine hostMachine, @NotNull Runnable doExecute) {
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CidrBuild.$$$reportNull$$$0(1);
        }
        if (hostMachine == null) {
            CidrBuild.$$$reportNull$$$0(2);
        }
        if (doExecute == null) {
            CidrBuild.$$$reportNull$$$0(3);
        }
        return (ExecutionResult)CoroutinesKt.blockingContextToIndicator(() -> {
            context.indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (context.indicator == null) {
                throw new IllegalStateException("This code requires blockingContext with indicator set");
            }
            context.indicator.setText(context.progressTitle);
            context.indicator.setText2("");
            CidrBuildCoroutineHelperKt.executeInCoroutine(project, context, hostMachine, doExecute);
            return context.myResult;
        });
    }

    public static void startProcess(final @NotNull Project project, final BuildContext context, final Collection<File> toRefresh) {
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(4);
        }
        context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context.indicator != null) {
                    context.indicator.setText(CidrRunnerBundle.message("build.refreshing", new Object[0]));
                    context.indicator.setText2("");
                }
                CidrBuild.refreshFiles(toRefresh, context.refreshAsync, () -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    boolean buildSucceeded = event.getExitCode() == 0;
                    boolean canceled = context.isCanceled();
                    long duration = System.currentTimeMillis() - context2.started;
                    CidrBuildResult buildResult = new CidrBuildResult(buildSucceeded, canceled, context2.started, duration, context2.errors, context2.warnings);
                    String fullMessage = CidrBuild.buildNotificationMessage(context2.taskName, buildResult);
                    CidrBuildResult buildResultWithMessage = buildResult.withMessage(fullMessage);
                    context.finished(buildResultWithMessage);
                    CidrBuild.showBuildNotification(project, context2.taskName, buildResultWithMessage);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/execution/build/CidrBuild$1", "processTerminated"));
            }
        });
        ((CidrBuildListener)project.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).beforeStarted(new CidrBuildEvent(context.buildConfiguration, context.taskType, context.id));
        context.processHandler.startNotify();
    }

    public static void refreshFiles(@NotNull Collection<File> files, @NotNull Runnable onFinish) {
        if (files == null) {
            CidrBuild.$$$reportNull$$$0(5);
        }
        if (onFinish == null) {
            CidrBuild.$$$reportNull$$$0(6);
        }
        CidrBuild.doRefreshFiles(files, onFinish);
    }

    private static void refreshFiles(@NotNull Collection<File> files, boolean async, @NotNull Runnable onFinish) {
        if (files == null) {
            CidrBuild.$$$reportNull$$$0(7);
        }
        if (onFinish == null) {
            CidrBuild.$$$reportNull$$$0(8);
        }
        if (async) {
            CidrBuild.doRefreshFiles(files, () -> {});
            onFinish.run();
        } else {
            CidrBuild.doRefreshFiles(files, onFinish);
        }
    }

    private static void doRefreshFiles(@NotNull Collection<File> files, @NotNull Runnable onFinish) {
        if (files == null) {
            CidrBuild.$$$reportNull$$$0(9);
        }
        if (onFinish == null) {
            CidrBuild.$$$reportNull$$$0(10);
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            HashSet<File> toRefreshOneByOne = new HashSet<File>();
            HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
            for (File file : files) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (virtualFile == null || !virtualFile.isValid()) {
                    toRefreshOneByOne.add(file);
                    continue;
                }
                virtualFiles.add(virtualFile);
            }
            for (File file : toRefreshOneByOne) {
                virtualFiles.add(VfsUtil.findFileByIoFile((File)file, (boolean)true));
            }
            List list = VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(virtualFiles));
            RefreshQueue.getInstance().refresh(true, true, onFinish, ModalityState.nonModal(), (Collection)list);
        });
    }

    @BuildEventsNls.Message
    @NotNull
    private static String buildNotificationMessage(@BuildEventsNls.Title String taskName, @NotNull CidrBuildResult buildResult) {
        if (buildResult == null) {
            CidrBuild.$$$reportNull$$$0(11);
        }
        if (buildResult.getCanceled()) {
            String string = CidrRunnerBundle.message("build.canceled", taskName);
            if (string == null) {
                CidrBuild.$$$reportNull$$$0(12);
            }
            return string;
        }
        boolean hasWarningsOrErrors = buildResult.getErrors() > 0 || buildResult.getWarnings() > 0;
        boolean hasDuration = buildResult.getDuration() > 0L;
        boolean isSucceeded = buildResult.getSucceeded();
        String durationString = NlsMessages.formatDurationApproximate((long)buildResult.getDuration());
        if (!hasDuration && !hasWarningsOrErrors) {
            String string = isSucceeded ? CidrRunnerBundle.message("build.finished", taskName) : CidrRunnerBundle.message("build.failed", taskName);
            if (string == null) {
                CidrBuild.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (hasDuration && !hasWarningsOrErrors) {
            String string = isSucceeded ? CidrRunnerBundle.message("build.finished.duration", taskName, durationString) : CidrRunnerBundle.message("build.failed.duration", taskName, durationString);
            if (string == null) {
                CidrBuild.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (!hasDuration) {
            String string = isSucceeded ? CidrRunnerBundle.message("task.finished.with.details", taskName, buildResult.getErrors(), buildResult.getWarnings()) : CidrRunnerBundle.message("task.failed.with.details", taskName, buildResult.getErrors(), buildResult.getWarnings());
            if (string == null) {
                CidrBuild.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = isSucceeded ? CidrRunnerBundle.message("task.finished.with.details.and.duration", taskName, buildResult.getErrors(), buildResult.getWarnings(), durationString) : CidrRunnerBundle.message("task.failed.with.details.and.duration", taskName, buildResult.getErrors(), buildResult.getWarnings(), durationString);
        if (string == null) {
            CidrBuild.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static String showBuildNotification(@NotNull Project project, @NotNull MessageType messageType, @NotNull @Nls String message) {
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(17);
        }
        if (messageType == null) {
            CidrBuild.$$$reportNull$$$0(18);
        }
        if (message == null) {
            CidrBuild.$$$reportNull$$$0(19);
        }
        return CidrBuild.showBuildNotification(project, "Messages", messageType, message);
    }

    public static String showBuildNotification(@NotNull Project project, @NonNls @NotNull String toolWindowId, @NotNull MessageType messageType, @NotNull @Nls String message) {
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(20);
        }
        if (toolWindowId == null) {
            CidrBuild.$$$reportNull$$$0(21);
        }
        if (messageType == null) {
            CidrBuild.$$$reportNull$$$0(22);
        }
        if (message == null) {
            CidrBuild.$$$reportNull$$$0(23);
        }
        return CidrBuild.showBuildNotification(project, toolWindowId, messageType, message, message, null);
    }

    private static void showBuildNotification(@NotNull Project project, @BuildEventsNls.Title @NotNull String taskName, @NotNull CidrBuildResult buildResult) {
        MessageType messageType;
        String notificationTitle;
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(24);
        }
        if (taskName == null) {
            CidrBuild.$$$reportNull$$$0(25);
        }
        if (buildResult == null) {
            CidrBuild.$$$reportNull$$$0(26);
        }
        String balloonContent = buildResult.getMessage();
        String notificationText = null;
        if (buildResult.getCanceled()) {
            notificationTitle = CidrRunnerBundle.message("build.canceled", taskName);
            messageType = MessageType.INFO;
        } else {
            boolean hasWarningsOrErrors;
            boolean bl = hasWarningsOrErrors = buildResult.getErrors() > 0 || buildResult.getWarnings() > 0;
            messageType = !buildResult.getSucceeded() ? MessageType.ERROR : (hasWarningsOrErrors ? MessageType.WARNING : MessageType.INFO);
            notificationTitle = buildResult.getSucceeded() ? CidrRunnerBundle.message("build.finished", taskName) : CidrRunnerBundle.message("build.failed", taskName);
            notificationText = hasWarningsOrErrors ? CidrRunnerBundle.message("build.details", buildResult.getErrors(), buildResult.getWarnings()) : null;
        }
        CidrBuild.showBuildNotification(project, "Messages", messageType, balloonContent, notificationTitle, notificationText);
    }

    private static String showBuildNotification(@NotNull Project project, @NonNls @NotNull String balloonToolWindow, @NotNull MessageType balloonType, @Nls @NotNull String balloonContent, @NlsContexts.SystemNotificationTitle @NotNull String notificationTitle, @NlsContexts.SystemNotificationText @Nullable String notificationText) {
        if (project == null) {
            CidrBuild.$$$reportNull$$$0(27);
        }
        if (balloonToolWindow == null) {
            CidrBuild.$$$reportNull$$$0(28);
        }
        if (balloonType == null) {
            CidrBuild.$$$reportNull$$$0(29);
        }
        if (balloonContent == null) {
            CidrBuild.$$$reportNull$$$0(30);
        }
        if (notificationTitle == null) {
            CidrBuild.$$$reportNull$$$0(31);
        }
        Notification notification = LOG_NOTIFICATION_GROUP.createNotification(balloonContent, balloonType);
        notification.notify(project);
        if (balloonType == MessageType.ERROR) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            ToolWindow toolWindow = manager.getToolWindow(balloonToolWindow);
            String balloonToolWindowId = toolWindow == null ? "Messages" : balloonToolWindow;
            Runnable runnable = () -> manager.notifyByBalloon(balloonToolWindowId, balloonType, balloonContent);
            if (toolWindow == null) {
                MessageView.getInstance((Project)project).runWhenInitialized(runnable);
            } else {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        }
        SystemNotifications.getInstance().notify(notification.getGroupId(), notificationTitle, StringUtil.notNullize((String)notificationText));
        return balloonContent;
    }

    public static Pair<AnAction, Disposable> initializeBuildLog(@NotNull BuildContext context, @NonNls @NotNull String logName) {
        if (context == null) {
            CidrBuild.$$$reportNull$$$0(32);
        }
        if (logName == null) {
            CidrBuild.$$$reportNull$$$0(33);
        }
        File file = null;
        FileWriter writer = null;
        try {
            file = FileUtil.createTempFile((String)logName, (String)".log", (boolean)true);
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            LOG.error("Cannot create build log file", (Throwable)e);
        }
        final File finalFile = file;
        final FileWriter finalWriter = writer;
        AnAction showBuildLogAction = new AnAction(CidrRunnerBundle.messagePointer("build.action.showLog", new Object[0]), AllIcons.Debugger.Console){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (finalFile == null) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("open " + finalFile.getPath());
                }
                catch (IOException e) {
                    LOG.error("Cannot open build log file: " + finalFile, (Throwable)e);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(finalFile != null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/build/CidrBuild$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        if (finalWriter != null) {
            context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    try {
                        finalWriter.write(event.getText());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (finalWriter != null) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                if (finalFile != null) {
                    FileUtil.delete((File)finalFile);
                }
            }
        };
        return Pair.create((Object)showBuildLogAction, (Object)disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doExecute";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinish";
                break;
            }
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/build/CidrBuild";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloonToolWindow";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloonType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloonContent";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationTitle";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNotificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRefreshFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildNotificationMessage";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showBuildNotification";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "initializeBuildLog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static class BuildContext {
        @NotNull
        protected final ExecutionResult<CidrBuildResult> myResult;
        @NotNull
        public final CidrBuildId id;
        @NotNull
        public final CidrBuildConfiguration buildConfiguration;
        @NotNull
        public final CidrBuildTaskType taskType;
        @NotNull
        @Nls
        public final String taskName;
        @NotNull
        public final @NlsContexts.ProgressText String progressTitle;
        private final Project myProject;
        private final boolean refreshAsync;
        private final long started;
        public volatile ProgressIndicator indicator;
        public volatile Job job;
        public volatile ProcessHandler processHandler;
        public volatile int errors;
        public volatile int warnings;

        public BuildContext(@NotNull Project project, @NotNull CidrBuildConfiguration buildConfiguration, @Nullable CidrBuildTaskType taskType, @NotNull @Nls String taskName, @NotNull @NlsContexts.ProgressText String progressTitle) {
            if (project == null) {
                BuildContext.$$$reportNull$$$0(0);
            }
            if (buildConfiguration == null) {
                BuildContext.$$$reportNull$$$0(1);
            }
            if (taskName == null) {
                BuildContext.$$$reportNull$$$0(2);
            }
            if (progressTitle == null) {
                BuildContext.$$$reportNull$$$0(3);
            }
            this.myResult = new TraceableExecutionResult<CidrBuildResult>();
            this.refreshAsync = Registry.is((String)"cidr.asynchronous.refresh.after.build", (boolean)false);
            this.started = System.currentTimeMillis();
            this.myProject = project;
            this.id = CidrBuildId.create();
            this.buildConfiguration = buildConfiguration;
            this.taskType = taskType == null ? CidrBuildTaskType.BUILD : taskType;
            this.taskName = taskName;
            this.progressTitle = progressTitle;
        }

        public boolean isRunning() {
            return (this.indicator != null && !this.indicator.isCanceled() || this.job != null && this.job.isActive()) && !this.processHandler.isProcessTerminated() && !this.processHandler.isProcessTerminating();
        }

        public ExecutionResult<CidrBuildResult> getResult() {
            return this.myResult;
        }

        public void stop() {
            if (this.indicator != null) {
                this.indicator.cancel();
            }
            if (this.job != null) {
                this.job.cancel(new CancellationException());
            }
        }

        private void finished(@NotNull CidrBuildResult buildResult) {
            if (buildResult == null) {
                BuildContext.$$$reportNull$$$0(4);
            }
            this.myResult.set(buildResult);
            ((CidrBuildListener)this.myProject.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).afterFinished(new CidrBuildEvent(this.buildConfiguration, this.taskType, this.id), buildResult);
        }

        public void error(Throwable e) {
            this.myResult.setException(e);
        }

        boolean isCanceled() {
            if (this.indicator != null) {
                return this.indicator.isCanceled();
            }
            if (this.job != null) {
                return this.job.isCancelled();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressTitle";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildResult";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$BuildContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BuildContentRemoveListener
    implements ContentManagerListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ContentManager myContentManager;
        @NotNull
        private final Content myContent;
        @NotNull
        private final BuildContext myContext;

        public BuildContentRemoveListener(@NotNull Project project, @NotNull ContentManager contentManager, @NotNull Content content, @NotNull BuildContext context) {
            if (project == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(0);
            }
            if (contentManager == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(1);
            }
            if (content == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(2);
            }
            if (context == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myContentManager = contentManager;
            this.myContent = content;
            this.myContext = context;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(4);
            }
            if (event.getContent() != this.myContent) {
                return;
            }
            this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event == null) {
                BuildContentRemoveListener.$$$reportNull$$$0(5);
            }
            if (event.getContent() != this.myContent) {
                return;
            }
            if (this.myContext.isRunning()) {
                int result2 = Messages.showYesNoDialog((Project)this.myProject, (String)CidrRunnerBundle.message("build.inProgress.cancelQuestion", new Object[0]), (String)CidrRunnerBundle.message("build.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    this.myContext.stop();
                } else {
                    event.consume();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$BuildContentRemoveListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoveQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

