/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.execution.CidrRestartActionProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrLauncher {
    @RequiresBackgroundThread
    public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertBackgroundThread();
        return this.createProcess(state);
    }

    protected abstract ProcessHandler createProcess(@NotNull CommandLineState var1) throws ExecutionException;

    @NotNull
    public XDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        XDebugProcess result2;
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CidrLauncher.$$$reportNull$$$0(2);
        }
        if ((result2 = this.createDebugProcess(state, session)) instanceof CidrDebugProcess) {
            CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)result2;
            if (session instanceof XDebugSessionImpl) {
                XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                sessionImpl.addRestartActions(this.getAdditionalActions(state, cidrDebugProcess.getProcessHandler(), (ExecutionConsole)cidrDebugProcess.getConsole()));
            }
            CidrCoroutineHelper.runOnEDT(() -> {
                cidrDebugProcess.start();
                return null;
            });
        }
        XDebugProcess xDebugProcess = result2;
        if (xDebugProcess == null) {
            CidrLauncher.$$$reportNull$$$0(3);
        }
        return xDebugProcess;
    }

    @NotNull
    protected abstract XDebugProcess createDebugProcess(@NotNull CommandLineState var1, @NotNull XDebugSession var2) throws ExecutionException;

    void afterDebugSessionStarted(XDebugSession session) {
        XDebugProcess xDebugProcess = session.getDebugProcess();
        if (xDebugProcess instanceof CidrDebugProcess) {
            CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)xDebugProcess;
            cidrDebugProcess.afterDebugSessionStarted();
        }
    }

    protected static void configProcessHandler(@NotNull ProcessHandler handler, boolean detachSupported, boolean reportExitCode, @NotNull Project project) throws ExecutionException {
        if (handler == null) {
            CidrLauncher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CidrLauncher.$$$reportNull$$$0(5);
        }
        if (!detachSupported) {
            handler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        }
        if (reportExitCode) {
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)project);
        }
    }

    @NotNull
    public abstract Project getProject();

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult executionResult) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(6);
        }
        if (executionResult == null) {
            CidrLauncher.$$$reportNull$$$0(7);
        }
        executionResult.setRestartActions(this.getAdditionalActions(state, executionResult.getProcessHandler(), executionResult.getExecutionConsole()));
    }

    private AnAction @NotNull [] getAdditionalActions(@NotNull CommandLineState state, ProcessHandler handler, ExecutionConsole console) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(8);
        }
        ArrayList actions = new ArrayList();
        this.collectAdditionalActions(state, handler, console, actions);
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CidrLauncher.$$$reportNull$$$0(9);
        }
        return anActionArray;
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<? super AnAction> actions) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            CidrLauncher.$$$reportNull$$$0(11);
        }
        if (console == null) {
            CidrLauncher.$$$reportNull$$$0(12);
        }
        if (actions == null) {
            CidrLauncher.$$$reportNull$$$0(13);
        }
        if (state instanceof CidrRestartActionProvider) {
            actions.add((AnAction)((CidrRestartActionProvider)state).createRestartAction(console));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrLauncher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrLauncher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startDebugProcess";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configProcessHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActions";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }
}

