/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.impl.utils.graph.CFGAlgorithmsImpl;
import com.intellij.rml.dfa.impl.utils.graph.Forest;
import com.intellij.rml.dfa.impl.utils.graph.LengauerTarjanAlgorithmKt;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.rml.dfa.utils.graph.IntGraph;
import com.intellij.rml.dfa.utils.graph.IntGraphBuilder;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a2\u0010\u0007\u001a\u00020\u00062\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tH\u0002\u00a8\u0006\r"}, d2={"findDominators", "", "T", "cfg", "Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "main", "", "test", "edges", "", "Lkotlin/Pair;", "", "expectedDominators", "intellij.rml.dfa.impl"})
public final class LengauerTarjanAlgorithmKt {
    @NotNull
    public static final <T> Map<T, T> findDominators(@NotNull ControlFlowGraph<T> cfg2) {
        Intrinsics.checkNotNullParameter(cfg2, (String)"cfg");
        MultiMap bucket = new MultiMap();
        Map sdom = new LinkedHashMap();
        Graph<T> graph2 = cfg2.getGraph();
        CFGAlgorithmsImpl<T> algorithms = new CFGAlgorithmsImpl<T>(cfg2);
        Function2 comparator2 = new Function2<T, T, Boolean>(sdom, algorithms){
            final /* synthetic */ Map<T, T> $sdom;
            final /* synthetic */ CFGAlgorithmsImpl<T> $algorithms;
            {
                this.$sdom = $sdom;
                this.$algorithms = $algorithms;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@Nullable T n1, @Nullable T n2) {
                int n;
                int n3;
                T it;
                CFGAlgorithmsImpl<T> cFGAlgorithmsImpl;
                T t;
                T t2 = this.$sdom.get(n1);
                if (t2 != null) {
                    t = t2;
                    cFGAlgorithmsImpl = this.$algorithms;
                    it = t;
                    boolean bl = false;
                    n3 = cFGAlgorithmsImpl.dfsIndex(it);
                } else {
                    n3 = -1;
                }
                T t3 = this.$sdom.get(n2);
                if (t3 != null) {
                    t = t3;
                    cFGAlgorithmsImpl = this.$algorithms;
                    it = t;
                    int n4 = n3;
                    boolean bl = false;
                    int n5 = cFGAlgorithmsImpl.dfsIndex(it);
                    n3 = n4;
                    n = n5;
                } else {
                    n = -1;
                }
                return n3 < n;
            }
        };
        Forest<Object> forest = new Forest<Object>(graph2.nodes(), comparator2);
        Map idom = new LinkedHashMap();
        for (Object node : graph2.nodes()) {
            sdom.put(node, node);
        }
        block1: for (Object node : CollectionsKt.reversed((Iterable)algorithms.getDfsOrder())) {
            T parent;
            Object u;
            for (T prev : graph2.incomingNodes(node)) {
                u = forest.eval(prev);
                if (!((Boolean)comparator2.invoke(u, node)).booleanValue()) continue;
                sdom.put(node, sdom.get(u));
            }
            if (algorithms.getDfsParent(node) == null) continue;
            bucket.putValue(sdom.get(node), node);
            forest.link(parent, node);
            while (true) {
                T t;
                Collection collection = bucket.get(parent);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                if (!(!collection.isEmpty())) continue block1;
                Collection collection2 = bucket.get(parent);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                Object v = CollectionsKt.first((Iterable)collection2);
                bucket.remove(parent, v);
                u = forest.eval(v);
                if (((Boolean)comparator2.invoke(u, v)).booleanValue()) {
                    Object object = u;
                    t = object;
                    Intrinsics.checkNotNull(object);
                } else {
                    t = parent;
                }
                idom.put(v, t);
            }
        }
        for (Object node : algorithms.getDfsOrder()) {
            if (algorithms.getDfsParent(node) == null || Intrinsics.areEqual(idom.get(node), sdom.get(node))) continue;
            Object v = idom.get(idom.get(node));
            Intrinsics.checkNotNull(v);
            idom.put(node, v);
        }
        return idom;
    }

    private static final void test(List<Pair<Integer, Integer>> edges, List<Integer> expectedDominators) {
        IntGraph graph2 = GraphKt.buildIntGraph((Function1<? super IntGraphBuilder, Unit>)((Function1)new Function1<IntGraphBuilder, Unit>(edges){
            final /* synthetic */ List<Pair<Integer, Integer>> $edges;
            {
                this.$edges = $edges;
                super(1);
            }

            public final void invoke(@NotNull IntGraphBuilder $this$buildIntGraph) {
                Intrinsics.checkNotNullParameter((Object)$this$buildIntGraph, (String)"$this$buildIntGraph");
                for (Pair<Integer, Integer> edge : this.$edges) {
                    $this$buildIntGraph.addEdge(((Number)edge.getFirst()).intValue(), ((Number)edge.getSecond()).intValue());
                }
            }
        }));
        ControlFlowGraph<Comparable> cfg2 = new ControlFlowGraph<Comparable>(graph2, CollectionsKt.minOrThrow((Iterable)graph2.nodes()), CollectionsKt.maxOrThrow((Iterable)graph2.nodes()));
        Map<Comparable, Comparable> dominators2 = LengauerTarjanAlgorithmKt.findDominators(cfg2);
        if (!(graph2.getNodesCnt() == expectedDominators.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterator<Integer> iterator = graph2.nodes().iterator();
        while (iterator.hasNext()) {
            int node = ((Number)iterator.next()).intValue();
            if (Intrinsics.areEqual((Object)dominators2.get(node), (Object)expectedDominators.get(node))) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void main() {
        Object[] objectArray;
        ControlFlowGraph<Integer> cfg2 = new ControlFlowGraph<Integer>(GraphKt.buildIntGraph((Function1<? super IntGraphBuilder, Unit>)((Function1)main.cfg.1.INSTANCE)), 0, 0);
        Object[] $this$main_u24lambda_u240 = objectArray = LengauerTarjanAlgorithmKt.findDominators(cfg2);
        boolean bl = false;
        if (!$this$main_u24lambda_u240.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LengauerTarjanAlgorithmKt.test(CollectionsKt.listOf((Object)TuplesKt.to((Object)0, (Object)0)), CollectionsKt.listOf(null));
        objectArray = new Integer[]{null, 0};
        LengauerTarjanAlgorithmKt.test(CollectionsKt.listOf((Object)TuplesKt.to((Object)0, (Object)1)), CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2)};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 1};
        LengauerTarjanAlgorithmKt.test(list, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)2, (Object)3)};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 1, 2};
        LengauerTarjanAlgorithmKt.test(list2, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)2), TuplesKt.to((Object)2, (Object)1), TuplesKt.to((Object)1, (Object)3)};
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 2, 0, 1};
        LengauerTarjanAlgorithmKt.test(list3, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)0, (Object)2), TuplesKt.to((Object)0, (Object)3)};
        List list4 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 0, 0};
        LengauerTarjanAlgorithmKt.test(list4, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)0, (Object)2)};
        List list5 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 0};
        LengauerTarjanAlgorithmKt.test(list5, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)0, (Object)2), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)2, (Object)1)};
        List list6 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 0};
        LengauerTarjanAlgorithmKt.test(list6, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)0, (Object)2), TuplesKt.to((Object)1, (Object)3), TuplesKt.to((Object)2, (Object)3)};
        List list7 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 0, 0};
        LengauerTarjanAlgorithmKt.test(list7, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)2, (Object)7), TuplesKt.to((Object)1, (Object)3), TuplesKt.to((Object)3, (Object)4), TuplesKt.to((Object)4, (Object)5), TuplesKt.to((Object)4, (Object)6), TuplesKt.to((Object)5, (Object)7), TuplesKt.to((Object)6, (Object)4)};
        List list8 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 1, 1, 3, 4, 4, 1};
        LengauerTarjanAlgorithmKt.test(list8, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)3, (Object)4), TuplesKt.to((Object)4, (Object)5), TuplesKt.to((Object)5, (Object)6), TuplesKt.to((Object)3, (Object)6)};
        List list9 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 1, null, 3, 4, 3};
        LengauerTarjanAlgorithmKt.test(list9, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)2, (Object)3), TuplesKt.to((Object)3, (Object)4), TuplesKt.to((Object)4, (Object)2)};
        List list10 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 4, 2, null};
        LengauerTarjanAlgorithmKt.test(list10, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)1, (Object)2), TuplesKt.to((Object)2, (Object)3), TuplesKt.to((Object)0, (Object)4), TuplesKt.to((Object)4, (Object)5), TuplesKt.to((Object)5, (Object)6), TuplesKt.to((Object)3, (Object)7), TuplesKt.to((Object)6, (Object)7)};
        List list11 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 1, 2, 0, 4, 5, 0};
        LengauerTarjanAlgorithmKt.test(list11, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0, (Object)1), TuplesKt.to((Object)0, (Object)2), TuplesKt.to((Object)0, (Object)3), TuplesKt.to((Object)1, (Object)4), TuplesKt.to((Object)1, (Object)5), TuplesKt.to((Object)2, (Object)6), TuplesKt.to((Object)2, (Object)7), TuplesKt.to((Object)2, (Object)3), TuplesKt.to((Object)3, (Object)7), TuplesKt.to((Object)4, (Object)8), TuplesKt.to((Object)5, (Object)8), TuplesKt.to((Object)5, (Object)9), TuplesKt.to((Object)6, (Object)10), TuplesKt.to((Object)7, (Object)11), TuplesKt.to((Object)8, (Object)12), TuplesKt.to((Object)9, (Object)8), TuplesKt.to((Object)10, (Object)6), TuplesKt.to((Object)10, (Object)12), TuplesKt.to((Object)11, (Object)10), TuplesKt.to((Object)12, (Object)8), TuplesKt.to((Object)12, (Object)0)};
        List list12 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{null, 0, 0, 0, 1, 1, 0, 0, 0, 5, 0, 7, 0};
        LengauerTarjanAlgorithmKt.test(list12, CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ void main(String[] args) {
        LengauerTarjanAlgorithmKt.main();
    }
}

