/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.Quadruple;
import com.intellij.rml.dfa.analyzes.MayPointsToAnalysisKt;
import com.intellij.rml.dfa.analyzes.ParametersSubstitutorAnalysisKt;
import com.intellij.rml.dfa.analyzes.extensions.ConditionsExtensionKt;
import com.intellij.rml.dfa.impl.DfaAnalysisIrResultImpl;
import com.intellij.rml.dfa.impl.translator.CfgConsistencyCheckStage;
import com.intellij.rml.dfa.ir.DfaInvalidIrException;
import com.intellij.rml.dfa.ir.IrEnvironment;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.ast.IrDeclaration;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrLoadStmt;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStoreStmt;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.utils.RMLOptions;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"checkEnvironment", "", "project", "Lcom/intellij/rml/dfa/ir/IrProject;", "environment", "Lcom/intellij/rml/dfa/ir/IrEnvironment;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "checkNotInitialized", "result", "Lcom/intellij/rml/dfa/impl/DfaAnalysisIrResultImpl;", "invalidIrError", "message", "", "location", "Lcom/intellij/rml/dfa/ir/IrLocation;", "checkMode", "Lcom/intellij/rml/dfa/AnalysisOptions$CheckMode;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConsistencyChecker.kt\ncom/intellij/rml/dfa/impl/translator/IrConsistencyCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1855#2,2:111\n1855#2,2:113\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 IrConsistencyChecker.kt\ncom/intellij/rml/dfa/impl/translator/IrConsistencyCheckerKt\n*L\n83#1:111,2\n88#1:113,2\n93#1:115,2\n*E\n"})
public final class IrConsistencyCheckerKt {
    public static final void checkEnvironment(@NotNull IrProject project, @NotNull IrEnvironment environment, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        AnalysisOptions.CheckMode checkMode = options.get(AnalysisOptions.INSTANCE.getCheckEnvironment());
        if (checkMode != AnalysisOptions.CheckMode.Skip) {
            for (IrTopLevelDecl decl : project.getDeclarations()) {
                decl.accept(new IrRecursiveVisitor(environment, decl, checkMode){
                    final /* synthetic */ IrEnvironment $environment;
                    final /* synthetic */ IrTopLevelDecl $decl;
                    final /* synthetic */ AnalysisOptions.CheckMode $checkMode;
                    {
                        this.$environment = $environment;
                        this.$decl = $decl;
                        this.$checkMode = $checkMode;
                    }

                    public void visitIdentifier(@NotNull IrIdentifier identifier) {
                        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                        if (!(identifier instanceof IrFieldID) && this.$environment.resolve(identifier, this.$decl.getName()) == null) {
                            IrConsistencyCheckerKt.invalidIrError("Undefined identifier " + identifier, this.$decl.getLocation(), this.$checkMode);
                        }
                    }

                    private final void checkField(IrRecordID record, IrFieldID field, IrLocation location) {
                        if (record != null) {
                            if (!(this.$environment.resolve(record, null) instanceof IrRecordDecl)) {
                                IrConsistencyCheckerKt.invalidIrError("Unresolved record " + record, location, this.$checkMode);
                            }
                            if (!(this.$environment.resolve(field, record) instanceof IrFieldDecl)) {
                                IrConsistencyCheckerKt.invalidIrError("Unresolved field " + field + " in record " + record, location, this.$checkMode);
                            }
                        }
                    }

                    public void visitLoadStmt(@NotNull IrLoadStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        this.checkField(stmt.getReceiverDeclaredRecord(), stmt.getField(), stmt.getLocation());
                    }

                    public void visitStoreStmt(@NotNull IrStoreStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        this.checkField(stmt.getReceiverDeclaredRecord(), stmt.getField(), stmt.getLocation());
                    }

                    public void visitDeclaration(@NotNull IrDeclaration declarator) {
                        Intrinsics.checkNotNullParameter((Object)declarator, (String)"declarator");
                        if (!(declarator instanceof IrFieldDecl) && !Intrinsics.areEqual((Object)this.$environment.resolve(declarator.getName(), this.$decl.getName()), (Object)declarator)) {
                            IrConsistencyCheckerKt.invalidIrError("Duplicate declaration " + declarator.getName(), declarator.getLocation(), this.$checkMode);
                        }
                    }
                });
            }
        }
    }

    public static final void checkNotInitialized(@NotNull DfaAnalysisIrResultImpl result, @NotNull RMLOptions options) {
        IrObjectID loc;
        Quadruple quadruple;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        AnalysisOptions.CheckMode checkNotInitializedFields = options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedFields());
        AnalysisOptions.CheckMode checkNotInitializedVars = options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedVars());
        AnalysisOptions.CheckMode checkDeadConditions = options.get(AnalysisOptions.INSTANCE.getCheckDeadConditions());
        if (checkNotInitializedFields != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(ParametersSubstitutorAnalysisKt.getNotInitializedFieldUsage());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Quadruple)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                IrFieldID field = (IrFieldID)quadruple.component3();
                IrFunctionID function2 = (IrFunctionID)quadruple.component4();
                String string = "Field \"" + field + "\" is not initialized at \"" + function2 + "\"";
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError(string, ((IrLocationID)loc).getLocation(), checkNotInitializedFields);
            }
        }
        if (checkNotInitializedVars != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(MayPointsToAnalysisKt.getNotInitializedVarUsage());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Triple)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                IrVarID variable = (IrVarID)quadruple.component3();
                String string = "Variable \"" + variable + "\" is not initialized";
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError(string, ((IrLocationID)loc).getLocation(), checkNotInitializedVars);
            }
        }
        if (checkDeadConditions != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(ConditionsExtensionKt.getDeadCondition());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Pair)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError("Condition is dead", ((IrLocationID)loc).getLocation(), checkDeadConditions);
            }
        }
    }

    public static final void invalidIrError(@NotNull String message, @NotNull IrLocation location, @NotNull AnalysisOptions.CheckMode checkMode) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        switch (WhenMappings.$EnumSwitchMapping$0[checkMode.ordinal()]) {
            case 1: {
                CfgConsistencyCheckStage.Companion.getLOG().error(message + " at " + location);
                throw new DfaInvalidIrException(message, location);
            }
            case 2: {
                CfgConsistencyCheckStage.Companion.getLOG().error(message + " at " + location);
                break;
            }
            case 3: {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalysisOptions.CheckMode.values().length];
            try {
                nArray[AnalysisOptions.CheckMode.Throw.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisOptions.CheckMode.Log.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisOptions.CheckMode.Skip.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

