/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.impl.transform.PathSensitiveCfgProcessorImplKt;
import com.intellij.rml.dfa.impl.transform.ReadWriteCollector;
import com.intellij.rml.dfa.impl.transform.ReadsWriteBranches;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.transform.PathSensitiveCfgDescription;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/transform/PathSensitivityStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "(Lcom/intellij/rml/dfa/utils/Cancellation;)V", "getCancellation", "()Lcom/intellij/rml/dfa/utils/Cancellation;", "conditionalJump", "", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nPathSensitivityStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathSensitivityStage.kt\ncom/intellij/rml/dfa/impl/transform/PathSensitivityStage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1#2:81\n453#3:82\n403#3:83\n1238#4,4:84\n*S KotlinDebug\n*F\n+ 1 PathSensitivityStage.kt\ncom/intellij/rml/dfa/impl/transform/PathSensitivityStage\n*L\n70#1:82\n70#1:83\n70#1:84,4\n*E\n"})
public final class PathSensitivityStage
implements IrTransformStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cancellation cancellation;
    @NotNull
    private final List<Pair<IrCFGBlock, IrCFGBlock>> conditionalJump;
    @NotNull
    private final String name;
    @NotNull
    private static final Key<Map<IrCFGBlock, Integer>> PATH_MAPPING;
    @NotNull
    private static final Logger LOG;

    public PathSensitivityStage(@NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        this.cancellation = cancellation;
        this.conditionalJump = new ArrayList();
        this.name = "Path sensitive stage";
    }

    @NotNull
    public final Cancellation getCancellation() {
        return this.cancellation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Map map2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object it;
        Map map3;
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        ReadWriteCollector collector = new ReadWriteCollector(options);
        ReadsWriteBranches readWrites = collector.collectReadsWrites((IrFunctionDecl)decl);
        for (Map.Entry<IrCFGBlock, IrJump> entry : ((IrFunctionDecl)decl).getBody().getJumps().entrySet()) {
            IrCFGBlock block = entry.getKey();
            IrJump jump = entry.getValue();
            if (!(jump instanceof IrConditionalJump)) continue;
            this.conditionalJump.add((Pair<IrCFGBlock, IrCFGBlock>)TuplesKt.to((Object)block, (Object)((IrConditionalJump)jump).getTrueBranch()));
            this.conditionalJump.add((Pair<IrCFGBlock, IrCFGBlock>)TuplesKt.to((Object)block, (Object)((IrConditionalJump)jump).getFalseBranch()));
        }
        PathSensitiveCfgDescription<IrCFGBlock, IrVarID> description = new PathSensitiveCfgDescription<IrCFGBlock, IrVarID>(readWrites.getReads(), readWrites.getWrites(), readWrites.getBranches(), this.conditionalJump, CollectionsKt.emptyList());
        ControlFlowGraph<IrCFGBlock> cfg2 = ((IrFunctionDecl)decl).getBody().toControlFlowGraph();
        Pair<ControlFlowGraph<IrCFGBlock>, Map<IrCFGBlock, IrCFGBlock>> pathSensitiveResult = PathSensitiveCfgProcessorImplKt.buildPathSensitiveCfg(((IrFunctionDecl)decl).getName().getAttr(), cfg2, description, true, this.cancellation);
        if (pathSensitiveResult == null) {
            LOG.warn("Path sensitive stage finished unsuccessfully, skip it");
            return decl;
        }
        ControlFlowGraph pathSensitiveCfg = (ControlFlowGraph)pathSensitiveResult.component1();
        Map originalNode = (Map)pathSensitiveResult.component2();
        Map $this$transform_u24lambda_u243 = map3 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (IrCFGBlock context : pathSensitiveCfg.getGraph().nodes()) {
            Iterable iterable;
            IrCFGBlock original;
            if ((IrCFGBlock)originalNode.get(context) == null) {
                throw new IllegalStateException();
            }
            IrJump originalJump = ((IrFunctionDecl)decl).getBody().getJumps().get(original);
            if (originalJump instanceof IrUnconditionalJump) {
                Object v0;
                block13: {
                    iterable = pathSensitiveCfg.getGraph().get(context);
                    for (Object object32 : iterable) {
                        it = (IrCFGBlock)object32;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(originalNode.get(it), (Object)((IrUnconditionalJump)originalJump).getNextBlock())) continue;
                        v0 = object32;
                        break block13;
                    }
                    v0 = null;
                }
                IrCFGBlock destContext = v0;
                if (destContext == null) {
                    throw new DfaInternalException(null, null, 3, null);
                }
                $this$transform_u24lambda_u243.put(context, new IrUnconditionalJump(destContext));
                continue;
            }
            if (originalJump instanceof IrConditionalJump) {
                Object object;
                IrCFGBlock trueBranchContext;
                block15: {
                    Object object2;
                    Object object32;
                    block14: {
                        iterable = pathSensitiveCfg.getGraph().get(context);
                        for (Object object32 : iterable) {
                            it = (IrCFGBlock)object32;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(originalNode.get(it), (Object)((IrConditionalJump)originalJump).getTrueBranch())) continue;
                            object2 = object32;
                            break block14;
                        }
                        object2 = null;
                    }
                    trueBranchContext = (IrCFGBlock)object2;
                    Iterator iterator = pathSensitiveCfg.getGraph().get(context);
                    object32 = iterator.iterator();
                    while (object32.hasNext()) {
                        it = object32.next();
                        IrCFGBlock it2 = it;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(originalNode.get(it2), (Object)((IrConditionalJump)originalJump).getFalseBranch())) continue;
                        object = it;
                        break block15;
                    }
                    object = null;
                }
                IrCFGBlock falseBranchContext = (IrCFGBlock)object;
                if (trueBranchContext == null || falseBranchContext == null) {
                    throw new DfaInternalException(null, null, 3, null);
                }
                $this$transform_u24lambda_u243.put(context, new IrConditionalJump(((IrConditionalJump)originalJump).getCondition(), trueBranchContext, falseBranchContext));
                continue;
            }
            if (originalJump != null) continue;
        }
        Map newJumps = MapsKt.build((Map)map3);
        IrCfg newCfg = new IrCfg(pathSensitiveCfg.getGraph().nodes(), newJumps, (IrCFGBlock)pathSensitiveCfg.getStartNode(), (IrCFGBlock)pathSensitiveCfg.getExitNode());
        $this$transform_u24lambda_u243 = originalNode;
        Key<Map<IrCFGBlock, Integer>> key = PATH_MAPPING;
        IrTopLevelDecl irTopLevelDecl = decl;
        boolean $i$f$mapValues = false;
        Iterator iterator = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl5 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map4;
            boolean bl6 = false;
            IrCFGBlock origBlock = (IrCFGBlock)entry.getValue();
            Integer n = cfg2.getGraph().getIdByNode(origBlock);
            map2.put(k, n);
        }
        map2 = destination$iv$iv;
        irTopLevelDecl.putUserData(key, map2);
        return ((IrFunctionDecl)decl).modifyCfg(newCfg);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    static {
        Key key = Key.create((String)"PATH_MAPPING");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PATH_MAPPING = key;
        Logger logger = Logger.getInstance(PathSensitivityStage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0006\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n \u000b*\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/impl/transform/PathSensitivityStage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PATH_MAPPING", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "", "kotlin.jvm.PlatformType", "getPATH_MAPPING", "()Lcom/intellij/openapi/util/Key;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Map<IrCFGBlock, Integer>> getPATH_MAPPING() {
            return PATH_MAPPING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

