/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.symtable;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProviderBase;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.summaries.AttributesFilter;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\nJ2\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u001cJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u0004\u0018\u00010\u00182\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010J\b\u00103\u001a\u00020\u001cH\u0016R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0011\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\b0\u00070\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R(\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00070\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\"\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/rml/dfa/impl/symtable/SymbolTableWithDependencies;", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "descriptor", "Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;", "dependentTables", "", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "", "trackSources", "(Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;Ljava/util/List;Z)V", "attributeDependencies", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "dependentTableAttributesMap", "", "", "", "[Ljava/util/Map;", "dependentTableMissingAttributes", "dependentTableRelations", "Lcom/intellij/rml/dfa/impl/relations/IRelation;", "typeWithDependentAttributes", "", "addDependentAttributes", "", "table", "buildAttributesMap", "sourceTable", "isSubset", "buildMapRelation", "sourceProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProviderBase;", "sourceManager", "Lcom/intellij/rml/dfa/impl/relations/IRelationsManager;", "destProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;", "attributesFilter", "Lcom/intellij/rml/dfa/impl/summaries/AttributesFilter;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "cleanup", "evaluateDependentAttributes", "provider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "getAttributesMap", "dependentTable", "domainType", "sortAttributes", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSymbolTableWithDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTableWithDependencies.kt\ncom/intellij/rml/dfa/impl/symtable/SymbolTableWithDependencies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,165:1\n1549#2:166\n1620#2,3:167\n819#2:170\n847#2,2:171\n1549#2:173\n1620#2,3:174\n13309#3,2:177\n13309#3,2:179\n13309#3,2:181\n*S KotlinDebug\n*F\n+ 1 SymbolTableWithDependencies.kt\ncom/intellij/rml/dfa/impl/symtable/SymbolTableWithDependencies\n*L\n90#1:166\n90#1:167,3\n98#1:170\n98#1:171,2\n98#1:173\n98#1:174,3\n161#1:177,2\n162#1:179,2\n163#1:181,2\n*E\n"})
public final class SymbolTableWithDependencies
extends MutableSymbolTable {
    @NotNull
    private final List<Pair<SymbolTable, Boolean>> dependentTables;
    @NotNull
    private final Map<SymbolTable, List<Pair<Integer, Integer>>>[] dependentTableAttributesMap;
    @NotNull
    private final Map<SymbolTable, List<Integer>>[] dependentTableMissingAttributes;
    @NotNull
    private final Map<SymbolTable, IRelation>[] dependentTableRelations;
    @NotNull
    private final MultiMap<Attribute, Pair<Attribute, DomainType>> attributeDependencies;
    @NotNull
    private final Set<DomainType> typeWithDependentAttributes;

    public SymbolTableWithDependencies(@NotNull DomainTypeManager typeManager, @NotNull RmlProviderDescriptor descriptor, @NotNull List<? extends Pair<? extends SymbolTable, Boolean>> dependentTables, boolean trackSources) {
        int n;
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(dependentTables, (String)"dependentTables");
        super(typeManager, descriptor, trackSources);
        this.dependentTables = dependentTables;
        int n2 = 0;
        int n3 = this.availableTypesCnt;
        Map[] mapArray = new Map[n3];
        SymbolTableWithDependencies symbolTableWithDependencies = this;
        while (n2 < n3) {
            n = n2++;
            mapArray[n] = new LinkedHashMap();
        }
        symbolTableWithDependencies.dependentTableAttributesMap = mapArray;
        n2 = 0;
        n3 = this.availableTypesCnt;
        mapArray = new Map[n3];
        symbolTableWithDependencies = this;
        while (n2 < n3) {
            n = n2++;
            mapArray[n] = new LinkedHashMap();
        }
        symbolTableWithDependencies.dependentTableMissingAttributes = mapArray;
        n2 = 0;
        n3 = this.availableTypesCnt;
        mapArray = new Map[n3];
        symbolTableWithDependencies = this;
        while (n2 < n3) {
            n = n2++;
            mapArray[n] = new LinkedHashMap();
        }
        symbolTableWithDependencies.dependentTableRelations = mapArray;
        this.attributeDependencies = new MultiMap();
        this.typeWithDependentAttributes = new LinkedHashSet();
    }

    public final void evaluateDependentAttributes(@NotNull RMLInstancesProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        for (RmlRelation rmlRelation : provider.getFactory().getAnalysisDescription().getAttributeDependencyInfo().getDependencyRelations()) {
            IImmutableRelation relation = provider.getRelationsRepository().getRelationOrNull(rmlRelation.getName());
            if (relation == null) continue;
            DomainType domainType = relation.getDomainType(0);
            Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getDomainType(...)");
            this.typeWithDependentAttributes.add(domainType);
            Attribute[][] tuples2 = relation.getAttributes(this);
            int n = relation.getDomains().length;
            for (int i = 1; i < n; ++i) {
                DomainType domainType2 = relation.getDomainType(i);
                if (domainType2.isIntegerType()) continue;
                Intrinsics.checkNotNull((Object)tuples2);
                Attribute[][] attributeArray = tuples2;
                int n2 = ((Object[])attributeArray).length;
                for (int j = 0; j < n2; ++j) {
                    Attribute[] attributes = attributeArray[j];
                    this.attributeDependencies.putValue((Object)attributes[0], (Object)TuplesKt.to((Object)attributes[i], (Object)domainType2));
                }
            }
        }
    }

    public final void addDependentAttributes(@NotNull SymbolTableWithDependencies table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Stack<Attribute> stack = new Stack<Attribute>();
        int n = this.availableTypesCnt;
        for (int i = 0; i < n; ++i) {
            if (!table.typeWithDependentAttributes.contains(this.typeManager.getDomainType(i))) continue;
            for (Attribute attribute : this.attributesSet[i]) {
                stack.push(attribute);
            }
        }
        while (!stack.isEmpty()) {
            Attribute attribute = (Attribute)stack.pop();
            for (Pair pair : table.attributeDependencies.get((Object)attribute)) {
                DomainType domainType;
                Attribute depAttribute = (Attribute)pair.component1();
                if (!this.addAttribute(depAttribute, domainType = (DomainType)pair.component2(), "From dependent attribute", attribute.toString())) continue;
                stack.push(depAttribute);
            }
        }
    }

    @Override
    public void sortAttributes() {
        super.sortAttributes();
        for (Pair<SymbolTable, Boolean> pair : this.dependentTables) {
            SymbolTable table = (SymbolTable)pair.component1();
            boolean isSubset = (Boolean)pair.component2();
            this.buildAttributesMap(table, isSubset);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void buildAttributesMap(@NotNull SymbolTable sourceTable, boolean isSubset) {
        Intrinsics.checkNotNullParameter((Object)sourceTable, (String)"sourceTable");
        int n = this.typeManager.getDomainTypesCount();
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            AttributesInfo destInfo;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object destAttrInt;
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType()) continue;
            Map attrsMap = new HashMap();
            for (Attribute attribute : (isSubset ? sourceTable : (SymbolTable)this).getAttributes(domainType)) {
                String string = attribute.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                Integer sourceAttrInt = sourceTable.getAttributeIntOrNull(domainType, string);
                destAttrInt = this.getAttributeIntOrNull(domainType, attribute.getKey());
                if (sourceAttrInt == null || destAttrInt == null) continue;
                attrsMap.put(sourceAttrInt, destAttrInt);
            }
            Iterable $this$map$iv2 = attrsMap.entrySet();
            boolean $i$f$map = false;
            destAttrInt = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                int key = ((Number)entry.getKey()).intValue();
                int value = ((Number)entry.getValue()).intValue();
                collection.add(new Pair((Object)key, (Object)value));
            }
            List pairs = (List)destination$iv$iv;
            this.dependentTableAttributesMap[i].put(sourceTable, pairs);
            AttributesInfo sourceInfo = sourceTable.getAttributesInfo(domainType);
            Intrinsics.checkNotNullExpressionValue((Object)this.getAttributesInfo(domainType), (String)"getAttributesInfo(...)");
            if (sourceInfo.getNumOfAttributes() < destInfo.getNumOfAttributes()) continue;
            Map<SymbolTable, List<Integer>> map2 = this.dependentTableMissingAttributes[i];
            List<Attribute> list = this.getAttributes(i);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAttributes(...)");
            Iterable $this$filterNot$iv = list;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Attribute it = (Attribute)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (sourceTable.containsAttribute(i, it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Attribute it = (Attribute)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(this.getAttributeInt(domainType, it.getKey()));
            }
            List list2 = (List)destination$iv$iv2;
            map2.put(sourceTable, list2);
        }
    }

    public final void buildMapRelation(@NotNull RMLInstancesProviderBase sourceProvider, @Nullable IRelationsManager sourceManager, @NotNull RMLMutableInstancesProvider destProvider, @Nullable AttributesFilter attributesFilter, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)sourceProvider, (String)"sourceProvider");
        Intrinsics.checkNotNullParameter((Object)destProvider, (String)"destProvider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        SymbolTable sourceTable = sourceProvider.getSymbolTable();
        IRelationsManager destManager = destProvider.getRelationsManager();
        int n = this.typeManager.getDomainTypesCount();
        for (int i = 0; i < n; ++i) {
            Map<SymbolTable, IRelation> map2;
            Object object2;
            IRelationsManager iRelationsManager;
            AttributesInfo destInfo;
            DomainType domainType = this.typeManager.getDomainType(i);
            if (domainType.isIntegerType()) continue;
            AttributesInfo sourceInfo = sourceTable.getAttributesInfo(domainType);
            Intrinsics.checkNotNullExpressionValue((Object)this.getAttributesInfo(domainType), (String)"getAttributesInfo(...)");
            if (sourceInfo.getNumOfAttributes() == destInfo.getNumOfAttributes()) {
                iRelationsManager = sourceManager;
                if (iRelationsManager == null) {
                    iRelationsManager = destManager;
                }
            } else if (sourceInfo.getNumOfAttributes() < destInfo.getNumOfAttributes()) {
                iRelationsManager = destManager;
            } else {
                iRelationsManager = sourceManager;
                if (iRelationsManager == null) {
                    throw new DfaInternalException(sourceTable.toString(), "Migrating from immutable relation manager");
                }
            }
            IRelationsManager relationsManager = iRelationsManager;
            DomainType[] domainTypeArray = new DomainType[]{domainType, domainType};
            IRelation mapper = relationsManager.makeEmptyRelation(domainTypeArray);
            int srcUnlimitedFlag = (1 << sourceInfo.getBitLength()) - 1;
            int dstUnlimitedFlag = (1 << destInfo.getBitLength()) - 1;
            List<Pair<Integer, Integer>> list = this.dependentTableAttributesMap[domainType.getIndex()].get(sourceTable);
            Intrinsics.checkNotNull(list);
            for (Object object2 : list) {
                int srcAttr = ((Number)object2.component1()).intValue();
                int dstAttr = ((Number)object2.component2()).intValue();
                int[] nArray = new int[]{srcAttr, dstAttr};
                mapper = mapper.addTuple(nArray);
                cancellation.checkCancelled();
            }
            if (Intrinsics.areEqual((Object)relationsManager, (Object)destManager)) {
                IRelation iRelation;
                IRelation it = mapper.exists(0, cancellation);
                boolean bl = false;
                if (attributesFilter != null) {
                    Intrinsics.checkNotNull((Object)relationsManager);
                    MutableSymbolTable mutableSymbolTable = destProvider.getSymbolTable();
                    Intrinsics.checkNotNullExpressionValue((Object)mutableSymbolTable, (String)"<get-symbolTable>(...)");
                    SymbolTable symbolTable = mutableSymbolTable;
                    Domain[] domainArray = it.getDomains();
                    Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"getDomains(...)");
                    iRelation = it.unsafeUnite(attributesFilter.getRelation(relationsManager, symbolTable, domainType, domainArray), cancellation);
                } else {
                    iRelation = it;
                }
                IRelation commonAttributes = iRelation;
                IRelation missingAttributes = commonAttributes.complement(cancellation);
                Object[] objectArray = new Domain[]{domainType.getDomain(0)};
                Domain[] domainArray = objectArray;
                objectArray = new int[1];
                objectArray[0] = (Domain)srcUnlimitedFlag;
                IRelation srcUnlimitedRel = relationsManager.makeSingleTuple(domainArray, (int[])objectArray);
                mapper = mapper.unsafeUnite(missingAttributes.unsafeIntersect(srcUnlimitedRel, cancellation), cancellation);
            } else {
                List<Integer> list2 = this.dependentTableMissingAttributes[domainType.getIndex()].get(sourceTable);
                Intrinsics.checkNotNull(list2);
                map2 = list2.iterator();
                while (map2.hasNext()) {
                    int dstAttr = ((Number)map2.next()).intValue();
                    int[] nArray = new int[]{srcUnlimitedFlag, dstAttr};
                    mapper = mapper.addTuple(nArray);
                    cancellation.checkCancelled();
                }
                map2 = (Map<SymbolTable, IRelation>)new int[2];
                map2[0] = srcUnlimitedFlag;
                map2[1] = dstUnlimitedFlag;
                mapper = mapper.addTuple((int[])map2);
            }
            map2 = this.dependentTableRelations[i];
            object2 = mapper;
            Intrinsics.checkNotNull(object2);
            map2.put(sourceTable, (IRelation)object2);
        }
    }

    @Nullable
    public final IRelation getAttributesMap(@NotNull SymbolTable dependentTable, @NotNull DomainType domainType) {
        Intrinsics.checkNotNullParameter((Object)dependentTable, (String)"dependentTable");
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        return this.dependentTableRelations[domainType.getIndex()].get(dependentTable);
    }

    public final void cleanup() {
        Map<SymbolTable, List<Pair<Integer, Integer>>> it;
        Map<SymbolTable, Object> element$iv;
        int n;
        Map<SymbolTable, Object>[] $this$forEach$iv = this.dependentTableAttributesMap;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.clear();
        }
        $this$forEach$iv = this.dependentTableMissingAttributes;
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.clear();
        }
        $this$forEach$iv = this.dependentTableRelations;
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.clear();
        }
    }
}

