/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.providers.ProviderType;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ&\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor;", "Lcom/intellij/rml/dfa/impl/visitors/Visitor;", "globalProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "localProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;", "summaryRelations", "", "", "(Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;Ljava/util/List;)V", "name", "getName", "()Ljava/lang/String;", "outputRelations", "", "Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getOutputRelations", "()[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getSummaryRelations", "()Ljava/util/List;", "collectAttributes", "", "input", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "collectRelations", "provider", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nMigrateToSummariesVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateToSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,69:1\n26#2:70\n*S KotlinDebug\n*F\n+ 1 MigrateToSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateToSummariesVisitor\n*L\n19#1:70\n*E\n"})
public class MigrateToSummariesVisitor
implements Visitor {
    @NotNull
    private final RMLInstancesProvider globalProvider;
    @NotNull
    private final RMLMutableInstancesProvider localProvider;
    @NotNull
    private final List<String> summaryRelations;
    @NotNull
    private final String name;
    @NotNull
    private final RelationSignature[] outputRelations;

    public MigrateToSummariesVisitor(@NotNull RMLInstancesProvider globalProvider, @NotNull RMLMutableInstancesProvider localProvider, @NotNull List<String> summaryRelations) {
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        Intrinsics.checkNotNullParameter((Object)localProvider, (String)"localProvider");
        Intrinsics.checkNotNullParameter(summaryRelations, (String)"summaryRelations");
        this.globalProvider = globalProvider;
        this.localProvider = localProvider;
        this.summaryRelations = summaryRelations;
        this.name = "Summary collector";
        boolean $i$f$emptyArray = false;
        this.outputRelations = new RelationSignature[0];
    }

    @NotNull
    public final List<String> getSummaryRelations() {
        return this.summaryRelations;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.outputRelations;
    }

    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input2, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (symbolTable instanceof SymbolTableWithDependencies) {
            MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
            Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
            MutableRelationsRepository repository = mutableRelationsRepository;
            for (String relationName : this.summaryRelations) {
                IRelation relation;
                Object nameWithSuffix = this.summaryRelations.contains(relationName) ? relationName + "$Summary" : relationName;
                if (!repository.containsRelation((String)nameWithSuffix)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)repository.getRelation((String)nameWithSuffix), (String)"getRelation(...)");
                relation.copyAttributes(relationName, this.localProvider.getSymbolTable(), symbolTable);
            }
        } else {
            symbolTable.addAttributesFrom(CollectionsKt.listOf((Object)this.globalProvider.getSymbolTable()), true);
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input2, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        boolean isGlobalSummary;
        Intrinsics.checkNotNullParameter(input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        MutableRelationsRepository mutableRelationsRepository = this.localProvider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository repository = mutableRelationsRepository;
        MutableSymbolTable mutableSymbolTable = provider.getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)mutableSymbolTable, (String)"<get-symbolTable>(...)");
        MutableSymbolTable symbolTable = mutableSymbolTable;
        boolean bl = isGlobalSummary = provider.getDescriptor().getType() == ProviderType.GlobalSummary;
        if (!isGlobalSummary && symbolTable instanceof SymbolTableWithDependencies) {
            ((SymbolTableWithDependencies)symbolTable).buildMapRelation(this.localProvider, repository.getRelationsManager(), provider, null, cancellation);
        }
        for (String relationName : this.summaryRelations) {
            String nameWithSuffix = relationName + "$Summary";
            if (!repository.containsRelation(nameWithSuffix)) continue;
            IRelation iRelation = repository.getRelation(nameWithSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"getRelation(...)");
            IRelation relation = iRelation;
            IRelation iRelation2 = relation.migrate(repository.getRelationsManager(), provider.getRelationsManager(), this.localProvider.getSymbolTable(), symbolTable, !isGlobalSummary, cancellation);
            Intrinsics.checkNotNullExpressionValue((Object)iRelation2, (String)"migrate(...)");
            relation = iRelation2;
            if (provider.getRelationsRepository().containsRelation(relationName)) {
                IRelation iRelation3 = relation.unsafeUnite(provider.getRelationsRepository().getRelation(relationName), cancellation);
                Intrinsics.checkNotNullExpressionValue((Object)iRelation3, (String)"unsafeUnite(...)");
                relation = iRelation3;
            }
            provider.getRelationsRepository().addRelation(relationName, relation);
        }
        if (symbolTable instanceof SymbolTableWithDependencies) {
            ((SymbolTableWithDependencies)symbolTable).cleanup();
        }
    }
}

