/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.lang.RelationModification;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariablesManager {
    private final DomainTypeManager typeManager;
    private final Map<String, Integer> variables = new HashMap<String, Integer>();
    private final Map<String, DomainType[]> relations = new HashMap<String, DomainType[]>();
    private final Set<String> usedRelations = new HashSet<String>();
    private final Set<String> options = new HashSet<String>();
    private final Map<String, Integer> defaultOptionValues = new HashMap<String, Integer>();
    private final Map<String, List<RelationModification>> inputRelationModifications = new HashMap<String, List<RelationModification>>();
    private final Map<RmlDeclarationType, Set<RelationSignature>> signatures = new LinkedHashMap<RmlDeclarationType, Set<RelationSignature>>();
    private final Map<String, String> subgroups = new HashMap<String, String>();
    private final Map<String, DomainType> domains = new HashMap<String, DomainType>();
    private final Set<String> domUsages = new HashSet<String>();

    public VariablesManager(DomainTypeManager typeManager) {
        this.typeManager = typeManager;
        for (RmlDeclarationType type : RmlDeclarationType.getEntries()) {
            this.signatures.put(type, new HashSet());
        }
    }

    public DomainTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void addVariable(String name, int type) {
        this.variables.put(name, type);
    }

    public void addOption(String name, Integer defaultValue, int type) {
        this.variables.put(name, type);
        this.defaultOptionValues.put(name, defaultValue);
        this.options.add(name);
    }

    public int getVariableType(String name) {
        return this.variables.get(name);
    }

    public boolean containsVariable(String name) {
        return this.variables.containsKey(name);
    }

    public Collection<String> getVariables() {
        return this.variables.keySet();
    }

    public boolean isOption(String name) {
        return this.options.contains(name);
    }

    public Integer getDefaultOptionValue(String name) {
        return this.defaultOptionValues.get(name);
    }

    public void addRelationDeclaration(RmlDeclarationType type, RelationSignature signature, List<RelationModification> modifications) {
        if (type == RmlDeclarationType.Input) {
            this.inputRelationModifications.put(signature.getName(), modifications);
        }
        this.signatures.get((Object)type).add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void setRelationSubgroup(String relName, String subgroup) {
        this.subgroups.put(relName, subgroup);
    }

    public RelationSignature[] getRelations(RmlDeclarationType type) {
        return this.signatures.get((Object)type).toArray(RelationSignature.EMPTY_ARRAY);
    }

    public String getRelationSubgroup(String relationName) {
        return this.subgroups.get(relationName);
    }

    public boolean isInputRelation(String name) {
        return this.signatures.get((Object)RmlDeclarationType.Input).contains(new RelationSignature(name, this.getRelation(name)));
    }

    public List<RelationModification> getInputRelationModifications(String relationName) {
        List<RelationModification> modifications = this.inputRelationModifications.get(relationName);
        return modifications != null ? modifications : List.of();
    }

    public DomainType[] getRelation(String name) {
        this.usedRelations.add(name);
        return this.relations.get(name);
    }

    public boolean containsRelation(String name) {
        return this.relations.containsKey(name);
    }

    public void checkUnusedRelations(String scriptName) {
        for (RmlDeclarationType type : this.signatures.keySet()) {
            for (RelationSignature relation : this.signatures.get((Object)type)) {
                if (this.usedRelations.contains(relation.getName())) continue;
                throw new DfaInternalException(type.name() + " relation " + relation.getName() + " is not used in script " + scriptName);
            }
        }
    }

    public void addDomain(String name, DomainType type) {
        this.domains.put(name, type);
    }

    public DomainType getDomain(String name) {
        return this.domains.get(name);
    }

    public boolean containsDomain(String name) {
        return this.domains.containsKey(name);
    }

    public void useDomain(String name) {
        this.domUsages.add(name);
    }

    public boolean wasDomainUsed(String name) {
        return this.domUsages.contains(name);
    }

    public void removeDomain(String name) {
        this.domains.remove(name);
        this.domUsages.remove(name);
    }
}

