/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.rml.dsl.ast.RmlPredefinedPredicate;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;

public class RelExprPredefinedPredicate
extends RelExpr {
    private final RmlPredefinedPredicate predicate;
    private final String[] names;
    private String flag;

    public RelExprPredefinedPredicate(RmlPredefinedPredicate predicate, String[] names, Context context) {
        super(context, new QueryNode[0]);
        this.predicate = predicate;
        this.names = names;
    }

    public RelExprPredefinedPredicate(String flag, Context context) {
        super(context, new QueryNode[0]);
        this.predicate = RmlPredefinedPredicate.BOOL_TO_REL;
        this.flag = flag;
        this.names = ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitPredefined(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformPredefined(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain[] domains = new Domain[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            domains[i] = variablesManager.getDomain(this.names[i]);
        }
        return domains;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        Domain[] domains = new Domain[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            domains[i] = variablesManager.getDomain(this.names[i]);
        }
        switch (this.predicate) {
            case FALSE: {
                return relationsManager.makeEmptyRelation(domains, false);
            }
            case TRUE: {
                return relationsManager.makeEmptyRelation(domains, true);
            }
            case BOOL_TO_REL: {
                return relationsManager.makeEmptyRelation(domains, variablesManager.getVariable(this.flag) != 0);
            }
            case BINARY_EXPANSION: {
                return relationsManager.makeBinaryExpansion(domains[0], domains[1], cancellation);
            }
        }
        throw new DfaInternalException();
    }

    @Override
    public String toLongString() {
        return "RelExprPredefinedPredicate{predicate=" + this.predicate + ", names=" + Arrays.toString(this.names) + ", flag=" + this.flag + "}";
    }

    @Override
    public String toShortString() {
        return this.predicate.name();
    }
}

