/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir;

import com.intellij.rml.dfa.impl.ir.IrProjectImpl;
import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrVirtualCallStmt;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u001c\u0010\u001e\u001a\u00020\u00012\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0 H\u0016J4\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(H\u0002J4\u0010)\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/rml/dfa/impl/ir/IrProjectImpl;", "Lcom/intellij/rml/dfa/ir/IrProject;", "declarations", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "(Ljava/util/List;)V", "allFunctions", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "callGraph", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "getCallGraph", "()Lcom/intellij/rml/dfa/utils/graph/Graph;", "getDeclarations", "()Ljava/util/List;", "recordIdToDecl", "", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "Lcom/intellij/rml/dfa/ir/ast/IrRecordDecl;", "recordsHierarchy", "virtualResolveCache", "Lcom/intellij/rml/dfa/ir/ast/IrVirtualCallStmt;", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "acceptChildren", "getTargetsOfVirtualCall", "callStmt", "mutate", "stmtMutator", "Lkotlin/Function1;", "Lcom/intellij/rml/dfa/ir/ast/IrStatement;", "processSubRecords", "record", "processed", "", "signature", "targets", "", "processSuperRecords", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrProjectImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,109:1\n800#2,11:110\n800#2,11:121\n1#3:132\n372#4,7:133\n*S KotlinDebug\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n*L\n78#1:110,11\n88#1:121,11\n61#1:133,7\n*E\n"})
public final class IrProjectImpl
implements IrProject {
    @NotNull
    private final List<IrTopLevelDecl> declarations;
    @NotNull
    private final MultiMap<String, IrFunctionID> allFunctions;
    @NotNull
    private final Map<IrRecordID, IrRecordDecl> recordIdToDecl;
    @NotNull
    private final MultiMap<IrRecordID, IrRecordID> recordsHierarchy;
    @NotNull
    private final Map<IrVirtualCallStmt, List<IrFunctionID>> virtualResolveCache;
    @NotNull
    private final Graph<IrFunctionID> callGraph;

    public IrProjectImpl(@NotNull List<? extends IrTopLevelDecl> declarations) {
        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
        this.declarations = declarations;
        this.allFunctions = new MultiMap();
        this.recordIdToDecl = new LinkedHashMap();
        this.recordsHierarchy = new MultiMap();
        this.virtualResolveCache = new LinkedHashMap();
        MultiMap calls = new MultiMap();
        Iterable $this$filterIsInstance$iv = this.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : iterable) {
            if (!(element$iv$iv instanceof IrRecordDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrRecordDecl record : (List)destination$iv$iv) {
            this.recordIdToDecl.put(record.getName(), record);
            for (IrRecordID irRecordID : record.getSuperRecords()) {
                this.recordsHierarchy.putValue((Object)irRecordID, (Object)record.getName());
            }
            for (Map.Entry entry : record.getVirtualMethods().entrySet()) {
                String signature = (String)entry.getKey();
                IrFunctionID function2 = (IrFunctionID)entry.getValue();
                this.allFunctions.putValue((Object)signature, (Object)function2);
            }
        }
        $this$filterIsInstance$iv = this.getDeclarations();
        $i$f$filterIsInstance = false;
        Iterable iterable2 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : iterable2) {
            if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrFunctionDecl function3 : (List)destination$iv$iv) {
            function3.accept(new IrRecursiveVisitor((MultiMap<IrFunctionID, IrFunctionID>)calls, function3, this){
                final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
                final /* synthetic */ IrFunctionDecl $function;
                final /* synthetic */ IrProjectImpl this$0;
                {
                    this.$calls = $calls;
                    this.$function = $function;
                    this.this$0 = $receiver;
                }

                @Override
                public void visitStaticCallStmt(@NotNull IrStaticCallStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    this.$calls.putValue((Object)this.$function.getName(), (Object)stmt.getCallee());
                }

                @Override
                public void visitVirtualCallStmt(@NotNull IrVirtualCallStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    this.$calls.putValues((Object)this.$function.getName(), (Collection)this.this$0.getTargetsOfVirtualCall(stmt));
                }
            });
        }
        this.callGraph = GraphKt.buildGraph((Function1)new Function1<GraphBuilder<IrFunctionID>, Unit>((MultiMap<IrFunctionID, IrFunctionID>)calls){
            final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
            {
                this.$calls = $calls;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GraphBuilder<IrFunctionID> $this$buildGraph) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$filterIsInstance$iv = this.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (IrFunctionDecl function2 : (List)destination$iv$iv) {
                    $this$buildGraph.addNode(function2.getName());
                }
                for (IrFunctionID caller : this.$calls.keySet()) {
                    for (IrFunctionID callee : this.$calls.get((Object)caller)) {
                        Intrinsics.checkNotNull((Object)caller);
                        Intrinsics.checkNotNull((Object)callee);
                        $this$buildGraph.addEdge(caller, callee);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public List<IrTopLevelDecl> getDeclarations() {
        return this.declarations;
    }

    @Override
    @NotNull
    public Graph<IrFunctionID> getCallGraph() {
        return this.callGraph;
    }

    @Override
    public void accept(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitProject(this);
    }

    @Override
    public void acceptChildren(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        for (IrTopLevelDecl declaration : this.getDeclarations()) {
            declaration.accept(visitor);
        }
    }

    @Override
    @NotNull
    public IrProject mutate(@NotNull Function1<? super IrStatement, ? extends IrStatement> stmtMutator) {
        Intrinsics.checkNotNullParameter(stmtMutator, (String)"stmtMutator");
        this.accept(new IrRecursiveVisitor(stmtMutator){
            final /* synthetic */ Function1<IrStatement, IrStatement> $stmtMutator;
            {
                this.$stmtMutator = $stmtMutator;
            }

            public void visitBlock(@NotNull IrCFGBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                ((IrCFGBlockImpl)block).getInstructions().replaceAll(arg_0 -> mutate.1.visitBlock$lambda$0(this.$stmtMutator, arg_0));
            }

            private static final IrStatement visitBlock$lambda$0(Function1 $stmtMutator, IrStatement it) {
                Intrinsics.checkNotNullParameter((Object)$stmtMutator, (String)"$stmtMutator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (IrStatement)$stmtMutator.invoke((Object)it);
            }
        });
        return this;
    }

    private final void processSuperRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        IrRecordDecl irRecordDecl = this.recordIdToDecl.get(record);
        Intrinsics.checkNotNull((Object)irRecordDecl);
        for (IrRecordID superRecord : irRecordDecl.getSuperRecords()) {
            if (processed.contains(superRecord)) continue;
            ((Collection)processed).add(superRecord);
            IrRecordDecl irRecordDecl2 = this.recordIdToDecl.get(superRecord);
            Intrinsics.checkNotNull((Object)irRecordDecl2);
            IrFunctionID target = irRecordDecl2.getVirtualMethods().get(signature);
            if (target == null) {
                this.processSuperRecords(superRecord, processed, signature, targets);
                continue;
            }
            ((Collection)targets).add(target);
        }
    }

    private final void processSubRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        ((Collection)processed).add(record);
        IrRecordDecl irRecordDecl = this.recordIdToDecl.get(record);
        Intrinsics.checkNotNull((Object)irRecordDecl);
        IrFunctionID irFunctionID = irRecordDecl.getVirtualMethods().get(signature);
        if (irFunctionID != null) {
            IrFunctionID it = irFunctionID;
            boolean bl = false;
            ((Collection)targets).add(it);
        }
        for (IrRecordID subRecord : this.recordsHierarchy.get((Object)record)) {
            if (processed.contains(subRecord)) continue;
            Intrinsics.checkNotNull((Object)subRecord);
            this.processSubRecords(subRecord, processed, signature, targets);
        }
    }

    @Override
    @NotNull
    public List<IrFunctionID> getTargetsOfVirtualCall(@NotNull IrVirtualCallStmt callStmt) {
        List list;
        Intrinsics.checkNotNullParameter((Object)callStmt, (String)"callStmt");
        Map<IrVirtualCallStmt, List<IrFunctionID>> $this$getOrPut$iv = this.virtualResolveCache;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(callStmt);
        if (value$iv == null) {
            List list2;
            boolean bl = false;
            IrRecordID record = callStmt.getReceiverDeclaredRecord();
            if (record != null) {
                List targets = new ArrayList();
                this.processSuperRecords(record, new LinkedHashSet(), callStmt.getSignature(), targets);
                this.processSubRecords(record, new LinkedHashSet(), callStmt.getSignature(), targets);
                list2 = targets;
            } else {
                Collection collection = this.allFunctions.get((Object)callStmt.getSignature());
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                list2 = CollectionsKt.toList((Iterable)collection);
            }
            List answer$iv = list2;
            $this$getOrPut$iv.put(callStmt, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }
}

