/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.domains;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.console.Console;
import com.intellij.rml.dfa.impl.utils.SortedArrayHelper;
import java.util.Objects;

public class DomainType {
    private final String name;
    private final int index;
    private final boolean isInteger;
    private final boolean isContext;
    private final int fixedBitLength;
    private Domain[] allocatedDomains;
    private Domain specialLastDomain;
    private final boolean isGlobal;
    public static final int MAX_NUM_OF_DOMAINS = 8;
    public static final int MAX_DOMAIN_LENGTH = 30;

    public DomainType(String name, int index, boolean isInteger, boolean isContext, int fixedBitLength, boolean isGlobal) {
        this.name = name;
        this.index = index;
        this.isInteger = isInteger;
        this.isContext = isContext;
        this.fixedBitLength = fixedBitLength;
        this.isGlobal = isGlobal;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isContextType() {
        return this.isContext;
    }

    public boolean isIntegerType() {
        return this.isInteger;
    }

    public int getFixedBitLength() {
        return this.fixedBitLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainType that = (DomainType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Domain getDomain(int index) {
        if (index >= 8) {
            throw new DfaInternalException(Messages.getString(DomainType.class.getName() + "-0"));
        }
        return this.allocatedDomains[index];
    }

    public Domain getSpecialLastDomain() {
        return this.specialLastDomain;
    }

    public int getDomainsCount() {
        return this.allocatedDomains.length;
    }

    public void installDomains(int typeOrder, int typesCount) {
        this.allocatedDomains = new Domain[8];
        for (int i = 0; i < 8; ++i) {
            int firstBit = (typeOrder * 8 + i) * 30;
            this.allocatedDomains[i] = new Domain(this, firstBit);
        }
        int firstBit = (typesCount * 8 + typeOrder) * 30;
        this.specialLastDomain = new Domain(this, firstBit);
    }

    public int getDomainOrder(Domain domain) {
        return SortedArrayHelper.getPosition(this.allocatedDomains, domain);
    }

    public static void printDomainInfo(Console console2, SymbolTable table) {
        DomainType[] types = table.getAvailableDomainTypes();
        console2.println(Messages.getString(DomainType.class.getName() + "-2"));
        for (DomainType type : types) {
            console2.println(type.getName() + Messages.getString(DomainType.class.getName() + "-3") + table.getAttributesInfo(type).getBitLength() + Messages.getString(DomainType.class.getName() + "-4") + table.getAttributesInfo(type).getNumOfAttributes());
        }
    }

    public static Domain[] getCorrespondingDomains(DomainType[] types) {
        Domain[] domains = new Domain[types.length];
        for (int i = 0; i < types.length; ++i) {
            int index = 0;
            for (int j = 0; j < i; ++j) {
                if (types[j] != types[i]) continue;
                ++index;
            }
            domains[i] = types[i].getDomain(index);
        }
        return domains;
    }

    public String toString() {
        return this.name;
    }
}

