/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.bdd;

import com.intellij.rml.dfa.impl.bdd.BitsKt;
import java.util.Arrays;

public final class BddOpCacheTable {
    public static final BddOpCacheTable EMPTY = new BddOpCacheTable();
    public static final int DEFAULT_RETURN_VALUE = -1;
    private long[] key;
    private int[] value;
    private int maxOps;
    private int nrOps;
    private final int maxN;
    private final float f;

    public BddOpCacheTable(int initial, int maxN, float f) {
        int n = BddOpCacheTable.checkSize(initial);
        this.maxN = BddOpCacheTable.checkSize(maxN);
        this.f = f;
        this.maxOps = BddOpCacheTable.maxOps(n, this.maxN, this.f);
        this.key = new long[n];
        this.value = new int[n];
    }

    private BddOpCacheTable() {
        this.maxN = 0;
        this.f = 0.0f;
        this.key = new long[0];
        this.value = new int[0];
    }

    private static int checkSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The number of elements must be non-negative");
        }
        return BitsKt.nextPowerOfTwo(n);
    }

    public int getCapacity() {
        return this.key.length;
    }

    public int getNrOps() {
        return this.nrOps;
    }

    public int get(long mixKey) {
        long[] key = this.key;
        int n = key.length;
        int mask = n - 1;
        int pos = (int)(mixKey & (long)mask);
        if (mixKey == key[pos]) {
            return this.value[pos];
        }
        return -1;
    }

    public void put(long mixKey, int v) {
        long[] key = this.key;
        int n = key.length;
        int mask = n - 1;
        int pos = (int)(mixKey & (long)mask);
        key[pos] = mixKey;
        this.value[pos] = v;
        if (++this.nrOps > this.maxOps) {
            this.grow();
        }
    }

    private void grow() {
        long[] key = this.key;
        int[] value = this.value;
        int n = key.length;
        int newN = n << 1;
        long[] newKey = Arrays.copyOf(key, newN);
        System.arraycopy(key, 0, newKey, n, n);
        int[] newValue = Arrays.copyOf(value, newN);
        System.arraycopy(value, 0, newValue, n, n);
        this.maxOps = BddOpCacheTable.maxOps(newN, this.maxN, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    private static int maxOps(int n, int maxN, float f) {
        return n >= maxN ? Integer.MAX_VALUE : (int)((float)n * f);
    }
}

