/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.bdd;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0018\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\bH\u0002J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003Jc\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\bH\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\u0003H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0015\u0010\u001e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012\u00a8\u00064"}, d2={"Lcom/intellij/rml/dfa/impl/bdd/BddMemoryStat;", "", "nrNodes", "", "nodeArrayCapacity", "nrNodeTableEntries", "nodeTableCapacity", "nodeTableMaxLoadFactor", "", "nrOpCacheOps", "opCacheCapacity", "opCacheMaxCapacity", "opCacheMaxOpsFactor", "(IIIIFIIIF)V", "amortizedTotalBytes", "", "Lcom/intellij/rml/dfa/impl/bdd/ConsumedMemoryBytes;", "getAmortizedTotalBytes", "()J", "getNodeArrayCapacity", "()I", "getNodeTableCapacity", "getNodeTableMaxLoadFactor", "()F", "getNrNodeTableEntries", "getNrNodes", "getNrOpCacheOps", "getOpCacheCapacity", "getOpCacheMaxCapacity", "getOpCacheMaxOpsFactor", "realTotalBytes", "getRealTotalBytes", "amortizedCapacity", "nrOccupied", "f", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.rml.dfa.impl"})
public final class BddMemoryStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int nrNodes;
    private final int nodeArrayCapacity;
    private final int nrNodeTableEntries;
    private final int nodeTableCapacity;
    private final float nodeTableMaxLoadFactor;
    private final int nrOpCacheOps;
    private final int opCacheCapacity;
    private final int opCacheMaxCapacity;
    private final float opCacheMaxOpsFactor;
    private final long realTotalBytes;
    private final long amortizedTotalBytes;
    @NotNull
    private static final BddMemoryStat ZERO = new BddMemoryStat(0, 0, 0, 0, 1.0f, 0, 0, 0, 1.0f);
    public static final int NODE_SIZE = 8;
    public static final int NODE_TABLE_ENTRY_SIZE = 12;
    public static final int OP_CACHE_ENTRY_SIZE = 12;

    public BddMemoryStat(int nrNodes, int nodeArrayCapacity, int nrNodeTableEntries, int nodeTableCapacity, float nodeTableMaxLoadFactor, int nrOpCacheOps, int opCacheCapacity, int opCacheMaxCapacity, float opCacheMaxOpsFactor) {
        this.nrNodes = nrNodes;
        this.nodeArrayCapacity = nodeArrayCapacity;
        this.nrNodeTableEntries = nrNodeTableEntries;
        this.nodeTableCapacity = nodeTableCapacity;
        this.nodeTableMaxLoadFactor = nodeTableMaxLoadFactor;
        this.nrOpCacheOps = nrOpCacheOps;
        this.opCacheCapacity = opCacheCapacity;
        this.opCacheMaxCapacity = opCacheMaxCapacity;
        this.opCacheMaxOpsFactor = opCacheMaxOpsFactor;
        this.realTotalBytes = (long)this.nodeArrayCapacity * (long)8 + (long)this.nodeTableCapacity * (long)12 + (long)this.opCacheCapacity * (long)12;
        this.amortizedTotalBytes = (long)this.amortizedCapacity(this.nrNodes, 1.0f) * (long)8 + (long)this.amortizedCapacity(this.nrNodeTableEntries, this.nodeTableMaxLoadFactor) * (long)12 + (long)RangesKt.coerceAtMost((int)this.amortizedCapacity(this.nrOpCacheOps, this.opCacheMaxOpsFactor), (int)this.opCacheMaxCapacity) * (long)12;
    }

    public final int getNrNodes() {
        return this.nrNodes;
    }

    public final int getNodeArrayCapacity() {
        return this.nodeArrayCapacity;
    }

    public final int getNrNodeTableEntries() {
        return this.nrNodeTableEntries;
    }

    public final int getNodeTableCapacity() {
        return this.nodeTableCapacity;
    }

    public final float getNodeTableMaxLoadFactor() {
        return this.nodeTableMaxLoadFactor;
    }

    public final int getNrOpCacheOps() {
        return this.nrOpCacheOps;
    }

    public final int getOpCacheCapacity() {
        return this.opCacheCapacity;
    }

    public final int getOpCacheMaxCapacity() {
        return this.opCacheMaxCapacity;
    }

    public final float getOpCacheMaxOpsFactor() {
        return this.opCacheMaxOpsFactor;
    }

    public final long getRealTotalBytes() {
        return this.realTotalBytes;
    }

    public final long getAmortizedTotalBytes() {
        return this.amortizedTotalBytes;
    }

    private final int amortizedCapacity(int nrOccupied, float f) {
        return (int)((double)nrOccupied * Math.sqrt(2.0) / (double)f);
    }

    public final int component1() {
        return this.nrNodes;
    }

    public final int component2() {
        return this.nodeArrayCapacity;
    }

    public final int component3() {
        return this.nrNodeTableEntries;
    }

    public final int component4() {
        return this.nodeTableCapacity;
    }

    public final float component5() {
        return this.nodeTableMaxLoadFactor;
    }

    public final int component6() {
        return this.nrOpCacheOps;
    }

    public final int component7() {
        return this.opCacheCapacity;
    }

    public final int component8() {
        return this.opCacheMaxCapacity;
    }

    public final float component9() {
        return this.opCacheMaxOpsFactor;
    }

    @NotNull
    public final BddMemoryStat copy(int nrNodes, int nodeArrayCapacity, int nrNodeTableEntries, int nodeTableCapacity, float nodeTableMaxLoadFactor, int nrOpCacheOps, int opCacheCapacity, int opCacheMaxCapacity, float opCacheMaxOpsFactor) {
        return new BddMemoryStat(nrNodes, nodeArrayCapacity, nrNodeTableEntries, nodeTableCapacity, nodeTableMaxLoadFactor, nrOpCacheOps, opCacheCapacity, opCacheMaxCapacity, opCacheMaxOpsFactor);
    }

    public static /* synthetic */ BddMemoryStat copy$default(BddMemoryStat bddMemoryStat, int n, int n2, int n3, int n4, float f, int n5, int n6, int n7, float f2, int n8, Object object) {
        if ((n8 & 1) != 0) {
            n = bddMemoryStat.nrNodes;
        }
        if ((n8 & 2) != 0) {
            n2 = bddMemoryStat.nodeArrayCapacity;
        }
        if ((n8 & 4) != 0) {
            n3 = bddMemoryStat.nrNodeTableEntries;
        }
        if ((n8 & 8) != 0) {
            n4 = bddMemoryStat.nodeTableCapacity;
        }
        if ((n8 & 0x10) != 0) {
            f = bddMemoryStat.nodeTableMaxLoadFactor;
        }
        if ((n8 & 0x20) != 0) {
            n5 = bddMemoryStat.nrOpCacheOps;
        }
        if ((n8 & 0x40) != 0) {
            n6 = bddMemoryStat.opCacheCapacity;
        }
        if ((n8 & 0x80) != 0) {
            n7 = bddMemoryStat.opCacheMaxCapacity;
        }
        if ((n8 & 0x100) != 0) {
            f2 = bddMemoryStat.opCacheMaxOpsFactor;
        }
        return bddMemoryStat.copy(n, n2, n3, n4, f, n5, n6, n7, f2);
    }

    @NotNull
    public String toString() {
        return "BddMemoryStat(nrNodes=" + this.nrNodes + ", nodeArrayCapacity=" + this.nodeArrayCapacity + ", nrNodeTableEntries=" + this.nrNodeTableEntries + ", nodeTableCapacity=" + this.nodeTableCapacity + ", nodeTableMaxLoadFactor=" + this.nodeTableMaxLoadFactor + ", nrOpCacheOps=" + this.nrOpCacheOps + ", opCacheCapacity=" + this.opCacheCapacity + ", opCacheMaxCapacity=" + this.opCacheMaxCapacity + ", opCacheMaxOpsFactor=" + this.opCacheMaxOpsFactor + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.nrNodes);
        result = result * 31 + Integer.hashCode(this.nodeArrayCapacity);
        result = result * 31 + Integer.hashCode(this.nrNodeTableEntries);
        result = result * 31 + Integer.hashCode(this.nodeTableCapacity);
        result = result * 31 + Float.hashCode(this.nodeTableMaxLoadFactor);
        result = result * 31 + Integer.hashCode(this.nrOpCacheOps);
        result = result * 31 + Integer.hashCode(this.opCacheCapacity);
        result = result * 31 + Integer.hashCode(this.opCacheMaxCapacity);
        result = result * 31 + Float.hashCode(this.opCacheMaxOpsFactor);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BddMemoryStat)) {
            return false;
        }
        BddMemoryStat bddMemoryStat = (BddMemoryStat)other;
        if (this.nrNodes != bddMemoryStat.nrNodes) {
            return false;
        }
        if (this.nodeArrayCapacity != bddMemoryStat.nodeArrayCapacity) {
            return false;
        }
        if (this.nrNodeTableEntries != bddMemoryStat.nrNodeTableEntries) {
            return false;
        }
        if (this.nodeTableCapacity != bddMemoryStat.nodeTableCapacity) {
            return false;
        }
        if (Float.compare(this.nodeTableMaxLoadFactor, bddMemoryStat.nodeTableMaxLoadFactor) != 0) {
            return false;
        }
        if (this.nrOpCacheOps != bddMemoryStat.nrOpCacheOps) {
            return false;
        }
        if (this.opCacheCapacity != bddMemoryStat.opCacheCapacity) {
            return false;
        }
        if (this.opCacheMaxCapacity != bddMemoryStat.opCacheMaxCapacity) {
            return false;
        }
        return Float.compare(this.opCacheMaxOpsFactor, bddMemoryStat.opCacheMaxOpsFactor) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/rml/dfa/impl/bdd/BddMemoryStat$Companion;", "", "()V", "NODE_SIZE", "", "NODE_TABLE_ENTRY_SIZE", "OP_CACHE_ENTRY_SIZE", "ZERO", "Lcom/intellij/rml/dfa/impl/bdd/BddMemoryStat;", "getZERO", "()Lcom/intellij/rml/dfa/impl/bdd/BddMemoryStat;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BddMemoryStat getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

