/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.rml.dfa.devtools.DfaDebugProvider;
import com.intellij.rml.dfa.devtools.actions.DfaAction;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H&J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/rml/dfa/devtools/actions/DfaIRAction;", "Lcom/intellij/rml/dfa/devtools/actions/DfaAction;", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "function", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "isAvailable", "", "intellij.rml.dfa.devtools"})
public abstract class DfaIRAction
extends DfaAction {
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file2 == null) {
            return false;
        }
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        DfaDebugProvider instance = DfaDebugProvider.Companion.getInstance(language);
        return instance.getDevMode() && instance.supportsIR() && instance.isFunction(file2, editor.getCaretModel().getOffset());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file2 == null) {
            return;
        }
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        IrFunctionDecl irFunctionDecl = DfaDebugProvider.Companion.getInstance(language).getIrForFunction(file2, editor.getCaretModel().getOffset());
        if (irFunctionDecl == null) {
            return;
        }
        IrFunctionDecl function2 = irFunctionDecl;
        this.invoke(function2, project);
    }

    public abstract void invoke(@NotNull IrFunctionDecl var1, @NotNull Project var2);
}

