/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.ag;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntImmutableList
extends IntLists.a
implements IntList,
Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 0L;
    static final IntImmutableList a = new IntImmutableList(IntArrays.EMPTY_ARRAY);
    private final int[] b;

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(int[] a2) {
        void var1_1;
        this.b = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(Collection<? extends Integer> c2) {
        this(c2.isEmpty() ? IntArrays.EMPTY_ARRAY : IntIterators.unwrap(IntIterators.asIntIterator(var1_1.iterator())));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(IntCollection c2) {
        this(c2.isEmpty() ? IntArrays.EMPTY_ARRAY : IntIterators.unwrap(var1_1.iterator()));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(IntList l2) {
        this(l2.isEmpty() ? IntArrays.EMPTY_ARRAY : new int[l2.size()]);
        void var1_1;
        l2.getElements(0, this.b, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(int[] a2, int offset, int length) {
        this(length == 0 ? IntArrays.EMPTY_ARRAY : new int[length]);
        void var3_3;
        void var2_2;
        void var1_1;
        System.arraycopy(var1_1, (int)var2_2, this.b, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public IntImmutableList(IntIterator i2) {
        this(i2.hasNext() ? IntIterators.unwrap((IntIterator)var1_1) : IntArrays.EMPTY_ARRAY);
        void var1_1;
    }

    public static IntImmutableList of() {
        return a;
    }

    public static IntImmutableList of(int ... init) {
        int[] nArray;
        if (init.length == 0) {
            return IntImmutableList.of();
        }
        return new IntImmutableList(nArray);
    }

    private static IntImmutableList a(IntArrayList intArrayList) {
        if (intArrayList.isEmpty()) {
            return IntImmutableList.of();
        }
        int[] nArray = intArrayList.elements();
        if (intArrayList.size() != nArray.length) {
            nArray = Arrays.copyOf(nArray, intArrayList.size());
        }
        return new IntImmutableList(nArray);
    }

    public static IntImmutableList toList(IntStream stream) {
        return IntImmutableList.a(IntArrayList.toList(stream));
    }

    /*
     * WARNING - void declaration
     */
    public static IntImmutableList toListWithExpectedSize(IntStream stream, int expectedSize) {
        void var1_1;
        return IntImmutableList.a(IntArrayList.toListWithExpectedSize(stream, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        if (index >= this.b.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.b.length + ")");
        }
        return this.b[var1_1];
    }

    @Override
    public int indexOf(int k2) {
        int n2 = this.b.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (k2 != this.b[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int k2) {
        int n2 = this.b.length;
        while (n2-- != 0) {
            if (k2 != this.b[n2]) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.b.length;
    }

    @Override
    public boolean isEmpty() {
        return this.b.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getElements(int from, int[] a2, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.b, (int)var1_1, var2_2, (int)var3_3, length);
    }

    @Override
    public void forEach(IntConsumer action) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            action.accept(this.b[i2]);
        }
    }

    @Override
    public int[] toIntArray() {
        if (this.b.length == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        return (int[])this.b.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] a2) {
        void var1_1;
        if (a2 == null || a2.length < this.size()) {
            a2 = new int[this.b.length];
        }
        System.arraycopy(this.b, 0, a2, 0, a2.length);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IntListIterator listIterator(int index) {
        void var1_1;
        this.a(index);
        return new IntListIterator(){
            private int a;
            private /* synthetic */ int b;
            private /* synthetic */ IntImmutableList c;
            {
                this.c = intImmutableList;
                this.b = n2;
                this.a = this.b;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.c.b.length;
            }

            @Override
            public final boolean hasPrevious() {
                return this.a > 0;
            }

            @Override
            public final int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.c.b[this.a++];
            }

            @Override
            public final int a() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.c.b[--this.a];
            }

            @Override
            public final int nextIndex() {
                return this.a;
            }

            @Override
            public final int previousIndex() {
                return this.a - 1;
            }

            @Override
            public final void forEachRemaining(IntConsumer action) {
                while (this.a < this.c.b.length) {
                    action.accept(this.c.b[this.a++]);
                }
            }

            @Override
            public final void e_(int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final void f_(int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public IntSpliterator spliterator() {
        return new b(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IntList subList(int from, int to) {
        void var2_2;
        void var1_1;
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.a(from);
        this.a(to);
        if (from == to) {
            return a;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new a(this, (int)var1_1, (int)var2_2);
    }

    public IntImmutableList clone() {
        return this;
    }

    public boolean equals(IntImmutableList l2) {
        int[] nArray;
        if (l2 == this) {
            return true;
        }
        if (this.b == l2.b) {
            return true;
        }
        if (this.size() != l2.size()) {
            return false;
        }
        int[] nArray2 = this.b;
        nArray = nArray.b;
        return Arrays.equals(nArray2, nArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o2) {
        void var1_1;
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        if (o2 instanceof IntImmutableList) {
            return this.equals((IntImmutableList)o2);
        }
        if (o2 instanceof a) {
            return ((AbstractIntList)((a)o2)).equals(this);
        }
        return super.equals(var1_1);
    }

    @Override
    public int compareTo(IntImmutableList l2) {
        int n2;
        int[] nArray;
        if (this.b == l2.b) {
            return 0;
        }
        int n3 = this.size();
        int n4 = l2.size();
        int[] nArray2 = this.b;
        nArray = nArray.b;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = nArray2[n2];
            int n6 = nArray[n2];
            if ((n5 = Integer.compare(n5, n6)) == 0) continue;
            return n5;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 < n3) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(List<? extends Integer> l2) {
        void var1_1;
        if (l2 instanceof IntImmutableList) {
            return this.compareTo((IntImmutableList)l2);
        }
        if (l2 instanceof a) {
            return -((AbstractIntList)((a)l2)).compareTo(this);
        }
        return super.compareTo((List<? extends Integer>)var1_1);
    }

    private final class b
    implements IntSpliterator {
        private int a;
        private int b;
        private /* synthetic */ IntImmutableList d;

        public b(IntImmutableList intImmutableList) {
            this(intImmutableList, 0, intImmutableList.b.length);
        }

        private b(IntImmutableList intImmutableList, int n2, int n3) {
            this.d = intImmutableList;
            assert (n2 <= n3) : "pos " + n2 + " must be <= max " + n3;
            this.a = n2;
            this.b = n3;
        }

        @Override
        public final int characteristics() {
            return 17744;
        }

        @Override
        public final long estimateSize() {
            return this.b - this.a;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryAdvance(IntConsumer action) {
            void var1_1;
            if (this.a >= this.b) {
                return false;
            }
            var1_1.accept(this.d.b[this.a++]);
            return true;
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            while (this.a < this.b) {
                action.accept(this.d.b[this.a]);
                ++this.a;
            }
        }

        @Override
        public final IntSpliterator m_() {
            int n2 = this.b - this.a >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = n2 = this.a + n2;
            int n4 = this.a;
            this.a = n2;
            return new b(this.d, n4, n3);
        }

        @Override
        public final /* synthetic */ Spliterator.OfInt trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.m_();
        }
    }

    private static final class it.unimi.dsi.fastutil.ints.IntImmutableList$a
    extends IntLists.a
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 7054639518438982401L;
        private IntImmutableList d;
        final int a;
        final int b;
        final transient int[] c;

        it.unimi.dsi.fastutil.ints.IntImmutableList$a(IntImmutableList intImmutableList, int n2, int n3) {
            this.d = intImmutableList;
            this.a = n2;
            this.b = n3;
            this.c = intImmutableList.b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getInt(int index) {
            void var1_1;
            this.b(index);
            return this.c[var1_1 + this.a];
        }

        @Override
        public final int indexOf(int k2) {
            for (int i2 = this.a; i2 < this.b; ++i2) {
                if (k2 != this.c[i2]) continue;
                return i2 - this.a;
            }
            return -1;
        }

        @Override
        public final int lastIndexOf(int k2) {
            int n2 = this.b;
            while (n2-- != this.a) {
                if (k2 != this.c[n2]) continue;
                return n2 - this.a;
            }
            return -1;
        }

        @Override
        public final int size() {
            return this.b - this.a;
        }

        @Override
        public final boolean isEmpty() {
            return this.b <= this.a;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void getElements(int fromSublistIndex, int[] a2, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            IntArrays.ensureOffsetLength(a2, offset, length);
            this.b(fromSublistIndex);
            if (this.a + length > this.b) {
                throw new IndexOutOfBoundsException("Final index " + (this.a + length) + " (startingIndex: " + this.a + " + length: " + length + ") is greater then list length " + this.size());
            }
            System.arraycopy(this.c, (int)(var1_1 + this.a), var2_2, (int)var3_3, length);
        }

        @Override
        public final void forEach(IntConsumer action) {
            for (int i2 = this.a; i2 < this.b; ++i2) {
                action.accept(this.c[i2]);
            }
        }

        @Override
        public final int[] toIntArray() {
            return Arrays.copyOfRange(this.c, this.a, this.b);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int[] toArray(int[] a2) {
            void var1_1;
            if (a2 == null || a2.length < this.size()) {
                a2 = new int[this.size()];
            }
            System.arraycopy(this.c, this.a, a2, 0, this.size());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final IntListIterator listIterator(int index) {
            void var1_1;
            this.b(index + this.a);
            return new IntListIterator(){
                private int a;
                private /* synthetic */ int b;
                private /* synthetic */ it.unimi.dsi.fastutil.ints.IntImmutableList$a c;
                {
                    this.c = a2;
                    this.b = n2;
                    this.a = this.b + this.c.a;
                }

                @Override
                public final boolean hasNext() {
                    return this.a < this.c.b;
                }

                @Override
                public final boolean hasPrevious() {
                    return this.a > this.c.a;
                }

                @Override
                public final int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.c.c[this.a++];
                }

                @Override
                public final int a() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    return this.c.c[--this.a];
                }

                @Override
                public final int nextIndex() {
                    return this.a - this.c.a;
                }

                @Override
                public final int previousIndex() {
                    return this.a - this.c.a - 1;
                }

                @Override
                public final void forEachRemaining(IntConsumer action) {
                    while (this.a < this.c.b) {
                        action.accept(this.c.c[this.a++]);
                    }
                }

                @Override
                public final void e_(int n2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final void f_(int n2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final IntSpliterator spliterator() {
            return new a(this);
        }

        private boolean a(int[] nArray, int n2, int n3) {
            if (this.c == nArray && this.a == n2 && this.b == n3) {
                return true;
            }
            if (n3 - n2 != this.size()) {
                return false;
            }
            n3 = this.a;
            while (n3 < this.b) {
                if (this.c[n3++] == nArray[n2++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean equals(Object o2) {
            IntLists.a a2;
            if (o2 == this) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof List)) {
                return false;
            }
            if (o2 instanceof IntImmutableList) {
                a2 = (IntImmutableList)a2;
                return this.a(((IntImmutableList)a2).b, 0, ((IntImmutableList)a2).size());
            }
            if (a2 instanceof it.unimi.dsi.fastutil.ints.IntImmutableList$a) {
                a2 = (it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2;
                return this.a(((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).c, ((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).a, ((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).b);
            }
            return super.equals(a2);
        }

        private int b(int[] nArray, int n2, int n3) {
            if (this.c == nArray && this.a == n2 && this.b == n3) {
                return 0;
            }
            int n4 = this.a;
            int n5 = n2;
            while (n4 < this.b && n4 < n3) {
                n2 = this.c[n4];
                int n6 = nArray[n5];
                if ((n2 = Integer.compare(n2, n6)) != 0) {
                    return n2;
                }
                ++n4;
                ++n5;
            }
            if (n4 < n3) {
                return -1;
            }
            if (n4 < this.b) {
                return 1;
            }
            return 0;
        }

        @Override
        public final int compareTo(List<? extends Integer> l2) {
            IntLists.a a2;
            if (l2 instanceof IntImmutableList) {
                a2 = (IntImmutableList)a2;
                return this.b(((IntImmutableList)a2).b, 0, ((IntImmutableList)a2).size());
            }
            if (a2 instanceof it.unimi.dsi.fastutil.ints.IntImmutableList$a) {
                a2 = (it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2;
                return this.b(((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).c, ((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).a, ((it.unimi.dsi.fastutil.ints.IntImmutableList$a)a2).b);
            }
            return super.compareTo(a2);
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return ((AbstractIntList)this.d).subList(this.a, this.b);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                throw (InvalidObjectException)new InvalidObjectException(runtimeException.getMessage()).initCause(runtimeException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final IntList subList(int from, int to) {
            void var2_2;
            void var1_1;
            this.a(from);
            this.a(to);
            if (from == to) {
                return a;
            }
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new it.unimi.dsi.fastutil.ints.IntImmutableList$a(this.d, (int)(var1_1 + this.a), (int)(var2_2 + this.a));
        }

        private final class a
        extends ag.d {
            private /* synthetic */ it.unimi.dsi.fastutil.ints.IntImmutableList$a c;

            a(it.unimi.dsi.fastutil.ints.IntImmutableList$a a2) {
                this.c = a2;
                super(a2.a, a2.b);
            }

            private a(it.unimi.dsi.fastutil.ints.IntImmutableList$a a2, int n2, int n3) {
                this.c = a2;
                super(n2, n3);
            }

            @Override
            protected final int a(int n2) {
                return this.c.c[n2];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean tryAdvance(IntConsumer action) {
                void var1_1;
                if (this.a >= this.b) {
                    return false;
                }
                var1_1.accept(this.c.c[this.a++]);
                return true;
            }

            @Override
            public final void forEachRemaining(IntConsumer action) {
                int n2 = this.b;
                while (this.a < n2) {
                    action.accept(this.c.c[this.a++]);
                }
            }

            @Override
            public final int characteristics() {
                return 17744;
            }

            @Override
            protected final /* synthetic */ ag.a a(int n2, int n3) {
                int n4 = n3;
                n3 = n2;
                a a2 = this;
                return new a(a2.c, n3, n4);
            }
        }
    }
}

