/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManagerKt;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.text.StringKt;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bJ\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/util/registry/EarlyAccessRegistryManager;", "", "()V", "DISABLE_SAVE_PROPERTY", "", "fileName", "getFileName$annotations", "getBoolean", "", "key", "getOrLoadMap", "", "getString", "invalidate", "", "setAndFlush", "data", "setBoolean", "value", "setString", "syncAndFlush", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEarlyAccessRegistryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n*L\n1#1,197:1\n51#2:198\n59#2:217\n59#2:218\n59#2:219\n1#3:199\n181#4,17:200\n181#4,17:220\n*S KotlinDebug\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n*L\n90#1:198\n123#1:217\n132#1:218\n140#1:219\n114#1:200,17\n142#1:220,17\n*E\n"})
public final class EarlyAccessRegistryManager {
    @NotNull
    public static final EarlyAccessRegistryManager INSTANCE = new EarlyAccessRegistryManager();
    @NotNull
    public static final String fileName = "early-access-registry.txt";
    @NotNull
    public static final String DISABLE_SAVE_PROPERTY = "early.access.registry.disable.saving";

    private EarlyAccessRegistryManager() {
    }

    public static /* synthetic */ void getFileName$annotations() {
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return Boolean.parseBoolean(this.getString(key));
    }

    @Nullable
    public final String getString(@NotNull String key) {
        String string2;
        Intrinsics.checkNotNullParameter(key, "key");
        if (((CharSequence)key).length() == 0) {
            EarlyAccessRegistryManagerKt.access$getLOG().error("Empty key");
            return null;
        }
        ConcurrentHashMap map2 = (ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return StringKt.nullize$default(EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map2, key), false, 1, null);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
        ComponentManager $this$serviceOrNull$iv = application;
        boolean $i$f$serviceOrNull = false;
        RegistryManager registryManager = (RegistryManager)$this$serviceOrNull$iv.getService(RegistryManager.class);
        if (registryManager == null) {
            return EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map2, key);
        }
        RegistryManager registryManager2 = registryManager;
        try {
            string2 = registryManager2.stringValue(key);
        }
        catch (MissingResourceException ignore) {
            string2 = null;
        }
        String value = string2;
        if (value == null) {
            return null;
        }
        map2.putIfAbsent(key, value);
        String it = string2 = value;
        boolean bl2 = false;
        return ((CharSequence)it).length() > 0 ? string2 : null;
    }

    @NotNull
    public final Map<String, String> getOrLoadMap() {
        return (Map)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
    }

    public final void setAndFlush(@NotNull Map<String, String> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        if (!(!LoadingState.COMPONENTS_REGISTERED.isOccurred())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        ConcurrentHashMap map2 = (ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
        map2.putAll(data2);
        Path configFile$iv = EarlyAccessRegistryManagerKt.access$getConfigFile();
        boolean $i$f$saveConfigFile = false;
        if (!Intrinsics.areEqual(System.getProperty(DISABLE_SAVE_PROPERTY), "true")) {
            List lines$iv = new ArrayList();
            Set set = map2.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            for (String key$iv : CollectionsKt.sorted(set)) {
                String value$iv;
                Intrinsics.checkNotNull(key$iv);
                String it = key$iv;
                boolean bl2 = false;
                if ((String)map2.get(it) == null) continue;
                lines$iv.add(key$iv);
                lines$iv.add(value$iv);
            }
            if (lines$iv.isEmpty()) {
                Files.deleteIfExists(configFile$iv);
            } else {
                Files.createDirectories(configFile$iv.getParent(), new FileAttribute[0]);
                Files.write(configFile$iv, (Iterable<? extends CharSequence>)lines$iv, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }

    public final void setBoolean(@NotNull String key, boolean value) {
        block0: {
            Intrinsics.checkNotNullParameter(key, "key");
            ((Map)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue()).put(key, String.valueOf(value));
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = application;
            boolean $i$f$serviceIfCreated = false;
            Object object = (RegistryManager)$this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
            if (object == null || (object = object.get(key)) == null) break block0;
            ((RegistryValue)object).setValue(value);
        }
    }

    public final void setString(@NotNull String key, @NotNull String value) {
        block0: {
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(value, "value");
            ((Map)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue()).put(key, value);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = application;
            boolean $i$f$serviceIfCreated = false;
            Object object = (RegistryManager)$this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
            if (object == null || (object = object.get(key)) == null) break block0;
            ((RegistryValue)object).setValue(value);
        }
    }

    public final void syncAndFlush() {
        block9: {
            ConcurrentHashMap concurrentHashMap = EarlyAccessRegistryManagerKt.access$getMap();
            if (concurrentHashMap == null) {
                return;
            }
            ConcurrentHashMap map2 = concurrentHashMap;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = application;
            boolean $i$f$serviceIfCreated = false;
            RegistryManager registryManager = (RegistryManager)$this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
            if (registryManager == null) {
                return;
            }
            RegistryManager registryManager2 = registryManager;
            try {
                Path configFile$iv = EarlyAccessRegistryManagerKt.access$getConfigFile();
                boolean $i$f$saveConfigFile = false;
                if (Intrinsics.areEqual(System.getProperty(DISABLE_SAVE_PROPERTY), "true")) break block9;
                List lines$iv = new ArrayList();
                Set set = map2.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                for (String key$iv : CollectionsKt.sorted(set)) {
                    String value$iv;
                    String string2;
                    Intrinsics.checkNotNull(key$iv);
                    String it = key$iv;
                    boolean bl2 = false;
                    try {
                        string2 = registryManager2.stringValue(it);
                    }
                    catch (MissingResourceException ignore) {
                        string2 = null;
                    }
                    if (string2 == null) continue;
                    lines$iv.add(key$iv);
                    lines$iv.add(value$iv);
                }
                if (lines$iv.isEmpty()) {
                    Files.deleteIfExists(configFile$iv);
                } else {
                    Files.createDirectories(configFile$iv.getParent(), new FileAttribute[0]);
                    Files.write(configFile$iv, (Iterable<? extends CharSequence>)lines$iv, StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
            catch (Throwable e2) {
                EarlyAccessRegistryManagerKt.access$getLOG().error("cannot save early access registry", e2);
            }
        }
    }

    public final void invalidate() {
        if (!(!LoadingState.COMPONENTS_REGISTERED.isOccurred())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        EarlyAccessRegistryManagerKt.access$getLazyMap$p().drop();
    }
}

