/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.l10n;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.l10n.LocalizationStateService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J&\u0010\u0010\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\t0\u0011H\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0003J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010$\u001a\u00020\u0007H\u0007J\b\u0010%\u001a\u00020&H\u0007J\u001e\u0010'\u001a\u00020\u0015*\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001c\u0010)\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/intellij/l10n/LocalizationUtil;", "", "()V", "LOCALIZATION_FOLDER_NAME", "", "LOCALIZATION_KEY", "isL10nInitialized", "", "l10nPluginIdToLanguageTag", "", "getL10nPluginIdToLanguageTag", "()Ljava/util/Map;", "findLanguageBundle", "Lcom/intellij/DynamicBundle$LanguageBundleEP;", "locale", "Ljava/util/Locale;", "getAllAvailableLocales", "Lkotlin/Pair;", "", "getAllLanguageBundleExtensions", "getFolderLocalizedPaths", "Ljava/nio/file/Path;", "path", "specialLocale", "getForcedLocale", "getLocale", "getLocaleOrNullForDefault", "getLocalizationSuffixes", "getLocalizedPaths", "getLocalizedPathsWithDefault", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "defaultLoader", "getResourceAsStream", "Ljava/io/InputStream;", "getSuffixLocalizedPaths", "isLocalizationInitialized", "setLocalizationInitialized", "", "convertPathToLocaleSuffixUsage", "withRegion", "convertToLocalizationFolderUsage", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,238:1\n1#2:239\n1549#3:240\n1620#3,3:241\n1045#3:245\n13#4:244\n*S KotlinDebug\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n*L\n172#1:240\n172#1:241,3\n235#1:245\n213#1:244\n*E\n"})
public final class LocalizationUtil {
    @NotNull
    public static final LocalizationUtil INSTANCE = new LocalizationUtil();
    private static volatile boolean isL10nInitialized;
    @NotNull
    private static final String LOCALIZATION_FOLDER_NAME = "localization";
    @ApiStatus.Internal
    @NotNull
    public static final String LOCALIZATION_KEY = "i18n.locale";
    @ApiStatus.Internal
    @NotNull
    private static final Map<String, String> l10nPluginIdToLanguageTag;

    private LocalizationUtil() {
    }

    @NotNull
    public final Map<String, String> getL10nPluginIdToLanguageTag() {
        return l10nPluginIdToLanguageTag;
    }

    @ApiStatus.Internal
    @Nullable
    public final String getForcedLocale() {
        String languageTag = System.getProperty(LOCALIZATION_KEY);
        CharSequence charSequence = languageTag;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return languageTag;
    }

    @NotNull
    public final Locale getLocale() {
        String englishTag;
        String forcedLocale = this.getForcedLocale();
        String string2 = forcedLocale;
        if (string2 == null) {
            LocalizationStateService localizationStateService = LocalizationStateService.Companion.getInstance();
            string2 = localizationStateService != null ? localizationStateService.getSelectedLocale() : null;
            if (string2 == null) {
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
                return locale;
            }
        }
        String languageTag = string2;
        Locale locale = Locale.forLanguageTag(languageTag);
        if (forcedLocale == null && !Intrinsics.areEqual(languageTag, englishTag = Locale.ENGLISH.toLanguageTag())) {
            Intrinsics.checkNotNull(locale);
            if (this.findLanguageBundle(locale) == null) {
                Locale locale2 = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue(locale2, "ENGLISH");
                return locale2;
            }
        }
        Intrinsics.checkNotNull(locale);
        return locale;
    }

    @Nullable
    public final Locale getLocaleOrNullForDefault() {
        Locale locale = this.getLocale();
        return Intrinsics.areEqual(locale.getLanguage(), Locale.ENGLISH.getLanguage()) ? null : locale;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader(@Nullable ClassLoader defaultLoader, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        if (Intrinsics.areEqual(locale, Locale.ENGLISH) || Intrinsics.areEqual(locale, Locale.ROOT)) {
            return null;
        }
        DynamicBundle.LanguageBundleEP languageBundleEP = this.findLanguageBundle(locale);
        if (languageBundleEP == null) {
            return null;
        }
        DynamicBundle.LanguageBundleEP langBundle = languageBundleEP;
        Object object = langBundle.pluginDescriptor;
        if (object == null || (object = object.getClassLoader()) == null) {
            object = defaultLoader;
        }
        return object;
    }

    public static /* synthetic */ ClassLoader getPluginClassLoader$default(LocalizationUtil localizationUtil, ClassLoader classLoader, Locale locale, int n2, Object object) {
        if ((n2 & 1) != 0) {
            classLoader = null;
        }
        if ((n2 & 2) != 0) {
            locale = localizationUtil.getLocale();
        }
        return localizationUtil.getPluginClassLoader(classLoader, locale);
    }

    private final Path convertToLocalizationFolderUsage(Path $this$convertToLocalizationFolderUsage, Locale locale, boolean withRegion) {
        Path path = Paths.get(LOCALIZATION_FOLDER_NAME, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        Path result2 = path.resolve(locale.getLanguage());
        if (withRegion) {
            String string2 = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue(string2, "getCountry(...)");
            if (((CharSequence)string2).length() > 0) {
                result2 = result2.resolve(locale.getCountry());
            }
        }
        Path path2 = result2 = result2.resolve($this$convertToLocalizationFolderUsage);
        Intrinsics.checkNotNull(path2);
        return path2;
    }

    private final Path convertPathToLocaleSuffixUsage(Path $this$convertPathToLocaleSuffixUsage, Locale locale, boolean withRegion) {
        Path path;
        if (locale == null) {
            return $this$convertPathToLocaleSuffixUsage;
        }
        StringBuilder fileName = new StringBuilder(PathsKt.getNameWithoutExtension($this$convertPathToLocaleSuffixUsage));
        String extension = PathsKt.getExtension($this$convertPathToLocaleSuffixUsage);
        Path path2 = $this$convertPathToLocaleSuffixUsage.getParent();
        if (path2 == null) {
            Path path3 = Paths.get("", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
        } else {
            path = path2;
        }
        Path foldersPath = path;
        String language = locale.getLanguage();
        Intrinsics.checkNotNull(language);
        if (!(((CharSequence)language).length() == 0)) {
            fileName.append('_').append(language);
            String country = locale.getCountry();
            Intrinsics.checkNotNull(country);
            if (((CharSequence)country).length() > 0 && withRegion) {
                fileName.append('_').append(country);
            }
        }
        if (((CharSequence)extension).length() > 0) {
            fileName.append(".").append(extension);
        }
        Path result2 = foldersPath.resolve(fileName.toString());
        Intrinsics.checkNotNull(result2);
        return result2;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final InputStream getResourceAsStream(@Nullable ClassLoader defaultLoader, @NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null) {
            locale = this.getLocale();
        }
        Locale locale2 = locale;
        List<Path> localizedPaths = this.getLocalizedPaths(path, locale2);
        for (Path localizedPath : localizedPaths) {
            String pathString;
            InputStream inputStream;
            Intrinsics.checkNotNullExpressionValue(FileUtil.toSystemIndependentName(((Object)localizedPath).toString()), "toSystemIndependentName(...)");
            if (defaultLoader == null || (inputStream = defaultLoader.getResourceAsStream(pathString)) == null) continue;
            InputStream it = inputStream;
            boolean bl2 = false;
            return it;
        }
        Object object = LocalizationUtil.getPluginClassLoader$default(this, null, null, 3, null);
        if (object == null || (object = ((ClassLoader)object).getResourceAsStream(((Object)path).toString())) == null) {
            ClassLoader classLoader = defaultLoader;
            object = classLoader != null ? classLoader.getResourceAsStream(((Object)path).toString()) : null;
        }
        return object;
    }

    public static /* synthetic */ InputStream getResourceAsStream$default(LocalizationUtil localizationUtil, ClassLoader classLoader, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 4) != 0) {
            locale = null;
        }
        return localizationUtil.getResourceAsStream(classLoader, path, locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPathsWithDefault(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null) {
            locale = this.getLocale();
        }
        Locale locale2 = locale;
        List it = CollectionsKt.toMutableList((Collection)this.getLocalizedPaths(path, locale2));
        boolean bl2 = false;
        it.add(path);
        return CollectionsKt.distinct(it);
    }

    public static /* synthetic */ List getLocalizedPathsWithDefault$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizedPathsWithDefault(path, locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Locale locale;
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale2 = specialLocale;
        if (locale2 == null) {
            locale2 = this.getLocale();
        }
        if (Intrinsics.areEqual(locale = locale2, Locale.ROOT)) {
            return CollectionsKt.emptyList();
        }
        Path[] pathArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale, true), this.convertPathToLocaleSuffixUsage(path, locale, true), this.convertToLocalizationFolderUsage(path, locale, false), this.convertPathToLocaleSuffixUsage(path, locale, false)};
        return CollectionsKt.distinct((Iterable)CollectionsKt.listOf(pathArray));
    }

    public static /* synthetic */ List getLocalizedPaths$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizedPaths(path, locale);
    }

    @ApiStatus.Internal
    @NotNull
    public final List<String> getLocalizationSuffixes(@Nullable Locale specialLocale) {
        Locale locale = specialLocale;
        if (locale == null && (locale = this.getLocaleOrNullForDefault()) == null) {
            return CollectionsKt.emptyList();
        }
        Locale locale2 = locale;
        List result2 = new ArrayList();
        String string2 = locale2.getLanguage();
        Intrinsics.checkNotNullExpressionValue(string2, "getLanguage(...)");
        if (((CharSequence)string2).length() > 0) {
            String string3 = locale2.getCountry();
            Intrinsics.checkNotNullExpressionValue(string3, "getCountry(...)");
            if (((CharSequence)string3).length() > 0) {
                result2.add('_' + locale2.getLanguage() + '_' + locale2.getCountry());
            }
            result2.add('_' + locale2.getLanguage());
        }
        return result2;
    }

    public static /* synthetic */ List getLocalizationSuffixes$default(LocalizationUtil localizationUtil, Locale locale, int n2, Object object) {
        if ((n2 & 1) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizationSuffixes(locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getFolderLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null && (locale = this.getLocaleOrNullForDefault()) == null) {
            return CollectionsKt.emptyList();
        }
        Locale locale2 = locale;
        Path[] pathArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale2, true), this.convertToLocalizationFolderUsage(path, locale2, false)};
        return CollectionsKt.distinct((Iterable)CollectionsKt.listOf(pathArray));
    }

    public static /* synthetic */ List getFolderLocalizedPaths$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getFolderLocalizedPaths(path, locale);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getSuffixLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        Locale locale = specialLocale;
        if (locale == null) {
            locale = this.getLocale();
        }
        Locale locale2 = locale;
        Object object = new Path[]{this.convertPathToLocaleSuffixUsage(path, locale2, true), this.convertPathToLocaleSuffixUsage(path, locale2, false)};
        object = SetsKt.setOf(object);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(FileUtil.toSystemIndependentName(it.toString()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getSuffixLocalizedPaths$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getSuffixLocalizedPaths(path, locale);
    }

    @ApiStatus.Internal
    public final void setLocalizationInitialized() {
        isL10nInitialized = true;
    }

    @ApiStatus.Internal
    public final boolean isLocalizationInitialized() {
        return isL10nInitialized;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final DynamicBundle.LanguageBundleEP findLanguageBundle(@NotNull Locale locale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(locale, "locale");
            Iterable iterable = this.getAllLanguageBundleExtensions();
            for (Object t2 : iterable) {
                DynamicBundle.LanguageBundleEP it = (DynamicBundle.LanguageBundleEP)t2;
                boolean bl2 = false;
                Locale extensionLocale = Locale.forLanguageTag(it.locale);
                if (!Intrinsics.areEqual(extensionLocale, locale)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ DynamicBundle.LanguageBundleEP findLanguageBundle$default(LocalizationUtil localizationUtil, Locale locale, int n2, Object object) {
        if ((n2 & 1) != 0) {
            locale = localizationUtil.getLocale();
        }
        return localizationUtil.findLanguageBundle(locale);
    }

    @ApiStatus.Internal
    private final List<DynamicBundle.LanguageBundleEP> getAllLanguageBundleExtensions() {
        try {
            block8: {
                block7: {
                    if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                        return CollectionsKt.emptyList();
                    }
                    Application app = ApplicationManager.getApplication();
                    if (app == null) break block7;
                    ExtensionsArea extensionsArea = app.getExtensionArea();
                    ExtensionPointName<DynamicBundle.LanguageBundleEP> extensionPointName = DynamicBundle.LanguageBundleEP.EP_NAME;
                    Intrinsics.checkNotNullExpressionValue(extensionPointName, "EP_NAME");
                    if (extensionsArea.hasExtensionPoint(extensionPointName)) break block8;
                }
                return CollectionsKt.emptyList();
            }
            return DynamicBundle.LanguageBundleEP.EP_NAME.getExtensionList();
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Exception e3) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LocalizationUtil.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error(e3);
            return CollectionsKt.emptyList();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final Pair<List<Locale>, Map<Locale, String>> getAllAvailableLocales() {
        HashSet<Locale> list = new HashSet<Locale>();
        HashMap map2 = new HashMap();
        Object object = this.getAllLanguageBundleExtensions().iterator();
        while (object.hasNext()) {
            DynamicBundle.LanguageBundleEP bundleEP = object.next();
            Locale locale = Locale.forLanguageTag(bundleEP.locale);
            list.add(locale);
            String displayName = bundleEP.displayName;
            CharSequence charSequence = displayName;
            if (charSequence == null || charSequence.length() == 0) continue;
            Map map3 = map2;
            Intrinsics.checkNotNull(locale);
            Intrinsics.checkNotNull(displayName);
            map3.put(locale, displayName);
        }
        Object $this$getAllAvailableLocales_u24lambda_u245 = object = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        $this$getAllAvailableLocales_u24lambda_u245.add(locale);
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        $this$getAllAvailableLocales_u24lambda_u245.addAll(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(map2){
            final /* synthetic */ HashMap $map$inlined;
            {
                this.$map$inlined = hashMap;
            }

            public final int compare(T a2, T b2) {
                Locale it = (Locale)a2;
                boolean bl2 = false;
                String string2 = (String)this.$map$inlined.get(it);
                if (string2 == null) {
                    string2 = it.getDisplayLanguage(Locale.ENGLISH);
                }
                it = (Locale)b2;
                Comparable comparable = (Comparable)((Object)string2);
                bl2 = false;
                String string3 = (String)this.$map$inlined.get(it);
                if (string3 == null) {
                    string3 = it.getDisplayLanguage(Locale.ENGLISH);
                }
                return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string3));
            }
        }));
        return TuplesKt.to(CollectionsKt.build(object), map2);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader(@Nullable ClassLoader defaultLoader) {
        return LocalizationUtil.getPluginClassLoader$default(this, defaultLoader, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader() {
        return LocalizationUtil.getPluginClassLoader$default(this, null, null, 3, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final InputStream getResourceAsStream(@Nullable ClassLoader defaultLoader, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return LocalizationUtil.getResourceAsStream$default(this, defaultLoader, path, null, 4, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPathsWithDefault(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return LocalizationUtil.getLocalizedPathsWithDefault$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return LocalizationUtil.getLocalizedPaths$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<Path> getFolderLocalizedPaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return LocalizationUtil.getFolderLocalizedPaths$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getSuffixLocalizedPaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return LocalizationUtil.getSuffixLocalizedPaths$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final DynamicBundle.LanguageBundleEP findLanguageBundle() {
        return LocalizationUtil.findLanguageBundle$default(this, null, 1, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("com.intellij.ja", "ja"), TuplesKt.to("com.intellij.ko", "ko"), TuplesKt.to("com.intellij.zh", "zh-CN")};
        l10nPluginIdToLanguageTag = MapsKt.mapOf(pairArray);
    }
}

