/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.util.CMakeVersionRange;
import icons.CMakeIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u000f\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0016\u001a\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0016\u001a\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u0016*\u00020\u001f\u001a\f\u0010 \u001a\u0004\u0018\u00010\u0005*\u00020\u0012\u001a\f\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u001f\u001a\n\u0010#\u001a\u00020\u0016*\u00020\u0012\u001a\u001d\u0010$\u001a\u00020\u0004*\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\u0002\u0010(\u001a\u0019\u0010)\u001a\u00020\u0004*\u00020\u00052\u000b\u0010*\u001a\u00070\u0016\u00a2\u0006\u0002\b+H\u0002\u001a\u0012\u0010)\u001a\u00020\u0004*\u00020\u00052\u0006\u0010,\u001a\u00020'\u001a\n\u0010-\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010.\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010/\u001a\u00020\u0004*\u00020\u0005\u001a\n\u00100\u001a\u00020\u0004*\u00020\u0012\u001a\n\u00101\u001a\u00020\u0004*\u00020\u0012\u001a\n\u00102\u001a\u00020\u0004*\u00020\u0012\u001a\f\u00103\u001a\u0004\u0018\u00010\u0012*\u00020\u0005\u001a\u0014\u00104\u001a\u00020\u0016*\f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u000f\u001a\f\u00105\u001a\u0004\u0018\u000106*\u00020\u0016\u001a\u0014\u00107\u001a\f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u000f*\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0015\u0010\t\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\"\u0015\u0010\n\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007*\u0016\u00108\"\b\u0012\u0004\u0012\u00020\f0\u000e2\b\u0012\u0004\u0012\u00020\f0\u000e\u00a8\u00069"}, d2={"VERSION_ARGUMENT_PATTERN", "Ljava/util/regex/Pattern;", "VERSION_PATTERN", "hasParentScope", "", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "getHasParentScope", "(Lcom/jetbrains/cmake/psi/CMakeCommand;)Z", "isListCommand", "isSetCommand", "isUnsetCommand", "compare", "", "ver1", "", "Lcom/jetbrains/cmake/psi/util/CMakeVersion;", "ver2", "getCMakeMinimumVersionArgument", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "minVerCmd", "isForeachSetCommand", "commandName", "", "isIfSetCommand", "isMethodSetCommand", "command", "isVariableRef", "text", "isWhileSetCommand", "stripVariableRef", "findCommandName", "Lcom/jetbrains/cmake/psi/CMakeElement;", "getCommand", "getIcon", "Ljavax/swing/Icon;", "getLiteralText", "isAnyOf", "cmds", "", "Lcom/jetbrains/cmake/completion/contributors/providers/CMakeStandardCommands;", "(Lcom/jetbrains/cmake/psi/CMakeCommand;[Lcom/jetbrains/cmake/completion/contributors/providers/CMakeStandardCommands;)Z", "isCommand", "expectedName", "Lcom/intellij/openapi/util/NlsSafe;", "standardCommand", "isCudaAddExecutable", "isCudaAddLibrary", "isCudaCommand", "isLastArgument", "isNotLastArgument", "isSecondArgument", "secondArgument", "toArgumentString", "toCMakeVersion", "Lcom/jetbrains/cmake/psi/util/CMakeVersionRange;", "toSimpleCMakeVersion", "CMakeVersion", "intellij.cmake.psi"})
@JvmName(name="CMakePsiUtils")
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/jetbrains/cmake/psi/util/CMakePsiUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,261:1\n58#2,2:262\n28#2,12:264\n1747#3,3:276\n1747#3,3:281\n1747#3,3:284\n12474#4,2:279\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/jetbrains/cmake/psi/util/CMakePsiUtils\n*L\n51#1:262,2\n51#1:264,12\n96#1:276,3\n182#1:281,3\n184#1:284,3\n100#1:279,2\n*E\n"})
public final class CMakePsiUtils {
    @NotNull
    private static final Pattern VERSION_PATTERN;
    @NotNull
    private static final Pattern VERSION_ARGUMENT_PATTERN;

    private static final boolean isCommand(CMakeCommand $this$isCommand, String expectedName) {
        Object object = $this$isCommand.getCMakeCommandName();
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object commandName = object;
        return StringsKt.equals((String)commandName, (String)expectedName, (boolean)true);
    }

    public static final boolean isCommand(@NotNull CMakeCommand $this$isCommand, @NotNull CMakeStandardCommands standardCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$isCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)standardCommand), (String)"standardCommand");
        String string = standardCommand.getCommandName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandName(...)");
        return CMakePsiUtils.isCommand($this$isCommand, string);
    }

    @Nullable
    public static final CMakeArgument secondArgument(@NotNull CMakeCommand $this$secondArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$secondArgument, (String)"<this>");
        CMakeArgument cMakeArgument = $this$secondArgument.getFirstArgument();
        return cMakeArgument != null ? cMakeArgument.getNextArgument() : null;
    }

    @Nullable
    public static final String findCommandName(@NotNull CMakeElement $this$findCommandName) {
        CMakeCommandNameMixin mixin;
        Intrinsics.checkNotNullParameter((Object)$this$findCommandName, (String)"<this>");
        CMakeCommandNameMixin cMakeCommandNameMixin = mixin = (CMakeCommandNameMixin)PsiTreeUtil.findChildOfType((PsiElement)$this$findCommandName, CMakeCommandNameMixin.class);
        return cMakeCommandNameMixin != null ? cMakeCommandNameMixin.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CMakeCommand getCommand(@NotNull CMakeArgument $this$getCommand) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block5: {
            void $this$findParentInFile$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getCommand, (String)"<this>");
            PsiElement $this$findParentOfType_u24default$iv = $this$getCommand;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof CMakeCommand) {
                        psiElement2 = current$iv$iv;
                        break block5;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof CMakeCommand)) {
            psiElement = null;
        }
        return (CMakeCommand)((PsiElement)((CMakeCommand)psiElement));
    }

    public static final boolean isSecondArgument(@NotNull CMakeArgument $this$isSecondArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$isSecondArgument, (String)"<this>");
        CMakeArgument previousArgument = $this$isSecondArgument.getPreviousArgument();
        return previousArgument != null && previousArgument.getPreviousArgument() == null;
    }

    public static final boolean isLastArgument(@NotNull CMakeArgument $this$isLastArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$isLastArgument, (String)"<this>");
        return $this$isLastArgument.getNextArgument() == null;
    }

    public static final boolean isNotLastArgument(@NotNull CMakeArgument $this$isNotLastArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotLastArgument, (String)"<this>");
        return !CMakePsiUtils.isLastArgument($this$isNotLastArgument);
    }

    public static final boolean isVariableRef(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.startsWith$default((String)text, (String)"${", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"}", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String stripVariableRef(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text.substring(2, text.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static final boolean getHasParentScope(@NotNull CMakeCommand $this$hasParentScope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasParentScope, (String)"<this>");
        if (!CMakePsiUtils.isSetCommand($this$hasParentScope) && !CMakePsiUtils.isUnsetCommand($this$hasParentScope)) {
            return false;
        }
        List<CMakeArgument> list2 = $this$hasParentScope.getCMakeArgumentList();
        if (list2 != null) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CMakeArgument it = (CMakeArgument)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it.getValue(), (String)"parent_scope", (boolean)true)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isAnyOf(@NotNull CMakeCommand $this$isAnyOf, @NotNull CMakeStandardCommands[] cmds) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isAnyOf, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cmds, (String)"cmds");
            CMakeStandardCommands[] $this$any$iv = cmds;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                CMakeStandardCommands element$iv;
                CMakeStandardCommands it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!CMakePsiUtils.isCommand($this$isAnyOf, it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isSetCommand(@NotNull CMakeCommand $this$isSetCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$isSetCommand, (String)"<this>");
        return CMakePsiUtils.isCommand($this$isSetCommand, CMakeStandardCommands.SET_COMMAND_NAME);
    }

    public static final boolean isUnsetCommand(@NotNull CMakeCommand $this$isUnsetCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsetCommand, (String)"<this>");
        return CMakePsiUtils.isCommand($this$isUnsetCommand, CMakeStandardCommands.UNSET);
    }

    public static final boolean isListCommand(@NotNull CMakeCommand $this$isListCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$isListCommand, (String)"<this>");
        return CMakePsiUtils.isCommand($this$isListCommand, CMakeStandardCommands.LIST);
    }

    public static final boolean isIfSetCommand(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.IF, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ELSE, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ELSEIF, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDIF, commandName);
    }

    public static final boolean isWhileSetCommand(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.WHILE, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDWHILE, commandName);
    }

    public static final boolean isForeachSetCommand(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.FOREACH, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDFOREACH, commandName);
    }

    public static final boolean isMethodSetCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.MACRO, command) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDMACRO, command) || CMakeStandardCommands.isCommand(CMakeStandardCommands.FUNCTION, command) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDFUNCTION, command) || CMakeStandardCommands.isCommand(CMakeStandardCommands.BLOCK, command) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDBLOCK, command);
    }

    @NotNull
    public static final String toArgumentString(@NotNull List<Integer> $this$toArgumentString) {
        Intrinsics.checkNotNullParameter($this$toArgumentString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$toArgumentString, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    public static final int compare(@NotNull List<Integer> ver1, @NotNull List<Integer> ver2) {
        int it;
        boolean $i$f$any;
        Intrinsics.checkNotNullParameter(ver1, (String)"ver1");
        Intrinsics.checkNotNullParameter(ver2, (String)"ver2");
        int n = Math.min(ver1.size(), ver2.size());
        for (int i = 0; i < n; ++i) {
            if (((Number)ver1.get(i)).intValue() < ((Number)ver2.get(i)).intValue()) {
                return -1;
            }
            if (((Number)ver1.get(i)).intValue() <= ((Number)ver2.get(i)).intValue()) continue;
            return 1;
        }
        if (ver1.size() < ver2.size()) {
            boolean bl;
            block12: {
                Iterable $this$any$iv = CollectionsKt.takeLast(ver2, (int)(ver2.size() - ver1.size()));
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (!(it != 0)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return -1;
            }
        }
        if (ver1.size() > ver2.size()) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = CollectionsKt.takeLast(ver1, (int)(ver1.size() - ver2.size()));
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = ((Number)element$iv).intValue();
                        boolean bl3 = false;
                        if (!(it != 0)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final CMakeArgument getCMakeMinimumVersionArgument(@NotNull CMakeCommand minVerCmd) {
        Intrinsics.checkNotNullParameter((Object)minVerCmd, (String)"minVerCmd");
        if (!CMakeStandardCommands.isCommand(CMakeStandardCommands.CMAKE_MINIMUM_REQUIRED, CMakePsiUtils.findCommandName(minVerCmd))) return null;
        if (minVerCmd.getCMakeArgumentList() == null) return null;
        List<CMakeArgument> list2 = minVerCmd.getCMakeArgumentList();
        Intrinsics.checkNotNull(list2);
        if (list2.size() < 2) return null;
        List<CMakeArgument> list3 = minVerCmd.getCMakeArgumentList();
        Intrinsics.checkNotNull(list3);
        CMakeArgument cMakeArgument = list3.get(1);
        return cMakeArgument;
    }

    @Nullable
    public static final CMakeVersionRange toCMakeVersion(@NotNull String $this$toCMakeVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toCMakeVersion, (String)"<this>");
        Matcher m = VERSION_ARGUMENT_PATTERN.matcher($this$toCMakeVersion);
        if (m.matches()) {
            if (m.group("maxVersion") != null) {
                String string = m.group("minVersion");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                List<Integer> list2 = CMakePsiUtils.toSimpleCMakeVersion(string);
                String string2 = m.group("maxVersion");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                return new CMakeVersionRange(list2, CMakePsiUtils.toSimpleCMakeVersion(string2));
            }
            String string = m.group("minVersion");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            return new CMakeVersionRange(CMakePsiUtils.toSimpleCMakeVersion(string), CollectionsKt.emptyList());
        }
        return null;
    }

    @NotNull
    public static final List<Integer> toSimpleCMakeVersion(@NotNull String $this$toSimpleCMakeVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleCMakeVersion, (String)"<this>");
        Matcher matcher = VERSION_PATTERN.matcher($this$toSimpleCMakeVersion);
        List results = new ArrayList();
        while (matcher.find()) {
            String string = $this$toSimpleCMakeVersion.substring(matcher.start(), matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            results.add(Integer.parseInt(string));
        }
        return results;
    }

    @NotNull
    public static final String getLiteralText(@NotNull CMakeArgument $this$getLiteralText) {
        Intrinsics.checkNotNullParameter((Object)$this$getLiteralText, (String)"<this>");
        CMakeLiteral cMakeLiteral = $this$getLiteralText.getCMakeLiteral();
        String string = cMakeLiteral != null ? cMakeLiteral.getText() : null;
        if (string == null) {
            String string2 = $this$getLiteralText.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        return string;
    }

    public static final boolean isCudaAddExecutable(@NotNull CMakeCommand $this$isCudaAddExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$isCudaAddExecutable, (String)"<this>");
        return $this$isCudaAddExecutable.namesEqual("cuda_add_executable");
    }

    public static final boolean isCudaAddLibrary(@NotNull CMakeCommand $this$isCudaAddLibrary) {
        Intrinsics.checkNotNullParameter((Object)$this$isCudaAddLibrary, (String)"<this>");
        return $this$isCudaAddLibrary.namesEqual("cuda_add_library");
    }

    public static final boolean isCudaCommand(@NotNull CMakeCommand $this$isCudaCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$isCudaCommand, (String)"<this>");
        return CMakePsiUtils.isCudaAddExecutable($this$isCudaCommand) || CMakePsiUtils.isCudaAddLibrary($this$isCudaCommand);
    }

    @Nullable
    public static final Icon getIcon(@NotNull CMakeElement $this$getIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getIcon, (String)"<this>");
        CMakeElement cMakeElement = $this$getIcon;
        return cMakeElement instanceof CMakeFile ? CMakeIcons.CMake : (cMakeElement instanceof CMakeFunctionCommand ? CMakeIcons.CMake_Function : (cMakeElement instanceof CMakeMacroCommand ? CMakeIcons.CMake_Macro : (cMakeElement instanceof CMakeCommand ? (CMakePsiUtils.isCommand((CMakeCommand)$this$getIcon, CMakeStandardCommands.ADD_EXECUTABLE_COMMAND_NAME) || CMakePsiUtils.isCudaAddExecutable((CMakeCommand)$this$getIcon) ? CMakeIcons.AddExecutable : (CMakePsiUtils.isCommand((CMakeCommand)$this$getIcon, CMakeStandardCommands.ADD_LIBRARY_COMMAND_NAME) || CMakePsiUtils.isCudaAddLibrary((CMakeCommand)$this$getIcon) ? CMakeIcons.AddLibrary : (CMakePsiUtils.isCommand((CMakeCommand)$this$getIcon, CMakeStandardCommands.ADD_TEST) ? CMakeIcons.AddTest : (CMakePsiUtils.isSetCommand((CMakeCommand)$this$getIcon) ? CMakeIcons.Variables : null)))) : null)));
    }

    static {
        Pattern pattern = Pattern.compile("[0-9]+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        VERSION_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("(?<minVersion>[0-9]+(\\.[0-9]+)*)(\\.\\.\\.(?<maxVersion>[0-9]+(\\.[0-9]+)*))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        VERSION_ARGUMENT_PATTERN = pattern2;
    }
}

