/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.interpreter;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeScope {
    private HashMap<String, String> myVars = new HashMap();

    @Nullable
    public String getVariableValue(@NotNull String name2) {
        if (name2 == null) {
            CMakeScope.$$$reportNull$$$0(0);
        }
        return this.myVars.get(name2);
    }

    public void setVariableValue(@NotNull String name2, @Nullable String value) {
        if (name2 == null) {
            CMakeScope.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)value)) {
            this.myVars.remove(name2);
        } else {
            this.myVars.put(name2, value);
        }
    }

    @Nullable
    public String eval(@NotNull String str) {
        if (str == null) {
            CMakeScope.$$$reportNull$$$0(2);
        }
        if (!str.contains("${") && !str.contains("\\")) {
            return str;
        }
        ArrayList<StringFragment> fragments = new ArrayList<StringFragment>();
        CMakeScope.parseFragments(str, 0, fragments, 0);
        return CMakeScope.evalFragments(fragments, this);
    }

    @Nullable
    public static String evalFragments(@NotNull List<StringFragment> fragments, @NotNull CMakeScope scope) {
        if (fragments == null) {
            CMakeScope.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            CMakeScope.$$$reportNull$$$0(4);
        }
        StringBuilder result2 = new StringBuilder();
        for (StringFragment fragment : fragments) {
            if (fragment.eval(scope, result2)) continue;
            return null;
        }
        return result2.toString();
    }

    private static int parseFragments(@NotNull String str, int from, @NotNull List<StringFragment> fragments, int braceDepth) {
        int cur;
        int len;
        if (str == null) {
            CMakeScope.$$$reportNull$$$0(5);
        }
        if (fragments == null) {
            CMakeScope.$$$reportNull$$$0(6);
        }
        if (from >= (len = str.length())) {
            return from;
        }
        for (cur = from; cur < len; ++cur) {
            char c = str.charAt(cur);
            if (c == '\\') {
                String prefix = str.substring(from, cur);
                String suffix = "";
                if (++cur < len) {
                    char next = str.charAt(cur);
                    suffix = next == ';' ? "\\;" : Character.toString(next);
                }
                fragments.add(new PlainStringFragment(prefix + suffix));
                from = ++cur;
            } else {
                if (c == '}' && braceDepth > 0) break;
                if (c == '$' && cur + 1 < len && str.charAt(cur + 1) == '{') {
                    ArrayList<StringFragment> fs;
                    int start2;
                    if (from < cur) {
                        fragments.add(new PlainStringFragment(str.substring(from, cur)));
                    }
                    boolean valid = (cur = CMakeScope.parseFragments(str, start2 = cur + 2, fs = new ArrayList<StringFragment>(), braceDepth + 1)) < len;
                    fragments.add(new VarStringFragment(str.substring(start2, cur), fs, valid));
                    from = cur + 1;
                }
            }
            if (cur >= len) break;
        }
        if (from < cur) {
            fragments.add(new PlainStringFragment(str.substring(from, cur)));
        }
        return cur;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/interpreter/CMakeScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setVariableValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "eval";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evalFragments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class StringFragment {
        @NotNull
        private final String myString;

        StringFragment(@NotNull String string) {
            if (string == null) {
                StringFragment.$$$reportNull$$$0(0);
            }
            this.myString = string;
        }

        public abstract boolean eval(@NotNull CMakeScope var1, @NotNull StringBuilder var2);

        @NotNull
        protected String getFragmentString() {
            String string = this.myString;
            if (string == null) {
                StringFragment.$$$reportNull$$$0(1);
            }
            return string;
        }

        abstract boolean isValid();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cmake/interpreter/CMakeScope$StringFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cmake/interpreter/CMakeScope$StringFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragmentString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PlainStringFragment
    extends StringFragment {
        PlainStringFragment(String string) {
            super(string);
        }

        @Override
        public boolean eval(@NotNull CMakeScope scope, @NotNull StringBuilder result2) {
            if (scope == null) {
                PlainStringFragment.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                PlainStringFragment.$$$reportNull$$$0(1);
            }
            result2.append(this.getFragmentString());
            return true;
        }

        @Override
        boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cmake/interpreter/CMakeScope$PlainStringFragment";
            objectArray[2] = "eval";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VarStringFragment
    extends StringFragment {
        @NotNull
        private final List<StringFragment> myFragments;
        private final boolean myValid;

        VarStringFragment(@NotNull String string, @NotNull List<StringFragment> fragments, boolean valid) {
            if (string == null) {
                VarStringFragment.$$$reportNull$$$0(0);
            }
            if (fragments == null) {
                VarStringFragment.$$$reportNull$$$0(1);
            }
            super(string);
            this.myFragments = fragments;
            this.myValid = valid;
        }

        @Override
        public boolean eval(@NotNull CMakeScope scope, @NotNull StringBuilder result2) {
            if (scope == null) {
                VarStringFragment.$$$reportNull$$$0(2);
            }
            if (result2 == null) {
                VarStringFragment.$$$reportNull$$$0(3);
            }
            if (!this.isValid()) {
                return false;
            }
            String name2 = CMakeScope.evalFragments(this.myFragments, scope);
            if (name2 == null) {
                return false;
            }
            String value = scope.getVariableValue(name2);
            if (value == null) {
                return false;
            }
            result2.append(value);
            return true;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cmake/interpreter/CMakeScope$VarStringFragment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eval";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

