/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.cmake.completion.contributors.providers.CMakeKnownLiteralsProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.highlighting.CMakeHighlighterAnnotator;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeVariableName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "addMarkup", "", "element", "Lcom/intellij/psi/PsiNamedElement;", "clone", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "Lcom/intellij/psi/PsiElement;", "intellij.cmake.psi"})
public final class CMakeRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof CMakeFile;
    }

    public void visit(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof CMakeVariableName || element2 instanceof CMakeArgument && !CMakeHighlighterAnnotator.Companion.isStringLikeArgument(element2) && !CMakeDocumentationUtilKt.isProperty((CMakeArgument)element2)) {
            this.addMarkup((PsiNamedElement)element2);
        }
    }

    private final void addMarkup(PsiNamedElement element2) {
        PsiElement context2;
        String id = element2.getName();
        if (id != null && !CMakeKnownLiteralsProvider.isReserved(id) && !CMakeKnownLiteralsProvider.isNumeric(id) && (context2 = (PsiElement)element2.getContainingFile()) != null) {
            HighlightInfo attrs = this.getInfo(context2, (PsiElement)element2, id, null);
            this.addInfo(attrs);
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return (HighlightVisitor)new CMakeRainbowVisitor();
    }
}

