/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cmake.formatting.CMakeCodeBlock;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeFormattingUtils {
    public static boolean textBetweenChildrenContainsLineBreak(@NotNull CMakeCodeBlock child1, @NotNull CMakeCodeBlock child2) {
        if (child1 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(0);
        }
        if (child2 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(1);
        }
        return CMakeFormattingUtils.textBetweenChildrenContainsLineBreak(child1.getNode(), child2.getNode());
    }

    public static boolean textBetweenChildrenContainsLineBreak(@NotNull ASTNode child1, @NotNull ASTNode child2) {
        if (child1 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(2);
        }
        if (child2 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(3);
        }
        PsiElement firstPsiElement = child1.getPsi();
        int to = child2.getTextRange().getStartOffset();
        PsiElement nextElement = firstPsiElement;
        while (nextElement != null && nextElement.getTextRange().getStartOffset() < to) {
            ASTNode nextElementNode;
            if ((nextElement = PsiTreeUtil.nextLeaf((PsiElement)nextElement)) == null || (nextElementNode = nextElement.getNode()).getElementType() != TokenType.WHITE_SPACE || !StringUtil.containsLineBreak((CharSequence)nextElementNode.getText())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T rparShouldBeIndented(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node2, @Nullable T offset, @Nullable T zeroOffset) {
        if (parentNode == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(4);
        }
        if (node2 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(5);
        }
        if (node2.getElementType() == CMakeTokenTypes.RPAR) {
            CMakeCodeStyleSettings settings2 = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)node2.getPsi().getContainingFile().getOriginalFile(), CMakeCodeStyleSettings.class);
            ASTNode parentAstNode = parentNode.getNode();
            if (parentAstNode.getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS) {
                boolean controlFlowCmd;
                String cmdName = CMakePsiUtils.findCommandName((CMakeElement)parentAstNode.getPsi().getParent());
                boolean bl = controlFlowCmd = CMakePsiUtils.isIfSetCommand(cmdName) || CMakePsiUtils.isWhileSetCommand(cmdName) || CMakePsiUtils.isForeachSetCommand(cmdName);
                if (settings2.ALIGN_COMMAND_CALL_R_PAR && !controlFlowCmd || settings2.ALIGN_CONTROL_FLOW_R_PAR && controlFlowCmd) {
                    return offset;
                }
                return zeroOffset;
            }
            return zeroOffset;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/formatting/CMakeFormattingUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "textBetweenChildrenContainsLineBreak";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rparShouldBeIndented";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

