/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMapper;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteProjectUtil {
    public static final String SOURCE_UPLOAD_MARKER = ".clion.source.upload.marker";

    @RequiresBackgroundThread
    public static void syncToHosts(@NotNull List<CPPEnvironment> remoteEnvs, @NotNull Project project, @NotNull String projectDir, @NotNull List<String> excludeList) throws ExecutionException {
        if (remoteEnvs == null) {
            RemoteProjectUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RemoteProjectUtil.$$$reportNull$$$0(1);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(2);
        }
        if (excludeList == null) {
            RemoteProjectUtil.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertBackgroundThread();
        RemoteDeployment remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class);
        if (remoteDeployment == null) {
            return;
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: upload project to " + remoteEnvs.size() + " hosts");
        }
        ArrayList<CompletionStage> uploads = new ArrayList<CompletionStage>(remoteEnvs.size());
        if (Registry.is((String)"clion.remote.resync.system.cache", (boolean)false)) {
            remoteEnvs.forEach(env -> env.getHostMachine().invalidateCache());
        }
        ExecutionException ex = null;
        HashSet<String> hosts = new HashSet<String>(remoteEnvs.size());
        for (CPPEnvironment cPPEnvironment : remoteEnvs) {
            RemoteCredentials credentials;
            String hostId;
            HostMachine host = cPPEnvironment.getHostMachine();
            assert (host.isRemote());
            if (host instanceof CidrWSLHost || !remoteDeployment.isDeploymentConfigSFTP(hostId = host.getHostId()) || (credentials = RemoteUtil.getCredentials(host)) == null) continue;
            OSType osType = host.getOSType();
            PathMapper pathMapper = RemoteDeploymentHelper.getPathMapper(hostId, project);
            if (pathMapper == null) continue;
            try {
                remoteDeployment.addExcludedPaths(hostId, project, excludeList);
                boolean isUploaded = RemoteProjectUtil.isRemoteProjectUploaded(osType, credentials, projectDir, pathMapper);
                if (RemoteHostUtil.LOG.isDebugEnabled()) {
                    RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: project is uploaded: " + isUploaded);
                }
                if (!isUploaded) {
                    CompletionStage future = remoteDeployment.upload(hostId, project).thenRun(() -> RemoteProjectUtil.markRemoteProjectAsUploaded(osType, credentials, projectDir, pathMapper));
                    uploads.add(future);
                }
            }
            catch (ExecutionException e) {
                if (ex == null) {
                    ex = e;
                }
                ex.addSuppressed((Throwable)e);
            }
            hosts.add(hostId);
        }
        remoteDeployment.subscribeForUploading(project, hosts);
        for (Future future : uploads) {
            RemoteDeploymentHelper.waitForTransferOperation(future);
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static boolean isRemoteProjectUploaded(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String projectDir, @Nullable PathMapper pathMapper) throws ExecutionException {
        if (osType == null) {
            RemoteProjectUtil.$$$reportNull$$$0(4);
        }
        if (credentials == null) {
            RemoteProjectUtil.$$$reportNull$$$0(5);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(6);
        }
        if (pathMapper == null) {
            return false;
        }
        String remotePath = pathMapper.convertToRemote(projectDir);
        String markerPath = remotePath + "/.clion.source.upload.marker";
        return RemoteUtil.fileExists(osType, credentials, markerPath);
    }

    private static void markRemoteProjectAsUploaded(@NotNull OSType osType, @NotNull RemoteCredentials credentials, @NotNull String projectDir, @NotNull PathMapper pathMapper) {
        if (osType == null) {
            RemoteProjectUtil.$$$reportNull$$$0(7);
        }
        if (credentials == null) {
            RemoteProjectUtil.$$$reportNull$$$0(8);
        }
        if (projectDir == null) {
            RemoteProjectUtil.$$$reportNull$$$0(9);
        }
        if (pathMapper == null) {
            RemoteProjectUtil.$$$reportNull$$$0(10);
        }
        String remotePath = pathMapper.convertToRemote(projectDir);
        String markerPath = remotePath + "/.clion.source.upload.marker";
        try {
            RemoteUtil.touch(osType, credentials, markerPath);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteEnvs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeList";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/system/RemoteProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "syncToHosts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoteProjectUploaded";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "markRemoteProjectAsUploaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

