/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Decompressor;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class DecompressorErrorHandler {
    @Nls
    private static final String SKIP = ToolchainsBundle.message("skip", new Object[0]);
    @Nls
    private static final String SKIP_ALL = ToolchainsBundle.message("skip.all", new Object[0]);
    @Nls
    private static final String ABORT = ToolchainsBundle.message("abort", new Object[0]);
    @Nls
    private static final String RETRY = ToolchainsBundle.message("retry", new Object[0]);
    private final AtomicBoolean abortFlag = new AtomicBoolean(false);

    DecompressorErrorHandler() {
    }

    Decompressor.ErrorHandlerChoice handleError(Decompressor.Entry entry, IOException ioException) {
        if (!Registry.is((String)"clion.remote.tar.use.ui.error.handler")) {
            return Decompressor.ErrorHandlerChoice.SKIP;
        }
        AtomicReference<Object> result2 = new AtomicReference<Object>(null);
        String message = ToolchainsBundle.message("extraction.failed.message", entry.name, ioException.getClass().getSimpleName() + ": " + ioException.getLocalizedMessage());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            MessageDialogBuilder.Message dialog2 = new MessageDialogBuilder.Message(ToolchainsBundle.message("extraction.failed", new Object[0]), message).buttons(new String[]{SKIP, SKIP_ALL, RETRY, ABORT}).defaultButton(ABORT);
            result2.set(dialog2.show(null, null));
        });
        Decompressor.ErrorHandlerChoice choice = DecompressorErrorHandler.convertResultToChoice(result2);
        if (choice == Decompressor.ErrorHandlerChoice.ABORT) {
            this.abortFlag.set(true);
        }
        return choice;
    }

    @NotNull
    private static Decompressor.ErrorHandlerChoice convertResultToChoice(AtomicReference<String> result2) {
        String resultValue = result2.get();
        if (resultValue.equals(ABORT)) {
            Decompressor.ErrorHandlerChoice errorHandlerChoice = Decompressor.ErrorHandlerChoice.ABORT;
            if (errorHandlerChoice == null) {
                DecompressorErrorHandler.$$$reportNull$$$0(0);
            }
            return errorHandlerChoice;
        }
        if (resultValue.equals(SKIP_ALL)) {
            Decompressor.ErrorHandlerChoice errorHandlerChoice = Decompressor.ErrorHandlerChoice.SKIP_ALL;
            if (errorHandlerChoice == null) {
                DecompressorErrorHandler.$$$reportNull$$$0(1);
            }
            return errorHandlerChoice;
        }
        if (resultValue.equals(SKIP)) {
            Decompressor.ErrorHandlerChoice errorHandlerChoice = Decompressor.ErrorHandlerChoice.SKIP;
            if (errorHandlerChoice == null) {
                DecompressorErrorHandler.$$$reportNull$$$0(2);
            }
            return errorHandlerChoice;
        }
        if (resultValue.equals(RETRY)) {
            Decompressor.ErrorHandlerChoice errorHandlerChoice = Decompressor.ErrorHandlerChoice.RETRY;
            if (errorHandlerChoice == null) {
                DecompressorErrorHandler.$$$reportNull$$$0(3);
            }
            return errorHandlerChoice;
        }
        Decompressor.ErrorHandlerChoice errorHandlerChoice = Decompressor.ErrorHandlerChoice.BAIL_OUT;
        if (errorHandlerChoice == null) {
            DecompressorErrorHandler.$$$reportNull$$$0(4);
        }
        return errorHandlerChoice;
    }

    boolean abortSelected() {
        return this.abortFlag.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/system/DecompressorErrorHandler", "convertResultToChoice"));
    }
}

